/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.connection.PriorityMessageQueue;
import com.limegroup.gnutella.connection.SimpleMessageQueue;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.util.HashMap;

public class CompositeQueue
implements MessageQueue {
    private MessageQueue[] _queues = new MessageQueue[9];
    private int _queued = 0;
    private int _priority = 0;
    private int _priorityHint = 0;
    private boolean _cycled = true;
    private int _dropped = 0;
    private static final int BIG_QUEUE_SIZE = 100;
    private static final int QUEUE_SIZE = 1;
    private static final int BIG_QUEUE_TIME = 10000;
    public static final int QUEUE_TIME = 5000;
    private static final int PRIORITIES = 9;
    private static final int PRIORITY_CONTROL = 0;
    private static final int PRIORITY_WATCHDOG = 1;
    private static final int PRIORITY_PUSH = 2;
    private static final int PRIORITY_QUERY_REPLY = 3;
    private static final int PRIORITY_QUERY = 4;
    private static final int PRIORITY_PING_REPLY = 5;
    private static final int PRIORITY_PING = 6;
    private static final int PRIORITY_OTHER = 7;
    private static final int PRIORITY_OUR_QUERY = 8;

    public CompositeQueue() {
        this(10000, 100, 5000, 1);
    }

    public CompositeQueue(int n, int n2, int n3, int n4) {
        this._queues[0] = new SimpleMessageQueue(10, Integer.MAX_VALUE, n2, false);
        this._queues[1] = new SimpleMessageQueue(1, Integer.MAX_VALUE, n2, true);
        this._queues[2] = new PriorityMessageQueue(6, n, n2);
        this._queues[3] = new PriorityMessageQueue(6, n, n2);
        this._queues[4] = new PriorityMessageQueue(3, n3, n2);
        this._queues[5] = new PriorityMessageQueue(1, n3, n4);
        this._queues[6] = new PriorityMessageQueue(1, n3, n4);
        this._queues[8] = new PriorityMessageQueue(10, n, n2);
        this._queues[7] = new SimpleMessageQueue(1, Integer.MAX_VALUE, n2, false);
    }

    public void add(Message message) {
        int n = this.calculatePriority(message);
        MessageQueue messageQueue = this._queues[n];
        messageQueue.add(message);
        int n2 = messageQueue.resetDropped();
        this._dropped += n2;
        this._queued += 1 - n2;
        this._priorityHint = n;
    }

    private int calculatePriority(Message message) {
        if (message instanceof VendorMessage.ControlMessage) {
            return 0;
        }
        byte by = message.getFunc();
        switch (by) {
            case -128: {
                return ((QueryRequest)message).isOriginated() ? 8 : 4;
            }
            case -127: {
                return 3;
            }
            case 1: {
                return message.getHops() == 0 && message.getTTL() <= 2 ? 1 : 5;
            }
            case 0: {
                return message.getHops() == 0 && message.getTTL() == 1 ? 1 : 6;
            }
            case 64: {
                return 2;
            }
        }
        return 7;
    }

    public Message removeNext() {
        if (this._cycled) {
            this._cycled = false;
            this._priority = this._priorityHint;
            this._queues[this._priority].resetCycle();
        }
        while (this._queued > 0) {
            MessageQueue messageQueue = this._queues[this._priority];
            Message message = messageQueue.removeNext();
            int n = messageQueue.resetDropped();
            this._dropped += n;
            this._queued -= (message == null ? 0 : 1) + n;
            if (message != null) {
                return message;
            }
            this._priority = (this._priority + 1) % 9;
            this._queues[this._priority].resetCycle();
        }
        this._cycled = true;
        return null;
    }

    public final int resetDropped() {
        int n = this._dropped;
        this._dropped = 0;
        return n;
    }

    public int size() {
        return this._queued;
    }

    public boolean isEmpty() {
        return this._queued == 0;
    }

    public void resetCycle() {
    }

    public Object getDroppedStats() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ver", 1);
        for (int i = 0; i < this._queues.length; ++i) {
            MessageQueue messageQueue = this._queues[i];
            if (messageQueue == null) continue;
            hashMap.put(String.valueOf(i), messageQueue.getDroppedStats());
        }
        return hashMap;
    }
}

