/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import com.limegroup.gnutella.bugs.RemoteAbstractInfo;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.service.ErrorService;

public final class RemoteClientInfo
extends RemoteAbstractInfo {
    private static final Log LOG = LogFactory.getLog(RemoteClientInfo.class);
    private static final long FAILURE_TIME = 3600000L;
    private String _nextThisBugTime;
    private String _nextAnyBugTime;

    public final void addRemoteInfo(String string) {
        StringTokenizer stringTokenizer;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding info: " + string);
        }
        if ((stringTokenizer = new StringTokenizer(string, "=&")).countTokens() % 2 != 0) {
            return;
        }
        while (stringTokenizer.hasMoreTokens()) {
            this.handleKeyValuePair(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
    }

    private final void handleKeyValuePair(String string, String string2) {
        String string3 = "";
        try {
            string3 = URLDecoder.decode(string2);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return;
        }
        if (string.equalsIgnoreCase("1")) {
            this._nextThisBugTime = string3;
        } else if (string.equalsIgnoreCase("2")) {
            this._nextAnyBugTime = string3;
        }
    }

    public final void connectFailed() {
        this._nextThisBugTime = "3600000";
        this._nextAnyBugTime = "3600000";
    }

    long getNextThisBugTime() {
        long l;
        if (this._nextThisBugTime == null) {
            return 0L;
        }
        try {
            l = Long.parseLong(this._nextThisBugTime);
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        return l;
    }

    long getNextAnyBugTime() {
        long l;
        if (this._nextAnyBugTime == null) {
            return 0L;
        }
        try {
            l = Long.parseLong(this._nextAnyBugTime);
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        return l;
    }
}

