/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.bootstrap.UDPHostCache;
import com.limegroup.gnutella.bootstrap.UDPHostCacheFactory;
import com.limegroup.gnutella.messages.PingRequestFactory;
import org.limewire.io.NetworkInstanceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class UDPHostCacheFactoryImpl
implements UDPHostCacheFactory {
    private final Provider<MessageRouter> messageRouter;
    private final PingRequestFactory pingRequestFactory;
    private final ConnectionServices connectionServices;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public UDPHostCacheFactoryImpl(Provider<MessageRouter> provider, PingRequestFactory pingRequestFactory, ConnectionServices connectionServices, NetworkInstanceUtils networkInstanceUtils) {
        this.messageRouter = provider;
        this.pingRequestFactory = pingRequestFactory;
        this.connectionServices = connectionServices;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public UDPHostCache createUDPHostCache(UDPPinger uDPPinger) {
        return new UDPHostCache(uDPPinger, this.messageRouter, this.pingRequestFactory, this.connectionServices, this.networkInstanceUtils);
    }

    @Override
    public UDPHostCache createUDPHostCache(long l, UDPPinger uDPPinger) {
        return new UDPHostCache(l, uDPPinger, this.messageRouter, this.pingRequestFactory, this.connectionServices, this.networkInstanceUtils);
    }
}

