/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.bittorrent.TorrentManager;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.UploadServices;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.uploader.UploadSlotManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class UploadServicesImpl
implements UploadServices {
    public static boolean IS_SEEDING_HOSTILES_TXT = false;
    private final Provider<UploadManager> uploadManager;
    private final Provider<UploadSlotManager> uploadSlotManager;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<TorrentManager> torrentManager;

    @Inject
    public UploadServicesImpl(Provider<UploadManager> provider, Provider<UploadSlotManager> provider2, Provider<ConnectionManager> provider3, Provider<TorrentManager> provider4) {
        this.uploadManager = provider;
        this.uploadSlotManager = provider2;
        this.connectionManager = provider3;
        this.torrentManager = provider4;
    }

    @Override
    public boolean hasActiveUploads() {
        this.uploadSlotManager.get().measureBandwidth();
        try {
            return this.uploadSlotManager.get().getMeasuredBandwidth() > 0.0f;
        }
        catch (InsufficientDataException insufficientDataException) {
            return false;
        }
    }

    @Override
    public float getRequestedUploadSpeed() {
        int n = UploadSettings.UPLOAD_SPEED.getValue();
        if (n == 100) {
            return Float.MAX_VALUE;
        }
        float f = (float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f * (float)n / 100.0f;
        return Math.max(f -= this.connectionManager.get().getMeasuredUpstreamBandwidth(), 1.0f) * 1024.0f;
    }

    @Override
    public int getNumUploads() {
        return this.uploadManager.get().uploadsInProgress() + this.torrentManager.get().getNumActiveTorrents();
    }

    @Override
    public int getNumQueuedUploads() {
        return this.uploadManager.get().getNumQueuedUploads();
    }

    @Override
    public boolean isSeedingHostilesTxt() {
        return IS_SEEDING_HOSTILES_TXT;
    }
}

