/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.limewire.collection.BucketQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class PongCacherImpl
implements PongCacher {
    private final Map<String, BucketQueue<PingReply>> PONGS = new HashMap<String, BucketQueue<PingReply>>();
    private final ConnectionServices connectionServices;

    @Inject
    public PongCacherImpl(ConnectionServices connectionServices) {
        this.connectionServices = connectionServices;
    }

    Map<String, BucketQueue<PingReply>> getPongMap() {
        return this.PONGS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PingReply> getBestPongs(String string) {
        Map<String, BucketQueue<PingReply>> map = this.PONGS;
        synchronized (map) {
            LinkedList<PingReply> linkedList = new LinkedList<PingReply>();
            long l = System.currentTimeMillis();
            List<PingReply> list = this.addBestPongs(string, linkedList, l, 0);
            this.removePongs(string, list);
            if (!ApplicationSettings.DEFAULT_LOCALE.getValue().equals(string) && linkedList.size() < 6) {
                list = this.addBestPongs(ApplicationSettings.DEFAULT_LOCALE.getValue(), linkedList, l, linkedList.size());
                this.removePongs(ApplicationSettings.DEFAULT_LOCALE.getValue(), list);
            }
            return linkedList;
        }
    }

    private List<PingReply> addBestPongs(String string, List<PingReply> list, long l, int n) {
        int n2 = ApplicationSettings.DEFAULT_LOCALE.getValue().equals(string) ? 6000 : 90000;
        LinkedList<PingReply> linkedList = null;
        if (this.PONGS.containsKey(string)) {
            BucketQueue<PingReply> bucketQueue = this.PONGS.get(string);
            Iterator<PingReply> iterator = bucketQueue.iterator();
            while (iterator.hasNext() && n < 6) {
                PingReply pingReply = iterator.next();
                if (l - pingReply.getCreationTime() > (long)n2) {
                    if (linkedList == null) {
                        linkedList = new LinkedList<PingReply>();
                    }
                    linkedList.add(pingReply);
                } else {
                    list.add(pingReply);
                }
                ++n;
            }
        }
        return linkedList;
    }

    private void removePongs(String string, List<PingReply> list) {
        if (list != null) {
            BucketQueue<PingReply> bucketQueue = this.PONGS.get(string);
            for (PingReply pingReply : list) {
                bucketQueue.removeAll(pingReply);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPong(PingReply pingReply) {
        if (!this.connectionServices.isSupernode()) {
            return;
        }
        if (!pingReply.isUltrapeer()) {
            return;
        }
        if (pingReply.getHops() >= 6) {
            return;
        }
        Map<String, BucketQueue<PingReply>> map = this.PONGS;
        synchronized (map) {
            if (this.PONGS.containsKey(pingReply.getClientLocale())) {
                BucketQueue<PingReply> bucketQueue = this.PONGS.get(pingReply.getClientLocale());
                bucketQueue.insert(pingReply, pingReply.getHops());
            } else {
                BucketQueue<PingReply> bucketQueue = new BucketQueue<PingReply>(6, 1);
                bucketQueue.insert(pingReply, pingReply.getHops());
                this.PONGS.put(pingReply.getClientLocale(), bucketQueue);
            }
        }
    }
}

