/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerController;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseFactory;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.UrnCallback;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.metadata.MetaDataReader;
import com.limegroup.gnutella.version.UpdateHandler;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLReplyCollectionFactory;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class FileManagerControllerImpl
implements FileManagerController {
    private final Provider<UrnCache> urnCache;
    private final Provider<DownloadManager> downloadManager;
    private final Provider<CreationTimeCache> creationTimeCache;
    private final Provider<ContentManager> contentManager;
    private final Provider<AltLocManager> altLocManager;
    private final Provider<ResponseFactory> responseFactory;
    private final Provider<SavedFileManager> savedFileManager;
    private final Provider<UpdateHandler> updateHandler;
    private final Provider<ActivityCallback> activityCallback;
    private final ScheduledExecutorService backgroundExecutor;
    private final LimeXMLReplyCollectionFactory limeXMLReplyCollectionFactory;
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;
    private final MetaDataReader metaDataReader;
    private final Provider<SchemaReplyCollectionMapper> schemaReplyCollectionMapper;
    private final Provider<LimeXMLSchemaRepository> limeXMLSchemaRepository;

    @Inject
    public FileManagerControllerImpl(Provider<UrnCache> provider, Provider<DownloadManager> provider2, Provider<CreationTimeCache> provider3, Provider<ContentManager> provider4, Provider<AltLocManager> provider5, Provider<ResponseFactory> provider6, Provider<SavedFileManager> provider7, Provider<UpdateHandler> provider8, Provider<ActivityCallback> provider9, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, LimeXMLReplyCollectionFactory limeXMLReplyCollectionFactory, LimeXMLDocumentFactory limeXMLDocumentFactory, MetaDataReader metaDataReader, Provider<SchemaReplyCollectionMapper> provider10, Provider<LimeXMLSchemaRepository> provider11) {
        this.urnCache = provider;
        this.downloadManager = provider2;
        this.creationTimeCache = provider3;
        this.contentManager = provider4;
        this.altLocManager = provider5;
        this.responseFactory = provider6;
        this.savedFileManager = provider7;
        this.updateHandler = provider8;
        this.activityCallback = provider9;
        this.backgroundExecutor = scheduledExecutorService;
        this.limeXMLReplyCollectionFactory = limeXMLReplyCollectionFactory;
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
        this.metaDataReader = metaDataReader;
        this.schemaReplyCollectionMapper = provider10;
        this.limeXMLSchemaRepository = provider11;
    }

    @Override
    public void save() {
        this.urnCache.get().persistCache();
        this.creationTimeCache.get().persistCache();
    }

    @Override
    public void loadStarted() {
        this.urnCache.get().clearPendingHashes(this);
    }

    @Override
    public void loadFinished() {
        this.creationTimeCache.get().pruneTimes();
        this.downloadManager.get().getIncompleteFileManager().registerAllIncompleteFiles();
    }

    @Override
    public void clearPendingShare(File file) {
        this.urnCache.get().clearPendingHashesFor(file, this);
    }

    @Override
    public void calculateAndCacheUrns(File file, UrnCallback urnCallback) {
        this.urnCache.get().calculateAndCacheUrns(file, urnCallback);
    }

    @Override
    public void addUrns(File file, Set<? extends URN> set) {
        this.urnCache.get().addUrns(file, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileAdded(File file, URN uRN) {
        CreationTimeCache creationTimeCache;
        CreationTimeCache creationTimeCache2 = creationTimeCache = this.creationTimeCache.get();
        synchronized (creationTimeCache2) {
            Long l = creationTimeCache.getCreationTime(uRN);
            if (l == null) {
                l = new Long(file.lastModified());
            }
            if (l > 0L) {
                creationTimeCache.addTime(uRN, l);
                creationTimeCache.commitTime(uRN);
            }
        }
    }

    @Override
    public void lastUrnRemoved(URN uRN) {
        this.altLocManager.get().purge(uRN);
        this.creationTimeCache.get().removeTime(uRN);
    }

    @Override
    public List<URN> getNewestUrns(QueryRequest queryRequest, int n) {
        return this.creationTimeCache.get().getFiles(queryRequest, n);
    }

    @Override
    public ContentResponseData getResponseDataFor(URN uRN) {
        return this.contentManager.get().getResponse(uRN);
    }

    @Override
    public void requestValidation(URN uRN, ContentResponseObserver contentResponseObserver) {
        this.contentManager.get().request(uRN, contentResponseObserver, 5000L);
    }

    @Override
    public int getAlternateLocationCount(URN uRN) {
        return this.altLocManager.get().getNumLocs(uRN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(URN uRN, Long l) {
        CreationTimeCache creationTimeCache;
        CreationTimeCache creationTimeCache2 = creationTimeCache = this.creationTimeCache.get();
        synchronized (creationTimeCache2) {
            creationTimeCache.removeTime(uRN);
            creationTimeCache.addTime(uRN, l);
            creationTimeCache.commitTime(uRN);
        }
    }

    @Override
    public Long getCreationTime(URN uRN) {
        return this.creationTimeCache.get().getCreationTime(uRN);
    }

    @Override
    public Response createPureMetadataResponse() {
        return this.responseFactory.get().createResponse(0xFFFFFFFFL, 0L, " ");
    }

    @Override
    public Response createResponse(FileDesc fileDesc) {
        return this.responseFactory.get().createResponse(fileDesc);
    }

    @Override
    public void loadFinishedPostSave() {
        this.savedFileManager.get().run();
        this.updateHandler.get().tryToDownloadUpdates();
        this.activityCallback.get().fileManagerLoaded();
    }

    @Override
    public void fileManagerLoading() {
        this.activityCallback.get().fileManagerLoading();
    }

    @Override
    public void handleSharedFileUpdate(File file) {
        this.activityCallback.get().handleSharedFileUpdate(file);
    }

    @Override
    public void scheduleWithFixedDelay(Runnable runnable, int n, int n2, TimeUnit timeUnit) {
        this.backgroundExecutor.scheduleWithFixedDelay(runnable, n, n2, timeUnit);
    }

    @Override
    public void setAnnotateEnabled(boolean bl) {
        this.activityCallback.get().setAnnotateEnabled(bl);
    }

    @Override
    public boolean warnAboutSharingSensitiveDirectory(File file) {
        return this.activityCallback.get().warnAboutSharingSensitiveDirectory(file);
    }

    @Override
    public LimeXMLReplyCollection createLimeXMLReplyCollection(String string) {
        return this.limeXMLReplyCollectionFactory.createLimeXMLReplyCollection(string);
    }

    @Override
    public LimeXMLDocument createLimeXMLDocument(Collection<? extends Map.Entry<String, String>> collection, String string) {
        return this.limeXMLDocumentFactory.createLimeXMLDocument(collection, string);
    }

    @Override
    public LimeXMLDocument readDocument(File file) throws IOException {
        return this.metaDataReader.readDocument(file);
    }

    @Override
    public void add(String string, LimeXMLReplyCollection limeXMLReplyCollection) {
        this.schemaReplyCollectionMapper.get().add(string, limeXMLReplyCollection);
    }

    @Override
    public Collection<LimeXMLReplyCollection> getCollections() {
        return this.schemaReplyCollectionMapper.get().getCollections();
    }

    @Override
    public LimeXMLReplyCollection getReplyCollection(String string) {
        return this.schemaReplyCollectionMapper.get().getReplyCollection(string);
    }

    @Override
    public String[] getAvailableSchemaURIs() {
        return this.limeXMLSchemaRepository.get().getAvailableSchemaURIs();
    }

    @Override
    public LimeXMLSchema getSchema(String string) {
        return this.limeXMLSchemaRepository.get().getSchema(string);
    }
}

