/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCallback;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface FileManagerController {
    public void save();

    public void loadStarted();

    public void loadFinished();

    public void clearPendingShare(File var1);

    public void calculateAndCacheUrns(File var1, UrnCallback var2);

    public void addUrns(File var1, Set<? extends URN> var2);

    public void fileAdded(File var1, URN var2);

    public void lastUrnRemoved(URN var1);

    public List<URN> getNewestUrns(QueryRequest var1, int var2);

    public ContentResponseData getResponseDataFor(URN var1);

    public void requestValidation(URN var1, ContentResponseObserver var2);

    public int getAlternateLocationCount(URN var1);

    public Long getCreationTime(URN var1);

    public void fileChanged(URN var1, Long var2);

    public Response createResponse(FileDesc var1);

    public Response createPureMetadataResponse();

    public void loadFinishedPostSave();

    public void fileManagerLoading();

    public boolean warnAboutSharingSensitiveDirectory(File var1);

    public void handleSharedFileUpdate(File var1);

    public void scheduleWithFixedDelay(Runnable var1, int var2, int var3, TimeUnit var4);

    public void setAnnotateEnabled(boolean var1);

    public LimeXMLReplyCollection createLimeXMLReplyCollection(String var1);

    public LimeXMLDocument createLimeXMLDocument(Collection<? extends Map.Entry<String, String>> var1, String var2);

    public LimeXMLDocument readDocument(File var1) throws IOException;

    public void add(String var1, LimeXMLReplyCollection var2);

    public Collection<LimeXMLReplyCollection> getCollections();

    public LimeXMLReplyCollection getReplyCollection(String var1);

    public String[] getAvailableSchemaURIs();

    public LimeXMLSchema getSchema(String var1);
}

