/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.tracking;

import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.settings.BittorrentSettings;
import com.limegroup.bittorrent.tracking.Tracker;
import com.limegroup.bittorrent.tracking.TrackerFactory;
import com.limegroup.bittorrent.tracking.TrackerResponse;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;

public class TrackerManager {
    private static final Log LOG = LogFactory.getLog(TrackerManager.class);
    private static final int MAX_TRACKER_FAILURES = 5;
    private final Collection<Tracker> trackers = new CopyOnWriteArrayList<Tracker>();
    private final ExecutorService requestQueue = ExecutorsHelper.newProcessingQueue("tracker requester");
    private volatile long _nextTrackerRequestTime;
    private final ManagedTorrent torrent;
    private volatile ScheduledFuture<?> scheduledAnnounce;
    private volatile String lastFailureReason;
    private final ScheduledExecutorService backgroundExecutor;

    TrackerManager(ManagedTorrent managedTorrent, TrackerFactory trackerFactory, ScheduledExecutorService scheduledExecutorService) {
        this.torrent = managedTorrent;
        this.backgroundExecutor = scheduledExecutorService;
        TorrentContext torrentContext = managedTorrent.getContext();
        for (URI uRI : torrentContext.getMetaInfo().getTrackers()) {
            this.trackers.add(trackerFactory.create(uRI, torrentContext, managedTorrent));
        }
    }

    public void add(Tracker tracker) {
        this.trackers.add(tracker);
    }

    private void announceBlocking(Tracker tracker, Tracker.Event event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("connecting to tracker " + tracker.toString() + " for event " + (Object)((Object)event));
        }
        TrackerResponse trackerResponse = tracker.request(event);
        this.handleTrackerResponse(trackerResponse, tracker);
    }

    private void announceToAll(final Tracker.Event event) {
        for (final Tracker tracker : this.trackers) {
            Runnable runnable = new Runnable(){

                public void run() {
                    TrackerManager.this.announceBlocking(tracker, event);
                }
            };
            this.requestQueue.execute(runnable);
        }
    }

    public void announceStart() {
        this._nextTrackerRequestTime = 0L;
        this.announceToAll(Tracker.Event.START);
    }

    public void announceStop() {
        ScheduledFuture<?> scheduledFuture = this.scheduledAnnounce;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        this.announceToAll(Tracker.Event.STOP);
    }

    public void announceComplete() {
        this.announceToAll(Tracker.Event.COMPLETE);
    }

    private void announce(Tracker tracker) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("announce thread for " + tracker.toString());
        }
        this.torrent.setScraping();
        this.announceBlocking(tracker, Tracker.Event.NONE);
    }

    private boolean isHopeless() {
        if (this.trackers.isEmpty()) {
            return true;
        }
        int n = Integer.MAX_VALUE;
        for (Tracker tracker : this.trackers) {
            if (tracker.getFailures() == 0) {
                return false;
            }
            if (tracker.getFailures() >= n) continue;
            n = tracker.getFailures();
        }
        return n >= 5;
    }

    private void scheduleTrackerRequest(long l, final Tracker tracker) {
        final Runnable runnable = new Runnable(){

            public void run() {
                if (!TrackerManager.this.torrent.isActive()) {
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("announcing to " + tracker.toString());
                }
                TrackerManager.this.announce(tracker);
            }
        };
        Runnable runnable2 = new Runnable(){

            public void run() {
                TrackerManager.this.requestQueue.execute(runnable);
            }
        };
        LOG.debug("scheduling new tracker request");
        if (this.scheduledAnnounce != null) {
            this.scheduledAnnounce.cancel(true);
        }
        this.scheduledAnnounce = this.backgroundExecutor.schedule(runnable2, l, TimeUnit.MILLISECONDS);
        this._nextTrackerRequestTime = System.currentTimeMillis() + l;
    }

    public long getNextTrackerRequestTime() {
        return this._nextTrackerRequestTime;
    }

    public String getLastFailureReason() {
        return this.lastFailureReason;
    }

    private void handleTrackerResponse(TrackerResponse trackerResponse, Tracker tracker) {
        LOG.debug("handling tracker response " + trackerResponse + " from " + tracker);
        long l = BittorrentSettings.TRACKER_MIN_REASK_INTERVAL.getValue() * 1000;
        if (trackerResponse != null) {
            for (TorrentLocation torrentLocation : trackerResponse.PEERS) {
                this.torrent.addEndpoint(torrentLocation);
            }
            l = trackerResponse.INTERVAL * 1000;
            if (trackerResponse.FAILURE_REASON != null) {
                tracker.recordFailure();
                this.lastFailureReason = trackerResponse.FAILURE_REASON;
            } else {
                tracker.recordSuccess();
            }
        } else {
            tracker.recordFailure();
            this.torrent.trackerRequestFailed();
        }
        if (this.torrent.isActive()) {
            if (this.isHopeless() && this.torrent.shouldStop()) {
                this.torrent.stopVoluntarily();
            } else {
                this.scheduleTrackerRequest(l, tracker);
            }
        }
    }
}

