/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.tracking;

import com.google.inject.Provider;
import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.bencoding.Token;
import com.limegroup.bittorrent.tracking.TrackerResponse;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.URIUtils;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.params.HttpConnectionParams;
import org.limewire.http.LimeHttpClient;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Tracker {
    private static final Log LOG = LogFactory.getLog(Tracker.class);
    private static final int HTTP_TRACKER_TIMEOUT = 25000;
    private static final String QUESTION_MARK = "?";
    private static final String EQUALS = "=";
    private static final String AND = "&";
    private final URI uri;
    private final TorrentContext context;
    private final ManagedTorrent torrent;
    private final Provider<LimeHttpClient> clientProvider;
    private int failures;
    private final String key;
    private final NetworkManager networkManager;
    private final ApplicationServices applicationServices;

    Tracker(URI uRI, TorrentContext torrentContext, ManagedTorrent managedTorrent, NetworkManager networkManager, ApplicationServices applicationServices, Provider<LimeHttpClient> provider) {
        this.networkManager = networkManager;
        this.applicationServices = applicationServices;
        this.uri = uRI;
        this.context = torrentContext;
        this.torrent = managedTorrent;
        this.clientProvider = provider;
        String string = Integer.toHexString((int)(Math.random() * 2.147483647E9));
        while (string.length() < 8) {
            string = string + "0";
        }
        this.key = string;
    }

    public void recordFailure() {
        ++this.failures;
    }

    public void recordSuccess() {
        this.failures = 0;
    }

    public int getFailures() {
        return this.failures;
    }

    public TrackerResponse request(Event event) {
        String string = this.createQueryString(event);
        return this.connectHTTP(this.uri, string);
    }

    private String createQueryString(Event event) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string = URLEncoder.encode(StringUtils.getASCIIString(this.context.getMetaInfo().getInfoHash()), "ISO-8859-1");
            Tracker.addGetField(stringBuilder, "info_hash", string);
            String string2 = URLEncoder.encode(StringUtils.getASCIIString(this.applicationServices.getMyBTGUID()), "ISO-8859-1");
            Tracker.addGetField(stringBuilder, "peer_id", string2);
            Tracker.addGetField(stringBuilder, "key", this.key);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error(unsupportedEncodingException);
        }
        Tracker.addGetField(stringBuilder, "ip", NetworkUtils.ip2string(this.networkManager.getAddress()));
        Tracker.addGetField(stringBuilder, "port", String.valueOf(this.networkManager.getPort()));
        Tracker.addGetField(stringBuilder, "downloaded", String.valueOf(this.torrent.getTotalDownloaded()));
        Tracker.addGetField(stringBuilder, "uploaded", String.valueOf(this.torrent.getTotalUploaded()));
        Tracker.addGetField(stringBuilder, "left", String.valueOf(this.context.getFileSystem().getTotalSize() - this.context.getDiskManager().getBlockSize()));
        Tracker.addGetField(stringBuilder, "compact", "1");
        event.addEventFields(stringBuilder);
        if (LOG.isDebugEnabled()) {
            LOG.debug("tracker query " + stringBuilder.toString());
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TrackerResponse connectHTTP(URI uRI, String string) {
        byte[] byArray;
        HttpResponse httpResponse = null;
        HttpGet httpGet = null;
        LimeHttpClient limeHttpClient = this.clientProvider.get();
        try {
            URI uRI2 = URIUtils.toURI(uRI.toASCIIString() + string);
            httpGet = new HttpGet(uRI2);
            httpGet.addHeader("User-Agent", LimeWireUtils.getHttpServer());
            httpGet.addHeader("Cache-Control", "no-cache");
            httpGet.addHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
            HttpConnectionParams.setConnectionTimeout(limeHttpClient.getParams(), 25000);
            HttpConnectionParams.setSoTimeout(limeHttpClient.getParams(), 25000);
            httpResponse = limeHttpClient.execute(httpGet);
            if (httpResponse.getEntity() != null) {
                if (httpResponse.getEntity().getContentLength() > 32768L) {
                    TrackerResponse trackerResponse = null;
                    limeHttpClient.releaseConnection(httpResponse);
                    return trackerResponse;
                }
                byArray = IOUtils.readFully(httpResponse.getEntity().getContent());
                if (byArray.length == 0) {
                    TrackerResponse trackerResponse = null;
                    limeHttpClient.releaseConnection(httpResponse);
                    return trackerResponse;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(new String(byArray));
                }
                TrackerResponse trackerResponse = new TrackerResponse(Token.parse(byArray));
                limeHttpClient.releaseConnection(httpResponse);
                return trackerResponse;
            }
            TrackerResponse trackerResponse = null;
            limeHttpClient.releaseConnection(httpResponse);
            return trackerResponse;
        }
        catch (IOException iOException) {
            byArray = null;
            return byArray;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                byArray = null;
                return byArray;
            }
        }
        finally {
            limeHttpClient.releaseConnection(httpResponse);
        }
    }

    private static StringBuilder addGetField(StringBuilder stringBuilder, String string, String string2) {
        if (stringBuilder.length() == 0) {
            stringBuilder.append(QUESTION_MARK);
        } else {
            stringBuilder.append(AND);
        }
        stringBuilder.append(string);
        stringBuilder.append(EQUALS);
        stringBuilder.append(string2);
        return stringBuilder;
    }

    public String toString() {
        return "Tracker " + this.uri + " failures " + this.failures;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Event {
        START(100, "started"),
        STOP(0, "stopped"),
        COMPLETE(20, "completed"),
        NONE(50, null);

        private final String numWant;
        private final String description;

        private Event(int n2, String string2) {
            this.numWant = n2 > 0 ? Integer.toString(n2) : null;
            this.description = string2;
        }

        public void addEventFields(StringBuilder stringBuilder) {
            if (this.description != null) {
                Tracker.addGetField(stringBuilder, "event", this.description);
            }
            if (this.numWant != null) {
                Tracker.addGetField(stringBuilder, "numwant", this.numWant);
            }
        }
    }
}

