/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.reader;

import com.limegroup.bittorrent.messages.BTBitField;
import com.limegroup.bittorrent.messages.BadBTMessageException;
import com.limegroup.bittorrent.reader.BTDataSource;
import com.limegroup.bittorrent.reader.BTReadMessageState;
import com.limegroup.bittorrent.reader.ReaderData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.ByteBufferOutputStream;
import org.limewire.service.ErrorService;

class BitFieldState
extends BTReadMessageState {
    private static final Log LOG = LogFactory.getLog(BitFieldState.class);
    private ByteBufferOutputStream bbaos;
    private WritableByteChannel bbaosChan;
    private final int length;

    BitFieldState(ReaderData readerData) {
        super(readerData);
        this.length = readerData.getLength();
    }

    public BTReadMessageState addData() throws BadBTMessageException {
        BTDataSource bTDataSource = this.readerState.getDataSource();
        if (this.bbaos == null) {
            this.bbaos = new ByteBufferOutputStream();
            this.bbaosChan = Channels.newChannel(this.bbaos);
        }
        int n = this.length - this.bbaos.size();
        try {
            bTDataSource.write(this.bbaosChan, n);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " parsing bitfield incrementally, so far " + this.bbaos.size());
        }
        if (this.bbaos.size() == this.length) {
            this.countAndProcess(ByteBuffer.wrap(this.bbaos.toByteArray()));
            return this.readerState.getEntryState();
        }
        return null;
    }

    private void countAndProcess(ByteBuffer byteBuffer) {
        BTBitField bTBitField = new BTBitField(byteBuffer);
        this.readerState.getHandler().processMessage(bTBitField);
    }

    public String toString() {
        return "BitFieldReader for " + this.readerState;
    }
}

