/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.handshaking;

import com.limegroup.bittorrent.BTConnectionFactory;
import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.TorrentManager;
import com.limegroup.bittorrent.handshaking.BTHandshaker;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.AbstractNBSocket;

class IncomingBTHandshaker
extends BTHandshaker {
    private static final Log LOG = LogFactory.getLog(IncomingBTHandshaker.class);
    private static final byte[] PROTOCOL = new byte[]{112, 114, 111, 116, 111, 99, 111, 108};
    private final TorrentManager manager;

    public IncomingBTHandshaker(AbstractNBSocket abstractNBSocket, TorrentManager torrentManager, BTConnectionFactory bTConnectionFactory) {
        super(new TorrentLocation((InetSocketAddress)abstractNBSocket.getRemoteSocketAddress(), new byte[20], new byte[8]), abstractNBSocket, bTConnectionFactory);
        this.manager = torrentManager;
    }

    public void startHandshaking() {
        this.initIncomingHandshake();
        this.setReadInterest();
    }

    protected boolean verifyIncoming() {
        while (this.currentBufIndex < this.incomingHandshake.length && !this.incomingHandshake[this.currentBufIndex].hasRemaining()) {
            ByteBuffer byteBuffer = this.incomingHandshake[this.currentBufIndex];
            switch (this.currentBufIndex) {
                case 0: {
                    if (Arrays.equals(byteBuffer.array(), PROTOCOL)) break;
                    return false;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.torrent = this.manager.getTorrentForHash(byteBuffer.array());
                    if (this.torrent == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("incoming connection for unknown torrent");
                        }
                        return false;
                    }
                    if (!this.torrent.shouldAddConnection(this.loc)) {
                        return false;
                    }
                    this.observer = this.torrent.getFetcher();
                    this.initOutgoingHandshake();
                    this.setWriteInterest();
                    this.observer.handshakerStarted(this);
                    break;
                }
            }
            ++this.currentBufIndex;
        }
        return true;
    }

    protected void initIncomingHandshake() {
        this.incomingHandshake = new ByteBuffer[4];
        this.incomingHandshake[0] = ByteBuffer.allocate(8);
        this.incomingHandshake[1] = ByteBuffer.wrap(this.loc.getExtBytes());
        this.incomingHandshake[2] = ByteBuffer.allocate(20);
        this.incomingHandshake[3] = ByteBuffer.wrap(this.loc.getPeerID());
    }
}

