/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.disk;

import com.limegroup.bittorrent.BTInterval;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.BTPiece;
import com.limegroup.bittorrent.PieceReadListener;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.TorrentFile;
import com.limegroup.bittorrent.TorrentFileSystem;
import com.limegroup.bittorrent.disk.DiskController;
import com.limegroup.bittorrent.disk.DiskManagerListener;
import com.limegroup.bittorrent.disk.TorrentDiskManager;
import com.limegroup.bittorrent.settings.BittorrentSettings;
import com.limegroup.gnutella.downloader.serial.BTDiskManagerMemento;
import com.limegroup.gnutella.downloader.serial.BTDiskManagerMementoImpl;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.MessageDigest;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.AndView;
import org.limewire.collection.BitField;
import org.limewire.collection.BitFieldSet;
import org.limewire.collection.BitSet;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.MultiIterable;
import org.limewire.collection.NECallable;
import org.limewire.collection.NotView;
import org.limewire.collection.RRProcessingQueue;
import org.limewire.collection.Range;
import org.limewire.io.DiskException;
import org.limewire.service.ErrorService;
import org.limewire.util.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VerifyingFolder
implements TorrentDiskManager {
    private static final Log LOG = LogFactory.getLog(VerifyingFolder.class);
    private static final RRProcessingQueue QUEUE = new RRProcessingQueue("TorrentDiskQueue");
    private static final RRProcessingQueue VERIFY_QUEUE = new RRProcessingQueue("TorrentVerifier");
    private static final int BLOCK_SIZE = 16384;
    private final List<TorrentFile> _files;
    private BlockRangeMap partialBlocks;
    private BlockRangeMap requestedRanges;
    private Iterable<Integer> requestedAndPartial;
    private BlockRangeMap pendingRanges;
    private BitSet verifiedBlocks;
    private BitField missing;
    private BitField verified;
    private byte[] bitField;
    private boolean bitFieldDirty = true;
    private long _corruptedBytes;
    private final TorrentContext context;
    private volatile IOException storedException;
    private volatile DiskManagerListener listener;
    private volatile boolean isVerifying;
    private final DiskController<TorrentFile> diskController;
    private volatile long lastVerifiedOffset;

    VerifyingFolder(TorrentContext torrentContext, boolean bl, BTDiskManagerMemento bTDiskManagerMemento, DiskController<TorrentFile> diskController) {
        TorrentFileSystem torrentFileSystem = torrentContext.getFileSystem();
        this._files = bl ? torrentFileSystem.getFiles() : torrentFileSystem.getIncompleteFiles();
        this.context = torrentContext;
        this._corruptedBytes = 0L;
        this.partialBlocks = new BlockRangeMap();
        this.requestedRanges = new BlockRangeMap();
        this.pendingRanges = new BlockRangeMap();
        this.diskController = diskController;
        this.requestedAndPartial = new MultiIterable(this.partialBlocks.keySet(), this.requestedRanges.keySet());
        if (bl) {
            this.verifiedBlocks = torrentContext.getFullBitSet();
            this.verified = torrentContext.getFullBitField();
        } else {
            this.verifiedBlocks = new BitSet(torrentContext.getMetaInfo().getNumBlocks());
            if (bTDiskManagerMemento != null) {
                this.initialize(bTDiskManagerMemento);
            }
            this.verified = new BitFieldSet(this.verifiedBlocks, torrentContext.getMetaInfo().getNumBlocks());
        }
        this.missing = new NotView(this.verified);
    }

    private void initialize(BTDiskManagerMemento bTDiskManagerMemento) {
        if (bTDiskManagerMemento.getPartialBlocks() != null) {
            this.partialBlocks.putAll(bTDiskManagerMemento.getPartialBlocks());
        }
        if (bTDiskManagerMemento.getVerifiedBlocks() != null) {
            this.verifiedBlocks = bTDiskManagerMemento.getVerifiedBlocks();
        }
        this.isVerifying = bTDiskManagerMemento.isVerifying();
    }

    @Override
    public void writeBlock(NECallable<BTPiece> nECallable) {
        if (this.storedException != null) {
            return;
        }
        QUEUE.execute(new WriteJob(nECallable), this.context.getMetaInfo().getURN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBlockImpl(BTInterval bTInterval, byte[] byArray) throws IOException {
        long l = (long)bTInterval.getId() * (long)this.context.getMetaInfo().getPieceLength() + bTInterval.getLow();
        this.diskController.write(l, byArray);
        VerifyingFolder verifyingFolder = this;
        synchronized (verifyingFolder) {
            this.pendingRanges.removeInterval(bTInterval);
            this.partialBlocks.addInterval(bTInterval);
            if (!this.isCompleteBlock(bTInterval.getId(), this.partialBlocks)) {
                return;
            }
        }
        boolean bl = this.verifyQuick(bTInterval.getId());
        VerifyingFolder verifyingFolder2 = this;
        synchronized (verifyingFolder2) {
            this.partialBlocks.remove(bTInterval.getId());
            if (bl) {
                this.markPieceCompleted(bTInterval.getId());
            } else {
                this._corruptedBytes += (long)this.getPieceSize(bTInterval.getId());
            }
        }
        if (bl) {
            this.handleVerified(bTInterval.getId());
        }
    }

    private synchronized void markPieceCompleted(int n) {
        int n2;
        this.partialBlocks.remove(n);
        this.requestedRanges.remove(n);
        this.verifiedBlocks.set(n);
        this.bitFieldDirty = true;
        if (this.verifiedBlocks.cardinality() == this.context.getMetaInfo().getNumBlocks()) {
            this.verifiedBlocks = this.context.getFullBitSet();
            this.verified = this.context.getFullBitField();
            this.missing = new NotView(this.verified);
        }
        if (this.context.getFileSystem().getFiles().size() != 1) {
            return;
        }
        long l = this.context.getMetaInfo().getPieceLength();
        for (n2 = (int)(this.lastVerifiedOffset / l); n2 < this.verified.maxSize() && this.verified.get(n2); ++n2) {
        }
        this.lastVerifiedOffset = Math.min(this.context.getFileSystem().getTotalSize(), (long)n2 * l);
    }

    private boolean verifyQuick(int n) throws IOException {
        try {
            return this.verify(n, false);
        }
        catch (InterruptedException interruptedException) {
            ErrorService.error(interruptedException);
            return false;
        }
    }

    private boolean verify(int n, boolean bl) throws IOException, InterruptedException {
        MessageDigest messageDigest = this.context.getMetaInfo().getMessageDigest();
        messageDigest.reset();
        int n2 = this.getPieceSize(n);
        byte[] byArray = new byte[Math.min(65536, n2)];
        int n3 = 0;
        long l = (long)n * (long)this.context.getMetaInfo().getPieceLength();
        while (n3 < n2) {
            int n4 = this.diskController.read(l, byArray, 0, byArray.length);
            if (n4 == 0) {
                return false;
            }
            long l2 = System.nanoTime();
            messageDigest.update(byArray, 0, n4);
            if (bl && SystemUtils.getIdleTime() < 300000L && SharingSettings.FRIENDLY_HASHING.getValue()) {
                long l3 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
                if ((l3 *= QUEUE.size() > 0 ? 5L : 3L) > 0L) {
                    Thread.sleep(l3);
                } else {
                    Thread.yield();
                }
            }
            n3 += n4;
            l += (long)n4;
        }
        byte[] byArray2 = messageDigest.digest();
        return this.context.getMetaInfo().verify(byArray2, n);
    }

    private void handleVerified(int n) throws IOException {
        this.closeAnyCompletedFiles(n);
        this.notifyOfChunkCompletion(n);
    }

    private void notifyOfChunkCompletion(int n) {
        DiskManagerListener diskManagerListener = this.listener;
        if (diskManagerListener != null) {
            diskManagerListener.chunkVerified(n);
        }
    }

    private void closeAnyCompletedFiles(int n) throws IOException {
        ArrayList<TorrentFile> arrayList = null;
        for (TorrentFile torrentFile : this._files) {
            if (torrentFile.getBegin() > n) continue;
            if (torrentFile.getEnd() < n) break;
            if (arrayList == null) {
                arrayList = new ArrayList<TorrentFile>();
            }
            arrayList.add(torrentFile);
        }
        if (arrayList == null) {
            return;
        }
        for (TorrentFile torrentFile : arrayList) {
            boolean bl = true;
            for (int i = torrentFile.getBegin(); i <= torrentFile.getEnd(); ++i) {
                if (this.hasBlock(i)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.diskController.setReadOnly(torrentFile);
        }
    }

    private boolean isCompleteBlock(Range range, int n) {
        return range.getLow() == 0L && range.getHigh() == (long)(this.getPieceSize(n) - 1);
    }

    @Override
    public synchronized boolean hasBlock(int n) {
        return this.verified.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(final DiskManagerListener diskManagerListener) throws IOException {
        Object object;
        this.listener = diskManagerListener;
        this.storedException = null;
        boolean bl = this.isVerifying;
        this.isVerifying |= this.getBlockSize() == 0L;
        List<TorrentFile> list = this.diskController.open(this._files, this.isComplete(), this.isVerifying);
        if (list != null) {
            this.isVerifying = true;
            if (!bl) {
                object = this;
                synchronized (object) {
                    this.verifiedBlocks.clear();
                    this.partialBlocks.clear();
                }
            }
            this.verifyFiles(list);
        } else {
            this.isVerifying = false;
        }
        object = this.partialBlocks.keySet().iterator();
        while (object.hasNext()) {
            int n = (Integer)object.next();
            if (!this.isCompleteBlock(n, this.partialBlocks)) continue;
            this.isVerifying = true;
            VERIFY_QUEUE.execute(new VerifyJob(n), this.context.getMetaInfo().getURN());
        }
        if (this.isVerifying) {
            VERIFY_QUEUE.execute(new Runnable(){

                public void run() {
                    if (VerifyingFolder.this.isOpen()) {
                        VerifyingFolder.this.isVerifying = false;
                        VerifyingFolder.this._corruptedBytes = 0L;
                        diskManagerListener.verificationComplete();
                    }
                }
            }, this.context.getMetaInfo().getURN());
        }
    }

    @Override
    public boolean isVerifying() {
        return this.isVerifying;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.verified == this.context.getFullBitField();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LOG.debug("closing the file");
        Object object = this;
        synchronized (object) {
            this.pendingRanges.clear();
        }
        this.diskController.close();
        this.listener = null;
        object = this.context.getMetaInfo().getURN();
        VERIFY_QUEUE.clear(object);
        QUEUE.clear(object);
    }

    @Override
    public boolean isOpen() {
        return this.diskController != null & this.diskController.isOpen();
    }

    @Override
    public void requestPieceRead(BTInterval bTInterval, PieceReadListener pieceReadListener) {
        if (this.storedException != null) {
            return;
        }
        QUEUE.execute(new SendJob(bTInterval, pieceReadListener), this.context.getMetaInfo().getURN());
    }

    private void notifyDiskProblem(IOException iOException) {
        DiskManagerListener diskManagerListener = this.listener;
        if (diskManagerListener != null) {
            diskManagerListener.diskExceptionHappened(new DiskException(iOException));
        }
    }

    @Override
    public synchronized BTInterval leaseRandom(BitField bitField, Set<BTInterval> set) {
        AndView andView;
        BTInterval bTInterval;
        if (this.isComplete()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("leasing random chunk from available cardinality " + bitField.cardinality());
        }
        if ((bTInterval = this.findRandom(andView = new AndView(bitField, this.missing), set)) != null) {
            if (bTInterval.getHigh() - bTInterval.getLow() + 1L > 16384L) {
                bTInterval = new BTInterval(bTInterval.getLow(), bTInterval.getLow() + 16384L - 1L, bTInterval.getId());
            }
            this.requestedRanges.addInterval(bTInterval);
            if (LOG.isDebugEnabled()) {
                LOG.debug("assigning " + bTInterval);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("couldn't find anything to assign " + set);
        }
        return bTInterval;
    }

    private BTInterval findRandom(BitField bitField, Set<BTInterval> set) {
        BTInterval bTInterval = this.assignEndgame(bitField, set, false);
        if (bTInterval != null) {
            return bTInterval;
        }
        LOG.debug("couldn't find partial, looking for unnassigned");
        bTInterval = this.findUnassigned(bitField);
        if (bTInterval != null) {
            return bTInterval;
        }
        LOG.debug("couldn't find unassigned, looking for already requested");
        return this.assignEndgame(bitField, set, true);
    }

    private BTInterval findUnassigned(BitField bitField) {
        int n = -1;
        int n2 = 1;
        int n3 = bitField.nextSetBit(0);
        while (n3 >= 0) {
            if (!(this.pendingRanges.containsKey(n3) || this.partialBlocks.containsKey(n3) || this.requestedRanges.containsKey(n3))) {
                int n4 = n2++;
                if (Math.random() < (double)(1.0f / (float)n4)) {
                    n = n3;
                }
            }
            n3 = bitField.nextSetBit(n3 + 1);
        }
        if (n == -1) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("selecting unassigned piece " + n);
        }
        return new BTInterval(0L, this.getPieceSize(n) - 1, n);
    }

    private BTInterval assignEndgame(BitField bitField, Set<BTInterval> set, boolean bl) {
        BTInterval bTInterval = null;
        AbstractCollection abstractCollection = null;
        for (int n : this.requestedAndPartial) {
            if (!bitField.get(n) || !bl && this.isCompleteBlock(n, this.requestedRanges) || this.isCompleteBlock(n, this.partialBlocks)) continue;
            if (abstractCollection == null) {
                abstractCollection = new HashSet(this.requestedRanges.size() + this.partialBlocks.size());
            }
            abstractCollection.add(n);
        }
        if (abstractCollection == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("available partial and requested blocks to attempt: " + abstractCollection);
        }
        abstractCollection = new ArrayList<Integer>(abstractCollection);
        Collections.shuffle((List)((Object)abstractCollection));
        Iterator<Integer> iterator = abstractCollection.iterator();
        while (iterator.hasNext() && bTInterval == null) {
            int n;
            n = iterator.next();
            IntervalSet intervalSet = new IntervalSet();
            intervalSet = intervalSet.invert(this.getPieceSize(n));
            IntervalSet intervalSet2 = (IntervalSet)this.partialBlocks.get(n);
            IntervalSet intervalSet3 = (IntervalSet)this.pendingRanges.get(n);
            IntervalSet intervalSet4 = (IntervalSet)this.requestedRanges.get(n);
            if (intervalSet2 != null) {
                intervalSet.delete(intervalSet2);
            }
            if (intervalSet3 != null) {
                intervalSet.delete(intervalSet3);
            }
            for (BTInterval bTInterval2 : set) {
                intervalSet.delete(bTInterval2);
            }
            if (intervalSet4 != null) {
                intervalSet.delete(intervalSet4);
                if (bl && intervalSet.isEmpty() && !iterator.hasNext()) {
                    LOG.debug("endgame");
                    intervalSet = intervalSet4.clone();
                    for (BTInterval bTInterval2 : set) {
                        intervalSet.delete(bTInterval2);
                    }
                }
            }
            if (intervalSet.isEmpty()) continue;
            bTInterval = new BTInterval(intervalSet.getFirst(), n);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("selected partial/requested interval " + bTInterval + " with partial " + this.partialBlocks.get(bTInterval.getId()) + " requested " + this.requestedRanges.get(bTInterval.getId()) + " pending " + this.pendingRanges.get(bTInterval.getId()));
        }
        return bTInterval;
    }

    private boolean isCompleteBlock(int n, BlockRangeMap blockRangeMap) {
        IntervalSet intervalSet = (IntervalSet)blockRangeMap.get(n);
        if (intervalSet == null) {
            return false;
        }
        if (intervalSet.getNumberOfIntervals() != 1) {
            return false;
        }
        Range range = intervalSet.getFirst();
        return this.isCompleteBlock(range, n);
    }

    private int getPieceSize(int n) {
        int n2;
        BTMetaInfo bTMetaInfo = this.context.getMetaInfo();
        if (n == bTMetaInfo.getNumBlocks() - 1 && (n2 = (int)(this.context.getFileSystem().getTotalSize() % (long)bTMetaInfo.getPieceLength())) != 0) {
            return n2;
        }
        return bTMetaInfo.getPieceLength();
    }

    @Override
    public synchronized void releaseInterval(BTInterval bTInterval) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("releasing " + bTInterval);
        }
        this.requestedRanges.removeInterval(bTInterval);
    }

    @Override
    public synchronized byte[] createBitField() {
        if (this.bitField == null) {
            this.bitField = new byte[(this.context.getMetaInfo().getNumBlocks() + 7) / 8];
        }
        if (this.bitFieldDirty) {
            if (this.isComplete()) {
                int n;
                for (n = 0; n < this.bitField.length; ++n) {
                    this.bitField[n] = -1;
                }
                n = this.context.getMetaInfo().getNumBlocks() % 8;
                if (n != 0) {
                    int n2 = this.bitField.length - 1;
                    this.bitField[n2] = (byte)(this.bitField[n2] << 8 - n);
                }
            } else {
                int n = this.verified.nextSetBit(0);
                while (n >= 0) {
                    this.bitField[n / 8] = (byte)(this.bitField[n / 8] | 1 << 7 - n % 8);
                    n = this.verified.nextSetBit(n + 1);
                }
            }
            this.bitFieldDirty = false;
        }
        return this.bitField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyFiles(List<TorrentFile> list) {
        VerifyingFolder verifyingFolder = this;
        synchronized (verifyingFolder) {
            int n = this.verifiedBlocks.length();
        }
        for (TorrentFile torrentFile : list) {
            for (int i = Math.max(n, torrentFile.getBegin()); i <= torrentFile.getEnd(); ++i) {
                VERIFY_QUEUE.execute(new VerifyJob(i), this.context.getMetaInfo().getURN());
            }
        }
    }

    @Override
    public synchronized long getVerifiedBlockSize() {
        BTMetaInfo bTMetaInfo = this.context.getMetaInfo();
        long l = (long)this.verified.cardinality() * (long)bTMetaInfo.getPieceLength();
        if (this.verified.get(bTMetaInfo.getNumBlocks() - 1)) {
            l = l - (long)bTMetaInfo.getPieceLength() + (long)this.getPieceSize(bTMetaInfo.getNumBlocks() - 1);
        }
        return l;
    }

    @Override
    public synchronized long getBlockSize() {
        long l = this.getVerifiedBlockSize();
        return l + this.partialBlocks.byteSize();
    }

    @Override
    public synchronized long getNumCorruptedBytes() {
        return this._corruptedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BTDiskManagerMemento toMemento() {
        BTDiskManagerMementoImpl bTDiskManagerMementoImpl = new BTDiskManagerMementoImpl();
        VerifyingFolder verifyingFolder = this;
        synchronized (verifyingFolder) {
            HashMap<Integer, IntervalSet> hashMap = new HashMap<Integer, IntervalSet>(this.partialBlocks.size());
            for (Map.Entry entry : this.partialBlocks.entrySet()) {
                hashMap.put((Integer)entry.getKey(), ((IntervalSet)entry.getValue()).clone());
            }
            bTDiskManagerMementoImpl.setPartialBlocks(hashMap);
            bTDiskManagerMementoImpl.setVerifiedBlocks((BitSet)this.verifiedBlocks.clone());
            bTDiskManagerMementoImpl.setVerifying(this.isVerifying);
        }
        if (BittorrentSettings.TORRENT_FLUSH_VERIRY.getValue()) {
            try {
                this.diskController.flush();
            }
            catch (IOException iOException) {
                this.storedException = iOException;
            }
        }
        return bTDiskManagerMementoImpl;
    }

    @Override
    public synchronized int getAmountPending() {
        return (int)this.pendingRanges.byteSize();
    }

    @Override
    public synchronized int getNumMissing(BitField bitField) {
        if (this.isComplete()) {
            return this.verified.cardinality() - bitField.cardinality();
        }
        NotView notView = new NotView(bitField);
        return new AndView(this.verified, notView).cardinality();
    }

    @Override
    public synchronized boolean containsAnyWeMiss(BitField bitField) {
        if (this.isComplete()) {
            return false;
        }
        AndView andView = new AndView(bitField, this.missing);
        return andView.nextSetBit(0) > -1;
    }

    @Override
    public long getLastVerifiedOffset() {
        return this.lastVerifiedOffset;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlockRangeMap
    extends HashMap<Integer, IntervalSet> {
        private static final long serialVersionUID = 4006274480019024111L;

        BlockRangeMap() {
        }

        private BlockRangeMap(int n) {
            super(n);
        }

        public void addInterval(BTInterval bTInterval) {
            IntervalSet intervalSet = (IntervalSet)this.get(bTInterval.getBlockId());
            if (intervalSet == null) {
                intervalSet = new IntervalSet();
                this.put(bTInterval.getBlockId(), intervalSet);
            }
            intervalSet.add(bTInterval);
        }

        public void removeInterval(BTInterval bTInterval) {
            IntervalSet intervalSet = (IntervalSet)this.get(bTInterval.getBlockId());
            if (intervalSet == null) {
                return;
            }
            intervalSet.delete(bTInterval);
            if (intervalSet.isEmpty()) {
                this.remove(bTInterval.getBlockId());
            }
        }

        public long byteSize() {
            long l = 0L;
            for (IntervalSet intervalSet : this.values()) {
                l += intervalSet.getSize();
            }
            return l;
        }

        @Override
        public BlockRangeMap clone() {
            BlockRangeMap blockRangeMap = new BlockRangeMap(this.size());
            for (Map.Entry entry : this.entrySet()) {
                blockRangeMap.put(entry.getKey(), ((IntervalSet)entry.getValue()).clone());
            }
            return blockRangeMap;
        }
    }

    private class VerifyJob
    implements Runnable {
        private final int pieceNum;

        public VerifyJob(int n) {
            this.pieceNum = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (VerifyingFolder.this.storedException != null || !VerifyingFolder.this.isOpen() || VerifyingFolder.this.hasBlock(this.pieceNum)) {
                return;
            }
            try {
                if (VerifyingFolder.this.verify(this.pieceNum, true)) {
                    VerifyingFolder.this.markPieceCompleted(this.pieceNum);
                    VerifyingFolder.this.handleVerified(this.pieceNum);
                } else {
                    VerifyingFolder.this._corruptedBytes += VerifyingFolder.this.getPieceSize(this.pieceNum);
                }
            }
            catch (IOException iOException) {
                VerifyingFolder.this.storedException = iOException;
            }
            catch (InterruptedException interruptedException) {
                VerifyingFolder.this.storedException = new InterruptedIOException();
            }
            finally {
                if (VerifyingFolder.this.storedException != null && VerifyingFolder.this.isOpen()) {
                    VerifyingFolder.this.notifyDiskProblem(VerifyingFolder.this.storedException);
                }
            }
        }
    }

    private class SendJob
    implements Runnable {
        private final BTInterval in;
        private final PieceReadListener listener;

        SendJob(BTInterval bTInterval, PieceReadListener pieceReadListener) {
            this.in = bTInterval;
            this.listener = pieceReadListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!VerifyingFolder.this.isOpen()) {
                return;
            }
            if (VerifyingFolder.this.storedException != null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("reading piece " + this.in);
            }
            long l = this.in.getHigh() - this.in.getLow() + 1L;
            assert (l <= Integer.MAX_VALUE);
            int n = (int)l;
            long l2 = (long)this.in.getId() * (long)VerifyingFolder.this.context.getMetaInfo().getPieceLength() + this.in.getLow();
            int n2 = 0;
            byte[] byArray = new byte[n];
            boolean bl = false;
            try {
                while ((n2 += VerifyingFolder.this.diskController.read(l2 + (long)n2, byArray, n2, n - n2)) < n) {
                }
                bl = true;
            }
            catch (IOException iOException) {
                if (VerifyingFolder.this.isOpen()) {
                    VerifyingFolder.this.storedException = iOException;
                    VerifyingFolder.this.notifyDiskProblem(new DiskException(iOException));
                }
            }
            finally {
                if (bl) {
                    this.listener.pieceRead(this.in, byArray);
                } else {
                    this.listener.pieceReadFailed(this.in);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WriteJob
    implements Runnable {
        private final NECallable<BTPiece> factory;

        WriteJob(NECallable<BTPiece> nECallable) {
            this.factory = nECallable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (VerifyingFolder.this.storedException != null) {
                return;
            }
            BTPiece bTPiece = this.factory.call();
            BTInterval bTInterval = bTPiece.getInterval();
            if (bTInterval.getId() >= VerifyingFolder.this.verified.maxSize()) {
                return;
            }
            byte[] byArray = bTPiece.getData();
            VerifyingFolder verifyingFolder = VerifyingFolder.this;
            synchronized (verifyingFolder) {
                if (VerifyingFolder.this.hasBlock(bTInterval.getId())) {
                    return;
                }
                VerifyingFolder.this.pendingRanges.addInterval(bTInterval);
                VerifyingFolder.this.requestedRanges.removeInterval(bTInterval);
            }
            try {
                VerifyingFolder.this.writeBlockImpl(bTInterval, byArray);
            }
            catch (IOException iOException) {
                if (VerifyingFolder.this.isOpen()) {
                    VerifyingFolder.this.storedException = iOException;
                    VerifyingFolder.this.notifyDiskProblem(iOException);
                }
            }
            finally {
                VerifyingFolder verifyingFolder2 = VerifyingFolder.this;
                synchronized (verifyingFolder2) {
                    VerifyingFolder.this.pendingRanges.removeInterval(bTInterval);
                }
            }
        }
    }
}

