/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.disk;

import com.limegroup.bittorrent.disk.DiskController;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RAFDiskController<F extends File>
implements DiskController<F> {
    private static final Log LOG = LogFactory.getLog(RAFDiskController.class);
    protected List<F> _files;
    protected RandomAccessFile[] _fos = null;

    RAFDiskController() {
    }

    @Override
    public synchronized void write(long l, byte[] byArray) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("file closed");
        }
        int n = 0;
        int n2 = this._files.size();
        for (int i = 0; i < n2 && n < byArray.length; ++i) {
            File file = (File)this._files.get(i);
            if (l < file.length()) {
                int n3 = (int)Math.min(file.length() - l, (long)(byArray.length - n));
                this.writeImpl(this._fos[i], l, byArray, n, n3);
                l += (long)n3;
                n += n3;
            }
            l -= file.length();
        }
    }

    protected void writeImpl(RandomAccessFile randomAccessFile, long l, byte[] byArray, int n, int n2) throws IOException {
        randomAccessFile.seek(l);
        randomAccessFile.write(byArray, n, n2);
    }

    @Override
    public synchronized boolean isOpen() {
        return this._fos != null;
    }

    @Override
    public synchronized List<F> open(List<F> list, boolean bl, boolean bl2) throws IOException {
        this._files = list;
        if (this._fos != null) {
            throw new IOException("Files already open(ing)!");
        }
        RandomAccessFile[] randomAccessFileArray = new RandomAccessFile[this._files.size()];
        long l = 0L;
        ArrayList<File> arrayList = null;
        for (int i = 0; i < this._files.size(); ++i) {
            File file = (File)this._files.get(i);
            IOUtils.close(randomAccessFileArray[i]);
            if (bl) {
                LOG.info("opening torrent in read-only mode");
                randomAccessFileArray[i] = new RandomAccessFile(file, "r");
            } else {
                LOG.info("opening torrent in read-write");
                if (!file.exists()) {
                    File file2 = file.getParentFile();
                    if (file2 != null) {
                        file2.mkdirs();
                        FileUtils.setWriteable(file2);
                    }
                    file.createNewFile();
                    if (!bl2) {
                        bl2 = true;
                        i = -1;
                        continue;
                    }
                }
                FileUtils.setWriteable(file);
                randomAccessFileArray[i] = new RandomAccessFile(file, "rw");
                if (bl2 && randomAccessFileArray[i].length() > 0L) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<File>(this._files.size());
                    }
                    arrayList.add(file);
                }
            }
            l += file.length();
        }
        for (RandomAccessFile randomAccessFile : randomAccessFileArray) {
            if (randomAccessFile.getFD().valid()) continue;
            throw new IOException("file was invalid: " + randomAccessFile);
        }
        this._fos = randomAccessFileArray;
        return arrayList;
    }

    @Override
    public synchronized void close() {
        LOG.debug("closing the file");
        if (!this.isOpen()) {
            return;
        }
        for (RandomAccessFile randomAccessFile : this._fos) {
            IOUtils.close(randomAccessFile);
        }
        this._fos = null;
    }

    @Override
    public synchronized void setReadOnly(F f) throws IOException {
        if (!this.isOpen()) {
            return;
        }
        int n = this._files.indexOf(f);
        this._fos[n] = this.setReadOnly(this._fos[n], ((File)f).getPath());
        if (!this._fos[n].getFD().valid()) {
            throw new IOException("new fd invalid " + f);
        }
    }

    protected RandomAccessFile setReadOnly(RandomAccessFile randomAccessFile, String string) throws IOException {
        randomAccessFile.close();
        return new RandomAccessFile(string, "r");
    }

    @Override
    public synchronized int read(long l, byte[] byArray, int n, int n2) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("cannot seek negative position " + l);
        }
        if (n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("buffer to small to store supplied number of bytes");
        }
        if (!this.isOpen()) {
            throw new IOException("file closed");
        }
        int n3 = 0;
        for (int i = 0; i < this._files.size() && n3 < n2; ++i) {
            File file = (File)this._files.get(i);
            while (l < file.length() && n3 < n2) {
                assert (this._fos[i] != null) : "file being read & verified at the same time";
                long l2 = this._fos[i].length();
                if (l2 < file.length() && l >= l2) {
                    return n3;
                }
                int n4 = (int)Math.min(l2 - l, (long)(n2 - n3));
                int n5 = this.readImpl(this._fos[i], l, byArray, n3 + n, n4);
                if (n5 == -1) {
                    throw new IOException();
                }
                l += (long)n5;
                n3 += n5;
            }
            l -= file.length();
        }
        return n3;
    }

    protected int readImpl(RandomAccessFile randomAccessFile, long l, byte[] byArray, int n, int n2) throws IOException {
        randomAccessFile.seek(l);
        return randomAccessFile.read(byArray, n, n2);
    }

    @Override
    public synchronized void flush() throws IOException {
        LOG.debug("flushing");
        if (!this.isOpen()) {
            return;
        }
        for (RandomAccessFile randomAccessFile : this._fos) {
            if (randomAccessFile == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("flush npe report:");
                stringBuilder.append("  files:").append(this._files).append("  ");
                stringBuilder.append("fos length ").append(this._fos.length).append("  ");
                for (RandomAccessFile randomAccessFile2 : this._fos) {
                    stringBuilder.append(String.valueOf(randomAccessFile2)).append("  ");
                }
                throw new IllegalStateException(stringBuilder.toString());
            }
            randomAccessFile.getChannel().force(false);
        }
    }
}

