/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.choking;

import com.limegroup.bittorrent.Chokable;
import com.limegroup.bittorrent.choking.Choker;
import com.limegroup.gnutella.UploadServices;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.collection.NECallable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SeedChoker
extends Choker {
    private static final Comparator<Chokable> UPLOAD_SPEED_COMPARATOR = new Choker.SpeedComparator(false);
    private static final Comparator<Chokable> UNCHOKE_COMPARATOR = new UnchokeComparator();
    private int unchokesSinceLast;

    SeedChoker(NECallable<List<? extends Chokable>> nECallable, ScheduledExecutorService scheduledExecutorService, UploadServices uploadServices) {
        super(nECallable, scheduledExecutorService, uploadServices);
        this.round = Integer.MIN_VALUE;
    }

    private void initRound(List<? extends Chokable> list) {
        if (this.round >= 0) {
            return;
        }
        int n = 0;
        for (Chokable chokable : list) {
            n = Math.max(n, chokable.getUnchokeRound());
        }
        this.round = n;
    }

    @Override
    protected void rechokeImpl(boolean bl) {
        List list = (List)this.chokablesSource.call();
        this.initRound(list);
        int n = 0;
        if (bl) {
            int n2 = (this.getNumUploads() + 2) / 3;
            n = Math.max(0, n2 + this.round % 3) / 3 - this.unchokesSinceLast;
        }
        List<Chokable> list2 = new ArrayList();
        int n3 = this.round - 3;
        for (Chokable chokable : list) {
            if (chokable.isChoked() || !chokable.isInterested() || !chokable.shouldBeInterested()) continue;
            if (chokable.getUnchokeRound() < n3) {
                chokable.clearUnchokeRound();
            }
            list2.add(chokable);
        }
        int n4 = this.getNumUploads() - n;
        if (list2.size() > n4) {
            Collections.sort(list2, UNCHOKE_COMPARATOR);
            list2 = list2.subList(0, n4);
        }
        int n5 = this.getNumUploads() - list2.size();
        this.unchokesSinceLast = bl ? 0 : (this.unchokesSinceLast += n5);
        for (Chokable chokable : list) {
            if (list2.contains(chokable)) continue;
            if (!chokable.isInterested()) {
                chokable.choke();
                continue;
            }
            if (chokable.isChoked() && n5 > 0 && chokable.shouldBeInterested()) {
                chokable.unchoke(this.round);
                --n5;
                continue;
            }
            if (n5 == 0 || !chokable.shouldBeInterested()) {
                chokable.choke();
                continue;
            }
            --n5;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnchokeComparator
    implements Comparator<Chokable> {
        private UnchokeComparator() {
        }

        @Override
        public int compare(Chokable chokable, Chokable chokable2) {
            if (chokable == chokable2) {
                return 0;
            }
            if (chokable.getUnchokeRound() != chokable2.getUnchokeRound()) {
                return -1 * (chokable.getUnchokeRound() - chokable2.getUnchokeRound());
            }
            return UPLOAD_SPEED_COMPARATOR.compare(chokable, chokable2);
        }
    }
}

