/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.bencoding;

import com.limegroup.bittorrent.bencoding.Token;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.limewire.util.BEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BELong
extends Token<Long> {
    private static final byte MINUS;
    private static final BigInteger MAX;
    private StringBuilder sb = new StringBuilder();
    private byte[] currentByte = new byte[1];
    private ByteBuffer buf = ByteBuffer.wrap(this.currentByte);
    private int multiplier = 1;
    private boolean done;
    private final byte terminator;

    BELong(ReadableByteChannel readableByteChannel) {
        this(readableByteChannel, BEncoder.E, 0);
    }

    BELong(ReadableByteChannel readableByteChannel, byte by, byte by2) {
        super(readableByteChannel);
        this.terminator = by;
        if (by2 != 0) {
            if (by2 < ZERO || by2 > NINE) {
                throw new IllegalArgumentException("invalid first byte");
            }
            this.sb.append(by2 - ZERO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRead() throws IOException {
        if (this.done) {
            throw new IllegalStateException("this token is done.  Don't read it!");
        }
        while (true) {
            try {
                int n = this.chan.read(this.buf);
                if (n == -1) {
                    throw new EOFException("Could not read Integer Token");
                }
                if (n == 0) {
                    return;
                }
            }
            finally {
                this.buf.clear();
            }
            if (this.currentByte[0] < ZERO || this.currentByte[0] > NINE) {
                if (this.currentByte[0] == MINUS && this.sb.length() == 0 && this.multiplier != -1) {
                    this.multiplier = -1;
                    continue;
                }
                if (this.currentByte[0] == this.terminator && this.sb.length() != 0) {
                    try {
                        BigInteger bigInteger = new BigInteger(this.sb.toString());
                        if (bigInteger.compareTo(MAX) > 0) {
                            throw new IOException("too big");
                        }
                        this.result = bigInteger.longValue() * (long)this.multiplier;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException(numberFormatException.getMessage());
                    }
                    this.sb = null;
                    this.done = true;
                    return;
                }
                throw new IOException("invalid integer");
            }
            if (this.currentByte[0] == ZERO) {
                switch (this.sb.length()) {
                    case 0: {
                        if (this.multiplier == -1) {
                            throw new IOException("negative 0");
                        }
                        this.multiplier = 0;
                        break;
                    }
                    case 1: {
                        if (this.multiplier != 0) break;
                        throw new IOException("leading 0s");
                    }
                }
                this.sb.append(0);
                continue;
            }
            if (this.multiplier == 0) {
                throw new IOException("leading 0s - wrong");
            }
            this.sb.append(this.currentByte[0] - ZERO);
        }
    }

    @Override
    protected boolean isDone() {
        return this.done;
    }

    @Override
    public int getType() {
        return 0;
    }

    static {
        byte by = 0;
        try {
            by = "-".getBytes("ISO-8859-1")[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        MINUS = by;
        MAX = BigInteger.valueOf(Long.MAX_VALUE);
    }
}

