/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.bencoding;

import com.limegroup.bittorrent.bencoding.BEAbstractCollection;
import com.limegroup.bittorrent.bencoding.BEString;
import com.limegroup.bittorrent.bencoding.Token;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BEDictionary
extends BEAbstractCollection<Map<String, Object>> {
    BEDictionary(ReadableByteChannel readableByteChannel) {
        super(readableByteChannel);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    protected Map<String, Object> createCollection() {
        return new HashMap<String, Object>();
    }

    @Override
    protected void add(Object object) {
        BEEntry bEEntry = (BEEntry)object;
        ((Map)this.result).put(bEEntry.key, bEEntry.value);
    }

    @Override
    protected Token<?> getNewElement() {
        return new BEEntry(this.chan);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BEEntry
    extends Token<Object> {
        private BEString keyToken;
        private String key;
        private Token valueToken;
        private Object value;
        private boolean lastEntry;

        BEEntry(ReadableByteChannel readableByteChannel) {
            super(readableByteChannel);
            this.result = this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handleRead() throws IOException {
            Token<?> token;
            if (this.keyToken == null && this.key == null) {
                token = BEEntry.getNextToken(this.chan);
                if (token == null) return;
                if (token instanceof BEString) {
                    this.keyToken = (BEString)token;
                } else {
                    if (token != Token.TERMINATOR) throw new IOException("invalid entry - key not a string");
                    this.lastEntry = true;
                    return;
                }
            }
            if (this.key == null) {
                this.keyToken.handleRead();
                if (this.keyToken.getResult() == null) return;
                this.key = new String((byte[])this.keyToken.getResult(), "ISO-8859-1");
                this.keyToken = null;
            }
            if (this.valueToken == null && this.value == null) {
                token = BEEntry.getNextToken(this.chan);
                if (token == null) return;
                this.valueToken = token;
            }
            if (this.value != null) throw new IllegalStateException("token is done - don't read to it " + this.key + " " + this.value);
            this.valueToken.handleRead();
            this.value = this.valueToken.getResult();
            if (this.value == Token.TERMINATOR) {
                throw new IOException("missing value");
            }
            if (this.value == null) return;
            this.valueToken = null;
        }

        @Override
        protected boolean isDone() {
            return this.key != null && this.value != null;
        }

        @Override
        public Object getResult() {
            if (this.lastEntry) {
                return Token.TERMINATOR;
            }
            return super.getResult();
        }
    }
}

