/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.util.Base32;

public class TorrentLocation
extends IpPortImpl {
    private static final long serialVersionUID = 7953314787152210101L;
    private static final byte[] NULL_PEER_STRING = new byte[20];
    private static final byte[] EXTENTION_BYTES = new byte[8];
    private static final int MAX_STRIKES = 1;
    private static final int BUSY_WAIT_TIME = 300000;
    private final byte[] PEER_ID;
    private final byte[] EXTENSION_BYTES;
    private int _strikes = 0;
    private long _nextRetryTime = 0L;

    public TorrentLocation(InetSocketAddress inetSocketAddress, byte[] byArray, byte[] byArray2) {
        super(inetSocketAddress);
        this.PEER_ID = byArray == null ? NULL_PEER_STRING : byArray;
        this.EXTENSION_BYTES = byArray2;
    }

    public TorrentLocation(InetAddress inetAddress, int n, byte[] byArray) {
        super(inetAddress, n);
        this.PEER_ID = byArray == null ? NULL_PEER_STRING : byArray;
        this.EXTENSION_BYTES = EXTENTION_BYTES;
    }

    public TorrentLocation(TorrentLocation torrentLocation) {
        this(torrentLocation.getInetSocketAddress(), torrentLocation.getPeerID(), torrentLocation.EXTENSION_BYTES);
    }

    public byte[] getPeerID() {
        return this.PEER_ID;
    }

    public byte[] getExtBytes() {
        return this.EXTENSION_BYTES;
    }

    public void strike() {
        this._nextRetryTime = System.currentTimeMillis() + 300000L;
        ++this._strikes;
    }

    public boolean isBusy(long l) {
        return this._nextRetryTime > l;
    }

    public long getWaitTime(long l) {
        return Math.max(0L, this._nextRetryTime - l);
    }

    public boolean isOut() {
        return this._strikes > 1;
    }

    public boolean isLimePeer() {
        return this.PEER_ID[0] == 76 && this.PEER_ID[1] == 73 && this.PEER_ID[2] == 77 && this.PEER_ID[3] == 69;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TorrentLocation)) {
            return false;
        }
        TorrentLocation torrentLocation = (TorrentLocation)object;
        if (IpPort.COMPARATOR.compare(this, torrentLocation) != 0) {
            return false;
        }
        return Arrays.equals(torrentLocation.PEER_ID, this.PEER_ID);
    }

    public String toString() {
        return this.getAddress() + ":" + this.getPort() + ":" + new String(this.PEER_ID) + ":" + Base32.encode(this.EXTENSION_BYTES);
    }
}

