/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.plugins.models;

import com.frostwire.plugins.models.IPlugin;
import com.limegroup.gnutella.settings.PluginsSettings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginDownloader
extends Observable {
    private String pluginShortName;
    private int contentLength = -1;
    private int downloadedBytes = -1;
    private String pluginUrl = null;
    private HttpURLConnection connection = null;
    private String plugin_folder_path = PluginsSettings.PLUGINS_FOLDER.getValue();
    private File temp;
    private PluginDownloaderWorker worker;

    public PluginDownloader(IPlugin iPlugin, Collection<Observer> collection) {
        this(iPlugin.getName(), iPlugin.getDownloadURL(), collection);
    }

    public PluginDownloader(String string, String string2, Collection<Observer> collection) {
        this.pluginShortName = string;
        this.pluginUrl = string2;
        if (collection != null && collection.size() > 0) {
            Iterator<Observer> iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addObserver(iterator.next());
                System.out.println("(+) -.- [added observer] ");
            }
        }
    }

    public void connect() throws IOException {
        try {
            URL uRL = new URL(this.pluginUrl);
            this.connection = (HttpURLConnection)uRL.openConnection();
            this.sendNotification(DownloadState.CONNECTION_ESTABLISHED);
            this.contentLength = this.connection.getContentLength();
            this.sendNotification(DownloadState.CONTENT_LENGTH_SET);
            this.downloadedBytes = 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
    }

    public PluginDownloaderWorker startDownload() {
        this.temp = new File(this.plugin_folder_path + File.separator + this.pluginShortName + ".jar.temp");
        try {
            if (this.temp.exists()) {
                this.temp.delete();
            }
            this.temp.createNewFile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.sendNotification(DownloadState.CANCELLED_DOWNLOADING);
        }
        this.worker = new PluginDownloaderWorker();
        this.worker.start();
        return this.worker;
    }

    public String getPluginShortName() {
        return this.pluginShortName;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public PluginDownloaderWorker getWorker() {
        return this.worker;
    }

    public void setContentLength(int n) {
        this.contentLength = n;
    }

    public synchronized int getDownloadedBytes() {
        return this.downloadedBytes;
    }

    public void sendNotification(DownloadState downloadState) {
        this.setChanged();
        if (this.countObservers() > 0) {
            System.out.println("Sending notification -> " + (Object)((Object)downloadState));
            this.notifyObservers((Object)downloadState);
        } else {
            System.out.println("Nobody is watching me");
        }
    }

    public class PluginDownloaderWorker
    extends Thread {
        private boolean keepGoing;

        public synchronized void cancelDownload() {
            this.keepGoing = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.keepGoing = true;
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(PluginDownloader.this.connection.getInputStream());
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(PluginDownloader.this.temp));
                byte[] byArray = new byte[10240];
                int n = 0;
                while ((n = bufferedInputStream.read(byArray)) != -1 && this.keepGoing) {
                    PluginDownloader.this.downloadedBytes += n;
                    bufferedOutputStream.write(byArray, 0, n);
                    System.out.println(n);
                    PluginDownloader.this.sendNotification(DownloadState.DOWNLOADED_CHUNK);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                bufferedInputStream.close();
                PluginDownloader.this.connection.disconnect();
                if (PluginDownloader.this.downloadedBytes >= PluginDownloader.this.getContentLength()) {
                    File file = new File(PluginDownloader.this.plugin_folder_path + File.separator + PluginDownloader.this.pluginShortName + ".jar");
                    if (file.exists()) {
                        file.delete();
                        file = new File(PluginDownloader.this.plugin_folder_path + File.separator + PluginDownloader.this.pluginShortName + ".jar");
                    }
                    file.createNewFile();
                    PluginDownloader.this.temp.renameTo(file);
                }
            }
            catch (EOFException eOFException) {
                System.out.println("PluginDownloader.startDownload()::downloadWorker: We reached the end!");
                PluginDownloader.this.sendNotification(DownloadState.FINISHED_DOWNLOADING);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                PluginDownloader.this.sendNotification(DownloadState.CANCELLED_DOWNLOADING);
            }
            catch (Exception exception) {
                System.out.println("Unexpected Exception downloading " + PluginDownloader.this.pluginShortName);
                exception.printStackTrace();
            }
            finally {
                if (!this.keepGoing) {
                    System.out.println("PluginDownloader.run() -> somebody told me to stop!");
                    PluginDownloader.this.sendNotification(DownloadState.CANCELLED_DOWNLOADING);
                } else {
                    PluginDownloader.this.sendNotification(DownloadState.FINISHED_DOWNLOADING);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DownloadState {
        CONNECTION_ESTABLISHED,
        CONTENT_LENGTH_SET,
        DOWNLOADED_CHUNK,
        FINISHED_DOWNLOADING,
        CANCELLED_DOWNLOADING;

    }
}

