/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.guice;

import com.google.inject.Singleton;
import com.google.inject.name.Names;
import com.limegroup.gnutella.http.DefaultHttpExecutor;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.settings.SettingsBackedProxySettings;
import com.limegroup.gnutella.settings.SettingsBackedSocketBindingSettings;
import java.lang.annotation.Annotation;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.concurrent.AbstractLazySingletonProvider;
import org.limewire.concurrent.SimpleTimer;
import org.limewire.http.LimeWireHttpModule;
import org.limewire.inject.AbstractModule;
import org.limewire.io.LimeWireIOModule;
import org.limewire.io.LocalSocketAddressProvider;
import org.limewire.net.LimeWireNetModule;

public class FrostWireCoreModule
extends AbstractModule {
    protected void configure() {
        this.binder().install(new LimeWireNetModule(SettingsBackedProxySettings.class, SettingsBackedSocketBindingSettings.class));
        this.binder().install(new LimeWireHttpModule());
        this.binder().install(new LimeWireIOModule());
        this.bind(HttpExecutor.class).to(DefaultHttpExecutor.class);
        this.bind(LocalSocketAddressProvider.class).to(MyLocalSocketAddressProviderImpl.class);
        this.bindAll((Annotation)Names.named("backgroundExecutor"), ScheduledExecutorService.class, BackgroundTimerProvider.class, ExecutorService.class, Executor.class);
    }

    @Singleton
    private static class MyLocalSocketAddressProviderImpl
    implements LocalSocketAddressProvider {
        private MyLocalSocketAddressProviderImpl() {
        }

        public byte[] getLocalAddress() {
            return null;
        }

        public int getLocalPort() {
            return 0;
        }

        public boolean isLocalAddressPrivate() {
            return ConnectionSettings.LOCAL_IS_PRIVATE.getValue();
        }

        public boolean isTLSCapable() {
            return SSLSettings.isIncomingTLSEnabled();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class BackgroundTimerProvider
    extends AbstractLazySingletonProvider<ScheduledExecutorService> {
        private BackgroundTimerProvider() {
        }

        @Override
        protected ScheduledExecutorService createObject() {
            return new SimpleTimer(true);
        }
    }
}

