/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.gnutella.gui.GraphicPanel;
import com.frostwire.gnutella.gui.android.CopyToDesktopTask;
import com.frostwire.gnutella.gui.android.CopyToDeviceTask;
import com.frostwire.gnutella.gui.android.Task;
import com.frostwire.gnutella.gui.android.UITool;
import com.limegroup.gnutella.gui.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;

public class TaskRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 3202019053091139910L;
    private static final Color COLOR_SELECTED = new Color(9286381);
    private static final Color COLOR_EVEN_ROW = new Color(0xFFFFFF);
    private static final Color COLOR_ODD_ROW = new Color(13624298);
    private static final Color COLOR_PROGRESS_LIGHT = new Color(0xFFFFCF);
    private static final Color COLOR_PROGRESS = new Color(16573204);
    private static UITool UI_TOOL = new UITool();
    private static Map<Integer, Image> TO_DEVICE_IMAGE_TYPES = new HashMap<Integer, Image>();
    private static Map<Integer, Image> TO_DESKTOP_IMAGE_TYPES = new HashMap<Integer, Image>();
    private static Image IMAGE_STOP;
    private Task _task;
    private boolean _selected;
    private int _index;
    private GraphicPanel _imagePanel;
    private JLabel _labelText;
    private JLabel _labelPercent;
    private JRadioButton _buttonStop;

    public TaskRenderer() {
        this.setupUI();
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this._task = (Task)object;
        this._selected = bl;
        this._index = n;
        if (this._task instanceof CopyToDesktopTask) {
            this.renderDownload((CopyToDesktopTask)this._task);
        } else if (this._task instanceof CopyToDeviceTask) {
            this.renderUpload((CopyToDeviceTask)this._task);
        }
        return this;
    }

    public Component getComponentAt(int n, int n2) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!this.getComponent(i).getBounds().contains(n, n2)) continue;
            return this.getComponent(i);
        }
        if (this.getBounds().contains(n, n2)) {
            return this;
        }
        return null;
    }

    protected void setupUI() {
        this.setLayout(new GridBagLayout());
        this._imagePanel = new GraphicPanel();
        Dimension dimension = new Dimension(32, 32);
        this._imagePanel.setPreferredSize(dimension);
        this._imagePanel.setMinimumSize(dimension);
        this._imagePanel.setMaximumSize(dimension);
        this._imagePanel.setSize(dimension);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this._imagePanel, gridBagConstraints);
        this._labelText = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this._labelText, gridBagConstraints);
        this._labelPercent = new JLabel();
        this._labelPercent.setForeground(Color.LIGHT_GRAY);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this._labelPercent, gridBagConstraints);
        this._buttonStop = new JRadioButton();
        this._buttonStop.setBorder(null);
        this._buttonStop.setBackground(null);
        this._buttonStop.setFocusable(false);
        this._buttonStop.setFocusPainted(false);
        this._buttonStop.setContentAreaFilled(false);
        this._buttonStop.setIcon(new ImageIcon(this.loadImageStop()));
        this._buttonStop.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                TaskRenderer.this.buttonStop_mouseReleased(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this._buttonStop, gridBagConstraints);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this._selected) {
            graphics.setColor(COLOR_SELECTED);
            graphics.fillRect(0, 0, n, n2);
        } else {
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, n, n2);
        }
        if (this._index % 2 == 0) {
            graphics.setColor(COLOR_EVEN_ROW);
            graphics.fillRoundRect(2, 2, n - 4, n2 - 4, 5, 5);
        } else {
            graphics.setColor(COLOR_ODD_ROW);
            graphics.fillRoundRect(2, 2, n - 4, n2 - 4, 5, 5);
        }
        if (this._task.getProgress() != 0 && this._task.getProgress() != 100 && !this._task.isCanceled() && !this._task.isFailed()) {
            graphics.setColor(COLOR_PROGRESS_LIGHT);
            graphics.fillRoundRect(2, 2, n - 4, n2 - 4, 5, 5);
            int n3 = n * this._task.getProgress() / 100;
            if (n3 > n - 4) {
                n3 = n - 4;
            }
            graphics.setColor(COLOR_PROGRESS);
            graphics.fillRoundRect(2, 2, n3, n2 - 4, 5, 5);
        }
    }

    protected void buttonStop_mouseReleased(MouseEvent mouseEvent) {
        this._task.cancel();
        this._buttonStop.setVisible(false);
    }

    private void renderDownload(CopyToDesktopTask copyToDesktopTask) {
        Image image = null;
        if (TO_DESKTOP_IMAGE_TYPES.containsKey(copyToDesktopTask.getFileType())) {
            image = TO_DESKTOP_IMAGE_TYPES.get(copyToDesktopTask.getFileType());
        } else {
            BufferedImage bufferedImage = UI_TOOL.loadImage("copy_device");
            BufferedImage bufferedImage2 = UI_TOOL.loadImage(UI_TOOL.getImageNameByFileType(copyToDesktopTask.getFileType()));
            image = this.composeImage(bufferedImage, bufferedImage2, false);
            TO_DESKTOP_IMAGE_TYPES.put(copyToDesktopTask.getFileType(), image);
        }
        this._imagePanel.setImage(image);
        if (copyToDesktopTask.getProgress() == 0 && !copyToDesktopTask.isCanceled() && !copyToDesktopTask.isFailed()) {
            this._labelText.setText(I18n.tr("Download") + " " + (copyToDesktopTask.getTotalItems() == 1 ? I18n.tr("one file") : copyToDesktopTask.getTotalItems() + " " + I18n.tr("files")) + " " + I18n.tr("from") + " " + copyToDesktopTask.getDevice().getName());
            this._labelPercent.setText(I18n.tr("pending"));
            this._buttonStop.setVisible(true);
        } else if (copyToDesktopTask.getProgress() == 100) {
            this._labelText.setText(I18n.tr("Downloaded") + " " + (copyToDesktopTask.getTotalItems() == 1 ? I18n.tr("one file") : copyToDesktopTask.getTotalItems() + " " + I18n.tr("files")) + " " + I18n.tr("from") + " " + copyToDesktopTask.getDevice().getName());
            this._labelPercent.setText(I18n.tr("done"));
            this._buttonStop.setVisible(false);
        } else if (copyToDesktopTask.isCanceled()) {
            this._labelText.setText(I18n.tr("Download") + " " + (copyToDesktopTask.getTotalItems() == 1 ? I18n.tr("one file") : copyToDesktopTask.getTotalItems() + " " + I18n.tr("files")) + " " + I18n.tr("from") + " " + copyToDesktopTask.getDevice().getName());
            this._labelPercent.setText(I18n.tr("canceled"));
            this._buttonStop.setVisible(false);
        } else if (copyToDesktopTask.isFailed()) {
            this._labelText.setText(I18n.tr("Download") + " " + (copyToDesktopTask.getTotalItems() == 1 ? I18n.tr("one file") : copyToDesktopTask.getTotalItems() + " " + I18n.tr("files")) + " " + I18n.tr("from") + " " + copyToDesktopTask.getDevice().getName());
            this._labelPercent.setText(I18n.tr("error"));
            this._buttonStop.setVisible(false);
        } else {
            this._labelText.setText(I18n.tr("Downloading") + " " + (copyToDesktopTask.getTotalItems() == 1 ? I18n.tr("one file") : copyToDesktopTask.getCurrentIndex() + 1 + " " + I18n.tr("out of") + " " + copyToDesktopTask.getTotalItems() + " " + I18n.tr("files")) + " " + I18n.tr("from") + " " + copyToDesktopTask.getDevice().getName());
            this._labelPercent.setText(copyToDesktopTask.getProgress() + "%");
            this._buttonStop.setVisible(true);
        }
    }

    private void renderUpload(CopyToDeviceTask copyToDeviceTask) {
        Image image = null;
        if (TO_DEVICE_IMAGE_TYPES.containsKey(copyToDeviceTask.getFileType())) {
            image = TO_DEVICE_IMAGE_TYPES.get(copyToDeviceTask.getFileType());
        } else {
            BufferedImage bufferedImage = UI_TOOL.loadImage("copy_desktop");
            image = bufferedImage.getScaledInstance(26, 26, 4);
            TO_DEVICE_IMAGE_TYPES.put(copyToDeviceTask.getFileType(), image);
        }
        this._imagePanel.setImage(image);
        if (copyToDeviceTask.getProgress() == 0 && !copyToDeviceTask.isCanceled() && !copyToDeviceTask.isFailed()) {
            if (copyToDeviceTask.isWaitingForAuthorization()) {
                this._labelText.setText(I18n.tr("Waiting for authorization from ") + " " + copyToDeviceTask.getDevice().getName());
                this._labelPercent.setText("0%");
            } else {
                this._labelText.setText(I18n.tr("Upload") + " " + (copyToDeviceTask.getTotalItems() == 1 ? I18n.tr("one file") : copyToDeviceTask.getTotalItems() + " " + I18n.tr("files")) + " " + I18n.tr("to") + " " + copyToDeviceTask.getDevice().getName());
                this._labelPercent.setText(I18n.tr("pending"));
                this._buttonStop.setVisible(true);
            }
        } else if (copyToDeviceTask.isCanceled()) {
            this._labelText.setText(I18n.tr("Upload") + " " + (copyToDeviceTask.getTotalItems() == 1 ? I18n.tr("one file") : copyToDeviceTask.getTotalItems() + " " + I18n.tr("files")) + " " + I18n.tr("to") + " " + copyToDeviceTask.getDevice().getName());
            this._labelPercent.setText(I18n.tr("canceled"));
            this._buttonStop.setVisible(false);
        } else if (copyToDeviceTask.isFailed()) {
            this._labelText.setText(I18n.tr("Upload") + " " + (copyToDeviceTask.getTotalItems() == 1 ? I18n.tr("one file") : copyToDeviceTask.getTotalItems() + " " + I18n.tr("files")) + " " + I18n.tr("to") + " " + copyToDeviceTask.getDevice().getName());
            this._labelPercent.setText(I18n.tr("error"));
            this._buttonStop.setVisible(false);
        } else if (copyToDeviceTask.getProgress() == 100) {
            this._labelText.setText(I18n.tr("Uploaded") + " " + (copyToDeviceTask.getTotalItems() == 1 ? I18n.tr("one file") : copyToDeviceTask.getTotalItems() + " " + I18n.tr("files")) + " " + I18n.tr("to") + " " + copyToDeviceTask.getDevice().getName());
            this._labelPercent.setText(I18n.tr("done"));
            this._buttonStop.setVisible(false);
        } else {
            this._labelText.setText(I18n.tr("Uploading") + " " + (copyToDeviceTask.getTotalItems() == 1 ? I18n.tr("one file") : copyToDeviceTask.getCurrentIndex() + 1 + " " + I18n.tr("out of") + " " + copyToDeviceTask.getTotalItems() + " " + I18n.tr("files")) + " " + I18n.tr("to") + " " + copyToDeviceTask.getDevice().getName());
            this._labelPercent.setText(copyToDeviceTask.getProgress() + "%");
            this._buttonStop.setVisible(true);
        }
    }

    private Image loadImageStop() {
        if (IMAGE_STOP != null) {
            return IMAGE_STOP;
        }
        IMAGE_STOP = UI_TOOL.loadImage("stop").getScaledInstance(24, 24, 4);
        return IMAGE_STOP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image composeImage(BufferedImage bufferedImage, BufferedImage bufferedImage2, boolean bl) {
        BufferedImage bufferedImage3 = bufferedImage;
        Image image = bufferedImage2.getScaledInstance(32, 32, 4);
        int n = bufferedImage3.getWidth();
        int n2 = bufferedImage3.getHeight();
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        int n5 = 64;
        int n6 = 64;
        BufferedImage bufferedImage4 = new BufferedImage(n5, n6, 2);
        Graphics2D graphics2D = bufferedImage4.createGraphics();
        try {
            graphics2D.drawImage(bufferedImage3, 0, 4, n, n2, null);
            if (bl) {
                graphics2D.drawImage(image, 0, 20, n3, n4, null);
            } else {
                graphics2D.drawImage(image, 32, 20, n3, n4, null);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        return bufferedImage4.getScaledInstance(32, 32, 4);
    }
}

