/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Task
implements Runnable {
    private List<OnChangedListener> _listeners = new ArrayList<OnChangedListener>();
    private int _progress;
    private boolean _canceled;
    private boolean _failed;
    private Exception _failException;

    public List<OnChangedListener> getOnChangedListeners() {
        return this._listeners;
    }

    public void addOnChangedListener(OnChangedListener onChangedListener) {
        this._listeners.add(onChangedListener);
    }

    public int getProgress() {
        return this._progress;
    }

    public void setProgress(int n) {
        if (n < 0 || n > 100) {
            System.out.println("que paso");
        }
        n = n < 0 ? 0 : n;
        this._progress = n = n > 100 ? 100 : n;
        this.notifyOnChanged();
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public boolean isRunning() {
        return !this.isCanceled() && !this.isFailed() && this.getProgress() != 100;
    }

    public void cancel() {
        if (this.getProgress() == 100) {
            return;
        }
        this._canceled = true;
        this.notifyOnChanged();
    }

    public boolean isFailed() {
        return this._failed;
    }

    public Exception getFailException() {
        return this._failException;
    }

    public void fail(Exception exception) {
        if (this.getProgress() == 100) {
            return;
        }
        this._failed = true;
        this._failException = exception;
        this.notifyOnChanged();
    }

    public boolean enqueue() {
        return true;
    }

    protected void notifyOnChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            OnChangedListener onChangedListener = this._listeners.get(i);
            if (onChangedListener == null) continue;
            onChangedListener.onChanged(this);
        }
    }

    public static interface OnChangedListener {
        public void onChanged(Task var1);
    }
}

