/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JList;

public class RedispatchMouseListener
implements MouseListener,
MouseMotionListener {
    private JList _list;
    private MouseEvent _mousePressedEvent;
    private MouseListener[] _mouseListeners;
    private MouseMotionListener[] _motionListeners;

    public RedispatchMouseListener(JList jList) {
        this._list = jList;
        this._mouseListeners = jList.getMouseListeners();
        this._motionListeners = jList.getMouseMotionListeners();
        for (MouseListener eventListener : this._mouseListeners) {
            jList.removeMouseListener(eventListener);
        }
        for (EventListener eventListener : this._motionListeners) {
            jList.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        jList.addMouseMotionListener(this);
    }

    public Component getComponentAt(MouseEvent mouseEvent) {
        int n = this._list.locationToIndex(mouseEvent.getPoint());
        if (n == -1) {
            return null;
        }
        int n2 = mouseEvent.getX() - this._list.indexToLocation((int)n).x;
        int n3 = mouseEvent.getY() - this._list.indexToLocation((int)n).y;
        Component component = this._list.getCellRenderer().getListCellRendererComponent(this._list, this._list.getModel().getElementAt(n), n, false, false);
        return component.getComponentAt(n2, n3);
    }

    public Rectangle getRepaintBounds(MouseEvent mouseEvent) {
        int n = this._list.locationToIndex(mouseEvent.getPoint());
        if (n == -1) {
            return null;
        }
        Point point = this._list.indexToLocation(n);
        Component component = this._list.getCellRenderer().getListCellRendererComponent(this._list, this._list.getModel().getElementAt(n), n, false, false);
        return new Rectangle(point.x, point.y, component.getPreferredSize().width, component.getPreferredSize().height);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Component component = this.getComponentAt(mouseEvent);
        if (component != null) {
            component.dispatchEvent(new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), 0, 0, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
            this._list.repaint(this.getRepaintBounds(mouseEvent));
        }
        if (component instanceof AbstractButton) {
            return;
        }
        for (MouseListener mouseListener : this._mouseListeners) {
            mouseListener.mouseClicked(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Component component = this.getComponentAt(mouseEvent);
        this._mousePressedEvent = mouseEvent;
        if (component != null) {
            component.dispatchEvent(new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), 0, 0, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
            this._list.repaint(this.getRepaintBounds(mouseEvent));
        }
        if (component instanceof AbstractButton) {
            return;
        }
        for (MouseListener mouseListener : this._mouseListeners) {
            mouseListener.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._mousePressedEvent != null) {
            Component component = this.getComponentAt(this._mousePressedEvent);
            if (component != null) {
                component.dispatchEvent(new MouseEvent(component, 502, mouseEvent.getWhen(), mouseEvent.getModifiers(), 0, 0, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
                this._list.repaint(this.getRepaintBounds(this._mousePressedEvent));
            }
            if (component instanceof AbstractButton) {
                return;
            }
        }
        for (MouseListener mouseListener : this._mouseListeners) {
            mouseListener.mouseReleased(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : this._mouseListeners) {
            mouseListener.mouseEntered(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : this._mouseListeners) {
            mouseListener.mouseExited(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Component object;
        if (this._mousePressedEvent != null && (object = this.getComponentAt(this._mousePressedEvent)) instanceof JButton) {
            return;
        }
        for (MouseMotionListener mouseMotionListener : this._motionListeners) {
            mouseMotionListener.mouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        for (MouseMotionListener mouseMotionListener : this._motionListeners) {
            mouseMotionListener.mouseMoved(mouseEvent);
        }
    }
}

