/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.gnutella.gui.GraphicPanel;
import com.frostwire.gnutella.gui.android.LocalFile;
import com.frostwire.gnutella.gui.android.MultilineLabel;
import com.frostwire.gnutella.gui.android.UITool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileSystemView;

public class LocalFileRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 8723371611297478100L;
    private static final Color FILL_COLOR = new Color(9286381);
    private static final Color INNER_BORDER_COLOR = new Color(10010623);
    private static final Color OUTER_BORDER_COLOR = new Color(5334664);
    private static final Color EXT_SHADOW_COLOR = new Color(0x333333);
    private static final Color EXT_COLOR = new Color(0xFFFFFF);
    private static final int EXT_POS_X = 14;
    private static final int EXT_POS_Y = 14;
    private static final int EXT_SHADOW_DELTA = 10;
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yy hh:mm:ss aa");
    private static Map<String, BufferedImage> IMAGE_TYPES = new HashMap<String, BufferedImage>();
    private static FileSystemView FILE_SYSTEM_VIEW = FileSystemView.getFileSystemView();
    private static UITool UI_TOOL = new UITool();
    private LocalFile _localFile;
    private int _layoutOrientation = -1;
    private boolean _selected;
    private GraphicPanel _imagePanel;
    private MultilineLabel _multilineLabelName;
    private JLabel _labelName;
    private JLabel _labelDateModified;
    private JLabel _labelSize;

    public LocalFileRenderer() {
        this.setupUI();
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this._localFile = (LocalFile)object;
        this._selected = bl;
        if (this._layoutOrientation != jList.getLayoutOrientation()) {
            this._layoutOrientation = jList.getLayoutOrientation();
            this.relayout();
        }
        if (this._localFile == null) {
            return this;
        }
        File file = this._localFile.getFile();
        this.setImagePanelThumbnail(this._localFile);
        if (this._layoutOrientation == 2) {
            this._multilineLabelName.setText(FILE_SYSTEM_VIEW.getSystemDisplayName(file));
        } else {
            this._labelName.setText(FILE_SYSTEM_VIEW.getSystemDisplayName(file));
            this._labelDateModified.setText(DATE_FORMAT.format(new Date(file.lastModified())));
            this._labelSize.setText(UI_TOOL.getBytesInHuman(file.length()));
        }
        this.setToolTip(file);
        return this;
    }

    public Component getComponentAt(int n, int n2) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!this.getComponent(i).getBounds().contains(n, n2)) continue;
            return this.getComponent(i);
        }
        if (this.getBounds().contains(n, n2)) {
            return this;
        }
        return null;
    }

    public Dimension getLabelNameSize() {
        return this._labelName.getSize();
    }

    public Point getLabelNameLocation() {
        return this._labelName.getLocation();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, n, n2);
        if (this._selected) {
            graphics.setColor(FILL_COLOR);
            graphics.fillRoundRect(2, 2, n - 5, n2 - 5, 5, 5);
            graphics.setColor(INNER_BORDER_COLOR);
            graphics.drawRoundRect(3, 3, n - 7, n2 - 7, 5, 5);
            graphics.setColor(OUTER_BORDER_COLOR);
            graphics.drawRoundRect(2, 2, n - 5, n2 - 5, 5, 5);
        }
    }

    protected void setupUI() {
        this._imagePanel = new GraphicPanel();
        this._multilineLabelName = new MultilineLabel();
        this._labelName = new JLabel();
        this._labelDateModified = new JLabel();
        this._labelSize = new JLabel();
        Dimension dimension = new Dimension(70, 26);
        this._labelSize.setPreferredSize(dimension);
        this._labelSize.setMinimumSize(dimension);
        this._labelSize.setHorizontalAlignment(4);
    }

    private void relayout() {
        IMAGE_TYPES.remove(this._localFile.getExt());
        this.remove(this._imagePanel);
        this.remove(this._multilineLabelName);
        this.remove(this._labelName);
        this.remove(this._labelDateModified);
        this.remove(this._labelSize);
        if (this._layoutOrientation == 2) {
            this.layoutThumbnail();
        } else {
            this.layoutList();
        }
    }

    private void layoutThumbnail() {
        this.setLayout(new GridBagLayout());
        Dimension dimension = new Dimension(140, 100);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setSize(dimension);
        Dimension dimension2 = new Dimension(64, 64);
        this._imagePanel.setPreferredSize(dimension2);
        this._imagePanel.setMinimumSize(dimension2);
        this._imagePanel.setMaximumSize(dimension2);
        this._imagePanel.setSize(dimension2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 38, 0, 38);
        this.add((Component)this._imagePanel, gridBagConstraints);
        Dimension dimension3 = new Dimension(118, 30);
        this._multilineLabelName.setPreferredSize(dimension3);
        this._multilineLabelName.setMinimumSize(dimension3);
        this._multilineLabelName.setMaximumSize(dimension3);
        this._multilineLabelName.setSize(dimension3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 12, 0, 10);
        this.add((Component)this._multilineLabelName, gridBagConstraints);
    }

    private void layoutList() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(null);
        Dimension dimension = new Dimension(32, 32);
        this._imagePanel.setPreferredSize(dimension);
        this._imagePanel.setMinimumSize(dimension);
        this._imagePanel.setMaximumSize(dimension);
        this._imagePanel.setSize(dimension);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this._imagePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this._labelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this._labelDateModified, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this._labelSize, gridBagConstraints);
    }

    private void setImagePanelThumbnail(LocalFile localFile) {
        if (localFile == null) {
            return;
        }
        Image image = null;
        if (localFile.getFile().isDirectory()) {
            image = this._layoutOrientation == 2 ? UI_TOOL.loadImage("folder_64") : UI_TOOL.loadImage("folder_32");
        } else {
            String string = localFile.getExt();
            if (IMAGE_TYPES.containsKey(string)) {
                image = IMAGE_TYPES.get(string);
            } else {
                BufferedImage bufferedImage = UI_TOOL.loadImage(UI_TOOL.getImageNameByFileType(localFile.getFileType()));
                if (string != null) {
                    bufferedImage = this.composeImage(bufferedImage, string);
                    IMAGE_TYPES.put(string, bufferedImage);
                }
                image = bufferedImage;
            }
            if (this._layoutOrientation != 2) {
                image = image.getScaledInstance(24, 24, 4);
            }
        }
        this._imagePanel.setImage(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage composeImage(BufferedImage bufferedImage, String string) {
        BufferedImage bufferedImage2 = bufferedImage;
        BufferedImage bufferedImage3 = this.buildTextImage(string.toUpperCase());
        int n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        int n3 = bufferedImage3.getWidth();
        int n4 = bufferedImage3.getHeight();
        int n5 = n;
        int n6 = n2;
        BufferedImage bufferedImage4 = new BufferedImage(n5, n6, 2);
        Graphics2D graphics2D = bufferedImage4.createGraphics();
        try {
            graphics2D.drawImage(bufferedImage2, 0, 0, n, n2, null);
            if (string.length() <= 3) {
                graphics2D.drawImage(bufferedImage3, 14, 14, n3, n4, null);
            } else {
                graphics2D.drawImage(bufferedImage3, 4, 14, n3, n4, null);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        return bufferedImage4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage buildTextImage(String string) {
        if (string.length() > 3) {
            string = string.substring(0, 4);
        }
        Font font = new Font("Courier", 3, 16);
        Graphics graphics = null;
        Graphics graphics2 = null;
        Graphics graphics3 = null;
        BufferedImage bufferedImage = null;
        try {
            BufferedImage bufferedImage2 = new BufferedImage(32, 32, 2);
            graphics = bufferedImage2.createGraphics();
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n = fontMetrics.stringWidth(string) + 20;
            int n2 = fontMetrics.getHeight() + 10;
            BufferedImage bufferedImage3 = new BufferedImage(n, n2, 2);
            graphics2 = bufferedImage3.createGraphics();
            ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            TextLayout textLayout = new TextLayout(string, font, ((Graphics2D)graphics2).getFontRenderContext());
            ((Graphics2D)graphics2).setPaint(EXT_SHADOW_COLOR);
            textLayout.draw((Graphics2D)graphics2, 11.0f, 14.0f);
            graphics2.dispose();
            float f = 0.33333334f;
            float[] fArray = new float[]{f, f, f, f, f, f, f, f, f};
            ConvolveOp convolveOp = new ConvolveOp(new Kernel(3, 3, fArray), 1, null);
            BufferedImage bufferedImage4 = convolveOp.filter(bufferedImage3, null);
            graphics3 = bufferedImage4.createGraphics();
            ((Graphics2D)graphics3).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)graphics3).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            ((Graphics2D)graphics3).setPaint(EXT_COLOR);
            textLayout.draw((Graphics2D)graphics3, 10.0f, 13.0f);
            bufferedImage = bufferedImage4;
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
            if (graphics != null) {
                graphics2.dispose();
            }
            if (graphics != null) {
                graphics3.dispose();
            }
        }
        return bufferedImage;
    }

    private void setToolTip(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(FILE_SYSTEM_VIEW.getSystemDisplayName(file) + "<br/>");
        stringBuilder.append(DATE_FORMAT.format(new Date(file.lastModified())) + "<br/>");
        stringBuilder.append(UI_TOOL.getBytesInHuman(file.length()));
        stringBuilder.append("</html>");
        this.setToolTipText(stringBuilder.toString());
    }
}

