/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.gnutella.gui.android.LocalFile;
import com.limegroup.gnutella.gui.I18n;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileListModel
extends AbstractListModel {
    private static final long serialVersionUID = 3669455405023885518L;
    public static final int SORT_BY_NONE = 0;
    public static final int SORT_BY_NAME_ASC = 1;
    public static final int SORT_BY_NAME_DESC = 2;
    public static final int SORT_BY_DATE_ASC = 3;
    public static final int SORT_BY_DATE_DESC = 4;
    public static final int SORT_BY_KIND_ASC = 5;
    public static final int SORT_BY_KIND_DESC = 6;
    public static final int SORT_BY_SIZE_ASC = 7;
    public static final int SORT_BY_SIZE_DESC = 8;
    private File _root;
    private List<LocalFile> _files = new ArrayList<LocalFile>();
    private int _sortCriteria = 5;
    private OnRootListener _listener;
    private MyOnOpenListener _myOnOpenListener = new MyOnOpenListener();

    public void setRoot(File file) {
        if (!file.isDirectory()) {
            return;
        }
        this._root = file;
        this._files.clear();
        List<LocalFile> list = this.getChildren(this._root);
        if (this._sortCriteria != 0) {
            Collections.sort(list, new Comparator<LocalFile>(){

                @Override
                public int compare(LocalFile localFile, LocalFile localFile2) {
                    File file = localFile.getFile();
                    File file2 = localFile2.getFile();
                    Long l = file.lastModified();
                    Long l2 = file2.lastModified();
                    switch (LocalFileListModel.this._sortCriteria) {
                        case 1: {
                            return file.getName().compareTo(file2.getName());
                        }
                        case 2: {
                            return -1 * file.getName().compareTo(file2.getName());
                        }
                        case 3: {
                            return l.compareTo(l2);
                        }
                        case 4: {
                            return -1 * l.compareTo(l2);
                        }
                        case 5: {
                            return LocalFileListModel.this.compareByKind(file, file2);
                        }
                        case 6: {
                            return -1 * LocalFileListModel.this.compareByKind(file, file2);
                        }
                        case 7: {
                            return LocalFileListModel.this.compareByLength(file, file2, true);
                        }
                        case 8: {
                            return LocalFileListModel.this.compareByLength(file, file2, false);
                        }
                    }
                    return 0;
                }
            });
        }
        this._files.addAll(list);
        this.fireOnRoot(file);
        this.fireContentsChanged(this, 0, this._files.size() - 1);
    }

    public File getRoot() {
        return this._root;
    }

    public OnRootListener getOnRootListener() {
        return this._listener;
    }

    public void setOnRootListener(OnRootListener onRootListener) {
        this._listener = onRootListener;
    }

    @Override
    public int getSize() {
        return this._files.size();
    }

    @Override
    public Object getElementAt(int n) {
        if (n >= 0 && n < this._files.size()) {
            return this._files.get(n);
        }
        return null;
    }

    public void refresh() {
        this.setRoot(this._root);
    }

    public LocalFile createNewFolder() {
        File file = null;
        LocalFile localFile = null;
        int n = 0;
        while ((file = new File(this._root, I18n.tr("New Folder") + (n == 0 ? "" : " " + n))).exists()) {
            ++n;
        }
        try {
            file.mkdir();
            localFile = new LocalFile(file);
            localFile.setOnOpenListener(this._myOnOpenListener);
            this._files.add(localFile);
            int n2 = this._files.size() - 1;
            this.fireIntervalAdded(this, n2, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localFile;
    }

    public void sortBy(int n) {
        this._sortCriteria = n;
        this.refresh();
    }

    protected void fireOnRoot(File file) {
        if (this._listener != null) {
            this._listener.onRoot(this, file);
        }
    }

    private List<LocalFile> getChildren(File file) {
        if (file == null || !file.isDirectory()) {
            return new ArrayList<LocalFile>();
        }
        ArrayList<LocalFile> arrayList = new ArrayList<LocalFile>();
        for (File file2 : file.listFiles()) {
            if (file2.isHidden()) continue;
            LocalFile localFile = new LocalFile(file2);
            localFile.setOnOpenListener(this._myOnOpenListener);
            arrayList.add(localFile);
        }
        return arrayList;
    }

    private int compareByKind(File file, File file2) {
        String string;
        if (file.isDirectory() && file2.isDirectory()) {
            return file.getName().compareTo(file2.getName());
        }
        if (file.isDirectory()) {
            return -1;
        }
        if (file2.isDirectory()) {
            return 1;
        }
        int n = file.getName().lastIndexOf(46);
        int n2 = file2.getName().lastIndexOf(46);
        if (n == -1 && n2 == -1) {
            return file.getName().compareTo(file2.getName());
        }
        if (n == -1) {
            return 1;
        }
        if (n2 == -1) {
            return -1;
        }
        String string2 = file.getName().substring(n).toLowerCase();
        if (!string2.equals(string = file2.getName().substring(n2).toLowerCase())) {
            return string2.compareTo(string);
        }
        return file.getName().compareTo(file2.getName());
    }

    private int compareByLength(File file, File file2, boolean bl) {
        if (file.isDirectory() && file2.isDirectory()) {
            return file.getName().compareTo(file2.getName());
        }
        if (file.isDirectory()) {
            return -1;
        }
        if (file2.isDirectory()) {
            return 1;
        }
        Long l = file.length();
        Long l2 = file2.length();
        return (bl ? 1 : -1) * l.compareTo(l2);
    }

    public void rename(int n, String string) {
        LocalFile localFile = (LocalFile)this.getElementAt(n);
        if (localFile != null) {
            localFile.rename(string);
            this.fireContentsChanged(this, n, n);
        }
    }

    private final class MyOnOpenListener
    implements LocalFile.OnOpenListener {
        private MyOnOpenListener() {
        }

        public void onOpen(LocalFile localFile) {
            LocalFileListModel.this.setRoot(localFile.getFile());
        }
    }

    public static interface OnRootListener {
        public void onRoot(LocalFileListModel var1, File var2);
    }
}

