/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.gnutella.gui.android.FileDescriptor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDescriptorListModel
extends AbstractListModel {
    private static final long serialVersionUID = 3826940677788298380L;
    private List<FileDescriptor> _fileDescriptors = new ArrayList<FileDescriptor>();
    private List<FileDescriptor> _filterFileDescriptors = new ArrayList<FileDescriptor>();
    private String _filterText;

    public void clear() {
        this._filterText = null;
        int n = this._filterFileDescriptors.size() - 1;
        this._fileDescriptors.clear();
        this._filterFileDescriptors.clear();
        if (n >= 0) {
            this.fireIntervalRemoved(this, 0, n);
        }
    }

    public void addAll(List<FileDescriptor> list) {
        this._fileDescriptors.addAll(list);
        this.refilter();
    }

    public void update(FileDescriptor fileDescriptor) {
        int n = this._filterFileDescriptors.indexOf(fileDescriptor);
        this.fireContentsChanged(this, n, n);
    }

    public void filter(String string) {
        this._filterText = string;
        this.refilter();
    }

    @Override
    public int getSize() {
        return this._filterFileDescriptors.size();
    }

    @Override
    public Object getElementAt(int n) {
        if (n >= 0 && n < this._filterFileDescriptors.size()) {
            return this._filterFileDescriptors.get(n);
        }
        return null;
    }

    private void refilter() {
        if (Thread.interrupted()) {
            return;
        }
        this._filterFileDescriptors.clear();
        if (this._filterText == null || this._filterText.trim().length() == 0) {
            if (Thread.interrupted()) {
                return;
            }
            this._filterFileDescriptors.addAll(this._fileDescriptors);
        } else {
            String string = this._filterText.trim().toLowerCase();
            for (int i = 0; i < this._fileDescriptors.size(); ++i) {
                String[] stringArray;
                if (Thread.interrupted()) {
                    return;
                }
                FileDescriptor fileDescriptor = this._fileDescriptors.get(i);
                StringBuilder stringBuilder = new StringBuilder();
                if (fileDescriptor.title != null) {
                    stringBuilder.append(fileDescriptor.title.toLowerCase() + " ");
                }
                if (fileDescriptor.artist != null) {
                    stringBuilder.append(fileDescriptor.artist.toLowerCase() + " ");
                }
                if (fileDescriptor.album != null) {
                    stringBuilder.append(fileDescriptor.artist.toLowerCase() + " ");
                }
                if (fileDescriptor.fileName != null) {
                    stringBuilder.append(fileDescriptor.fileName.toLowerCase());
                }
                boolean bl = true;
                for (String string2 : stringArray = string.split(" ")) {
                    if (stringBuilder.indexOf(string2) != -1) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                this._filterFileDescriptors.add(fileDescriptor);
            }
        }
        if (Thread.interrupted()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileDescriptorListModel.this.fireContentsChanged(this, 0, FileDescriptorListModel.this.getSize());
            }
        });
    }

    private boolean pseudoMatch(String string, String string2) {
        if (Thread.interrupted()) {
            return false;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        String[] stringArray = string2.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            if (Thread.interrupted()) {
                return false;
            }
            if (!string.contains(stringArray[i])) continue;
            return true;
        }
        return false;
    }
}

