/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.ImageCache;
import com.frostwire.gnutella.gui.android.Device;
import com.frostwire.gnutella.gui.android.DeviceListTransferHandler;
import com.frostwire.gnutella.gui.android.Finger;
import com.frostwire.gnutella.gui.android.UITool;
import com.limegroup.gnutella.gui.I18n;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JRadioButton;

public class DeviceButton
extends JRadioButton {
    private static final long serialVersionUID = 4608372510091566914L;
    private static final String IMAGES_URL = "http://static.frostwire.com/images/devices/";
    private static final Color FILL_COLOR = new Color(141, 178, 237, 180);
    private static final Color INNER_BORDER_COLOR = new Color(152, 191, 255, 180);
    private static final Color OUTER_BORDER_COLOR = new Color(81, 102, 136, 180);
    private ImageIcon _image;
    private ImageIcon _imageAuthorized;
    private ImageIcon _imagePressed;
    private ImageIcon _imagePressedAuthorized;
    private Device _device;

    public DeviceButton(Device device) {
        this._device = device;
        this.loadImage(this.getImageName());
        this.setupUI();
    }

    public Device getDevice() {
        return this._device;
    }

    public void refresh() {
        this.setTooltip();
        this.setImage();
    }

    protected void setupUI() {
        this.setBorder(null);
        this.setFocusable(false);
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
        Dimension dimension = new Dimension(100, 130);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setForeground(Color.WHITE);
        this.setTooltip();
        this.setImage();
        this.setText(" " + this._device.getName() + " ");
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (DeviceButton.this.isSelected()) {
                    DeviceButton.this.setForeground(Color.BLACK);
                } else {
                    DeviceButton.this.setForeground(Color.WHITE);
                }
            }
        });
        this.setTransferHandler(new DeviceListTransferHandler());
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.isSelected()) {
            graphics.setColor(FILL_COLOR);
            graphics.fillRoundRect(0, 0, n, n2 - 1, 5, 5);
            graphics.setColor(INNER_BORDER_COLOR);
            graphics.drawRoundRect(1, 1, n - 3, n2 - 3, 5, 5);
            graphics.setColor(OUTER_BORDER_COLOR);
            graphics.drawRoundRect(0, 0, n - 1, n2 - 1, 5, 5);
        }
        super.paintComponent(graphics);
    }

    private void setTooltip() {
        this.setToolTipText(I18n.tr("Connected") + (this._device.isTokenAuthorized() ? I18n.tr(" and authorized") : ""));
    }

    private void setImage() {
        if (this._device.isTokenAuthorized()) {
            this.setIcon(this._imageAuthorized);
            this.setPressedIcon(this._imagePressedAuthorized);
        } else {
            this.setIcon(this._image);
            this.setPressedIcon(this._imagePressed);
        }
    }

    private BufferedImage loadDefaultImage() {
        return new UITool().loadImage("generic_device");
    }

    private void loadImage(String string) {
        try {
            URL uRL = new URL(IMAGES_URL + this._device.getFinger().deviceManufacturer.toLowerCase() + "/" + string);
            BufferedImage bufferedImage = ImageCache.getInstance().getImage(uRL, new ImageCache.OnLoadedListener(){

                public void onLoaded(URL uRL, BufferedImage bufferedImage, boolean bl) {
                    DeviceButton.this.buildImages(bufferedImage);
                    DeviceButton.this.setImage();
                }
            });
            if (bufferedImage == null) {
                bufferedImage = this.loadDefaultImage();
                this.buildImages(bufferedImage);
                this.setImage();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void buildImages(BufferedImage bufferedImage) {
        this._image = new ImageIcon(this.buildImage(bufferedImage, false, false));
        this._imageAuthorized = new ImageIcon(this.buildImage(bufferedImage, false, true));
        this._imagePressed = new ImageIcon(this.buildImage(bufferedImage, true, false));
        this._imagePressedAuthorized = new ImageIcon(this.buildImage(bufferedImage, true, true));
    }

    private BufferedImage buildImage(BufferedImage bufferedImage, boolean bl, boolean bl2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        if (bl) {
            graphics2D.setColor(Color.BLUE);
            graphics2D.setComposite(AlphaComposite.getInstance(6, 0.7f));
            graphics2D.fillRect(0, 0, n, n2);
        }
        if (bl2) {
            BufferedImage bufferedImage3 = new UITool().loadImage("phone_authorized");
            graphics2D.drawImage((Image)bufferedImage3, 60, 10, null);
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    private String getImageName() {
        Finger finger = this._device.getFinger();
        String string = finger.deviceManufacturer + "_" + finger.deviceName + "_" + finger.deviceProduct + "_" + finger.deviceModel;
        string = string.replace('.', '_').replace(' ', '_');
        return string.toLowerCase() + ".png";
    }
}

