/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.HttpFetcher;
import com.frostwire.gnutella.gui.android.FileDescriptor;
import com.frostwire.gnutella.gui.android.FileDescriptorList;
import com.frostwire.gnutella.gui.android.Finger;
import com.frostwire.gnutella.gui.android.ProgressFileEntity;
import com.frostwire.json.JsonEngine;
import com.limegroup.gnutella.util.EncodingUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Device {
    public static int ACTION_BROWSE = 0;
    public static int ACTION_DOWNLOAD = 1;
    public static int ACTION_UPLOAD = 2;
    private static JsonEngine JSON_ENGINE = new JsonEngine();
    private InetAddress _address;
    private int _port;
    private Finger _finger;
    private String _token;
    private boolean _tokenAuthorized;
    private OnActionFailedListener _listener;
    private long _timeout;

    public Device(InetAddress inetAddress, int n, Finger finger) {
        this._address = inetAddress;
        this._port = n;
        this._finger = finger;
        this._token = UUID.randomUUID().toString();
    }

    public InetAddress getAddress() {
        return this._address;
    }

    public void setAddress(InetAddress inetAddress) {
        this._address = inetAddress;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int n) {
        this._port = n;
    }

    public Finger getFinger() {
        return this._finger;
    }

    public void setFinger(Finger finger) {
        this._finger = finger;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long l) {
        this._timeout = l;
    }

    public String getName() {
        return this._finger.nickname;
    }

    public String getKey() {
        return this._address.getHostAddress() + ":" + this._port;
    }

    public int getTotalShared() {
        return this._finger.numSharedApplicationFiles + this._finger.numSharedDocumentFiles + this._finger.numSharedPictureFiles + this._finger.numSharedVideoFiles + this._finger.numSharedRingtoneFiles + this._finger.numSharedAudioFiles;
    }

    public boolean isTokenAuthorized() {
        return this._tokenAuthorized;
    }

    public void setTokenAuthorized(boolean bl) {
        this._tokenAuthorized = bl;
    }

    public OnActionFailedListener getOnActionFailedListener() {
        return this._listener;
    }

    public void setOnActionFailedListener(OnActionFailedListener onActionFailedListener) {
        this._listener = onActionFailedListener;
    }

    public List<FileDescriptor> browse(int n) {
        try {
            URI uRI = new URI("http://" + this._address.getHostAddress() + ":" + this._port + "/browse?type=" + n);
            HttpFetcher httpFetcher = new HttpFetcher(uRI);
            byte[] byArray = (byte[])httpFetcher.fetch(true)[0];
            if (byArray == null) {
                this.notifyOnActionFailed(ACTION_BROWSE, null);
                return new ArrayList<FileDescriptor>();
            }
            this.setTimeout(System.currentTimeMillis());
            String string = new String(byArray);
            FileDescriptorList fileDescriptorList = JSON_ENGINE.toObject(string, FileDescriptorList.class);
            return fileDescriptorList.files;
        }
        catch (Exception exception) {
            this.notifyOnActionFailed(ACTION_BROWSE, exception);
            return new ArrayList<FileDescriptor>();
        }
    }

    public URL getDownloadURL(int n, int n2) {
        try {
            return new URL("http://" + this._address.getHostAddress() + ":" + this._port + "/download?type=" + n + "&id=" + n2);
        }
        catch (Exception exception) {
            this.notifyOnActionFailed(ACTION_DOWNLOAD, exception);
            return null;
        }
    }

    public byte[] download(int n, int n2) {
        try {
            URI uRI = this.getDownloadURL(n, n2).toURI();
            HttpFetcher httpFetcher = new HttpFetcher(uRI);
            byte[] byArray = httpFetcher.fetch();
            if (byArray == null) {
                this.notifyOnActionFailed(ACTION_DOWNLOAD, null);
                return null;
            }
            this.setTimeout(System.currentTimeMillis());
            return byArray;
        }
        catch (Exception exception) {
            this.notifyOnActionFailed(ACTION_DOWNLOAD, exception);
            return null;
        }
    }

    public void upload(int n, File file, ProgressFileEntity.ProgressFileEntityListener progressFileEntityListener) {
        URI uRI = null;
        try {
            uRI = new URI("http://" + this._address.getHostAddress() + ":" + this._port + "/authorize?token=" + EncodingUtils.encode(this._token) + "&from=" + EncodingUtils.encode(System.getProperty("user.name")));
            HttpFetcher httpFetcher = new HttpFetcher(uRI);
            progressFileEntityListener.onAuthorizationSent();
            byte[] byArray = httpFetcher.fetch();
            if (byArray == null || !Arrays.equals(this._token.getBytes(), byArray)) {
                throw new Exception("Not authorized or invalid token for upload to " + this._finger.nickname);
            }
            this.setTokenAuthorized(true);
            this.setTimeout(System.currentTimeMillis());
            uRI = new URI("http://" + this._address.getHostAddress() + ":" + this._port + "/upload?type=" + n + "&fileName=" + EncodingUtils.encode(file.getName()) + "&token=" + EncodingUtils.encode(this._token));
            httpFetcher = new HttpFetcher(uRI);
            ProgressFileEntity progressFileEntity = new ProgressFileEntity(file);
            progressFileEntity.setProgressFileEntityListener(progressFileEntityListener);
            httpFetcher.post(progressFileEntity);
            this.setTimeout(System.currentTimeMillis());
        }
        catch (Exception exception) {
            this.notifyOnActionFailed(ACTION_UPLOAD, exception);
            throw new RuntimeException(exception);
        }
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Device)) {
            return false;
        }
        return this.hashCode() == ((Device)object).hashCode();
    }

    protected void notifyOnActionFailed(int n, Exception exception) {
        if (this._listener != null) {
            this._listener.onActionFailed(this, n, exception);
        }
    }

    public static interface OnActionFailedListener {
        public void onActionFailed(Device var1, int var2, Exception var3);
    }
}

