/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.gnutella.gui.android.Device;
import com.frostwire.gnutella.gui.android.LocalFile;
import com.frostwire.gnutella.gui.android.ProgressFileEntity;
import com.frostwire.gnutella.gui.android.Task;
import java.io.File;

public class CopyToDeviceTask
extends Task {
    private Device _device;
    private LocalFile[] _localFiles;
    private int _fileType;
    private int _currentIndex;
    private long _totalBytes;
    private long _totalWritten;
    private boolean _waitingForAuthorization;

    public CopyToDeviceTask(Device device, File[] fileArray, int n) {
        this(device, CopyToDeviceTask.filesToLocalFiles(fileArray), n);
    }

    private static LocalFile[] filesToLocalFiles(File[] fileArray) {
        LocalFile[] localFileArray = new LocalFile[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) continue;
            localFileArray[i] = new LocalFile(fileArray[i]);
        }
        return localFileArray;
    }

    public CopyToDeviceTask(Device device, LocalFile[] localFileArray, int n) {
        this._device = device;
        this._localFiles = localFileArray;
        this._fileType = n;
        this._currentIndex = -1;
    }

    public Device getDevice() {
        return this._device;
    }

    public int getFileType() {
        return this._fileType;
    }

    public int getCurrentIndex() {
        return this._currentIndex;
    }

    public int getTotalItems() {
        return this._localFiles.length;
    }

    public void run() {
        if (this.isCanceled()) {
            return;
        }
        try {
            this.setProgress(0);
            this._totalBytes = this.getTotalBytes();
            this._totalWritten = 0L;
            for (int i = 0; i < this._localFiles.length; ++i) {
                if (this.isCanceled()) {
                    return;
                }
                this._currentIndex = i;
                try {
                    File file = this._localFiles[i].getFile();
                    this._device.upload(this._localFiles[i].getFileType(), file, new ProgressFileEntity.ProgressFileEntityListener(){

                        public void onWrite(ProgressFileEntity progressFileEntity, int n) {
                            CopyToDeviceTask.this.setWaitingForAuthorization(false);
                            CopyToDeviceTask.this._totalWritten += n;
                            CopyToDeviceTask.this.setProgress((int)(CopyToDeviceTask.this._totalWritten * 100L / CopyToDeviceTask.this._totalBytes));
                        }

                        public boolean isCanceled() {
                            return CopyToDeviceTask.this.isCanceled();
                        }

                        public void onAuthorizationSent() {
                            CopyToDeviceTask.this.setWaitingForAuthorization(true);
                        }
                    });
                    continue;
                }
                catch (Exception exception) {
                    this.fail(exception);
                    return;
                }
            }
            this.setProgress(100);
        }
        catch (Exception exception) {
            this.fail(exception);
        }
    }

    protected void setWaitingForAuthorization(boolean bl) {
        this._waitingForAuthorization = bl;
    }

    public boolean isWaitingForAuthorization() {
        return this._waitingForAuthorization;
    }

    private long getTotalBytes() {
        long l = 0L;
        for (LocalFile localFile : this._localFiles) {
            l += localFile.getFile().length();
        }
        return l;
    }
}

