/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.gnutella.gui.android.AndroidMediator;
import com.frostwire.gnutella.gui.android.Device;
import com.frostwire.gnutella.gui.android.FileDescriptor;
import com.frostwire.gnutella.gui.android.Task;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class CopyToDesktopTask
extends Task {
    private Device _device;
    private File _path;
    private FileDescriptor[] _fileDescriptors;
    private int _fileType;
    private int _currentIndex;

    public CopyToDesktopTask(Device device, File file, FileDescriptor[] fileDescriptorArray, int n) {
        this._device = device;
        this._path = file;
        this._fileDescriptors = fileDescriptorArray;
        this._fileType = n;
        this._currentIndex = -1;
    }

    public Device getDevice() {
        return this._device;
    }

    public File getPath() {
        return this._path;
    }

    public int getFileType() {
        return this._fileType;
    }

    public int getCurrentIndex() {
        return this._currentIndex;
    }

    public int getTotalItems() {
        return this._fileDescriptors.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.isCanceled()) {
            return;
        }
        try {
            this.setProgress(0);
            long l = this.getTotalBytes();
            long l2 = 0L;
            for (int i = 0; i < this._fileDescriptors.length; ++i) {
                if (this.isCanceled()) {
                    return;
                }
                this._currentIndex = i;
                FileDescriptor fileDescriptor = this._fileDescriptors[i];
                URL uRL = this._device.getDownloadURL(fileDescriptor.fileType, fileDescriptor.id);
                InputStream inputStream = null;
                FileOutputStream fileOutputStream = null;
                try {
                    inputStream = uRL.openStream();
                    File file = new File(this._path, fileDescriptor.fileName);
                    fileOutputStream = new FileOutputStream(file);
                    byte[] byArray = new byte[4096];
                    int n = 0;
                    while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                        if (this.isCanceled()) {
                            this.close(fileOutputStream);
                            this.close(inputStream);
                            return;
                        }
                        fileOutputStream.write(byArray, 0, n);
                        this.setProgress((int)((l2 += (long)n) * 100L / l));
                    }
                    this.close(fileOutputStream);
                }
                catch (IOException iOException) {
                    this.fail(iOException);
                    return;
                }
                finally {
                    this.close(fileOutputStream);
                    this.close(inputStream);
                }
                this.close(inputStream);
            }
            this.setProgress(100);
            AndroidMediator.instance().getDesktopExplorer().refresh();
        }
        catch (Exception exception) {
            this.fail(exception);
        }
    }

    private long getTotalBytes() {
        long l = 0L;
        for (FileDescriptor fileDescriptor : this._fileDescriptors) {
            l += fileDescriptor.fileSize;
        }
        return l;
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

