/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.gnutella.gui.android.AndroidMediator;
import com.frostwire.gnutella.gui.android.Device;
import com.frostwire.gnutella.gui.android.FileDescriptor;
import com.frostwire.gnutella.gui.android.FileDescriptorListModel;
import com.frostwire.gnutella.gui.android.Task;
import java.util.List;
import javax.swing.SwingUtilities;

public class BrowseTask
extends Task {
    private Device _device;
    private FileDescriptorListModel _model;
    private int _type;

    public BrowseTask(Device device, FileDescriptorListModel fileDescriptorListModel, int n) {
        this._device = device;
        this._model = fileDescriptorListModel;
        this._type = n;
    }

    public Device getDevice() {
        return this._device;
    }

    public FileDescriptorListModel getModel() {
        return this._model;
    }

    public int getType() {
        return this._type;
    }

    public void run() {
        if (this.isCanceled()) {
            return;
        }
        try {
            final List<FileDescriptor> list = this._device.browse(this._type);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        if (AndroidMediator.instance().getDeviceExplorer().getSelectedFileType() == BrowseTask.this._type) {
                            BrowseTask.this._model.clear();
                            BrowseTask.this._model.addAll(list);
                        }
                    }
                    catch (Exception exception) {
                        BrowseTask.this.fail(exception);
                    }
                }
            });
            this.setProgress(100);
        }
        catch (Exception exception) {
            this.fail(exception);
        }
    }

    public boolean enqueue() {
        return false;
    }
}

