/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JRadioButton;

public class BrowseFileTypeButton
extends JRadioButton {
    private static final long serialVersionUID = 3261658194515096352L;
    private Icon _icon;
    private Icon _pressedIcon;
    private Icon _selectedIcon;
    private String _imageText;

    public BrowseFileTypeButton() {
        this.setupUI();
    }

    public void setIcon(Icon icon) {
        super.setIcon(icon);
        this._icon = icon;
    }

    public void setPressedIcon(Icon icon) {
        super.setPressedIcon(icon);
        this._pressedIcon = icon;
    }

    public void setSelectedIcon(Icon icon) {
        super.setSelectedIcon(icon);
        this._selectedIcon = icon;
    }

    public String getText() {
        return null;
    }

    public void setText(String string) {
        if (this._imageText != null && this._imageText.equals(string)) {
            return;
        }
        this._imageText = string;
        BufferedImage bufferedImage = this.buildTextImage(string);
        this.setCompositeIcon(bufferedImage);
        this.setCompositePressedIcon(bufferedImage);
        this.setCompositeSelectedIcon(bufferedImage);
    }

    protected void setupUI() {
        this.setBorder(null);
        this.setBackground(null);
        this.setFocusable(false);
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
    }

    private void setCompositeIcon(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = null;
        Icon icon = this._icon;
        if (icon != null && icon instanceof ImageIcon && ((ImageIcon)icon).getImage() instanceof BufferedImage) {
            bufferedImage2 = (BufferedImage)((ImageIcon)icon).getImage();
            bufferedImage2 = this.joinImages(bufferedImage2, bufferedImage);
            super.setIcon(new ImageIcon(bufferedImage2));
        }
    }

    private void setCompositePressedIcon(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = null;
        Icon icon = this._pressedIcon;
        if (icon != null && icon instanceof ImageIcon && ((ImageIcon)icon).getImage() instanceof BufferedImage) {
            bufferedImage2 = (BufferedImage)((ImageIcon)icon).getImage();
            bufferedImage2 = this.joinImages(bufferedImage2, bufferedImage);
            super.setPressedIcon(new ImageIcon(bufferedImage2));
        }
    }

    private void setCompositeSelectedIcon(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = null;
        Icon icon = this._selectedIcon;
        if (icon != null && icon instanceof ImageIcon && ((ImageIcon)icon).getImage() instanceof BufferedImage) {
            bufferedImage2 = (BufferedImage)((ImageIcon)icon).getImage();
            bufferedImage2 = this.joinImages(bufferedImage2, bufferedImage);
            super.setSelectedIcon(new ImageIcon(bufferedImage2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage buildTextImage(String string) {
        Font font = this.getFont();
        Graphics graphics = null;
        Graphics graphics2 = null;
        Graphics graphics3 = null;
        BufferedImage bufferedImage = null;
        try {
            BufferedImage bufferedImage2 = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            graphics = bufferedImage2.createGraphics();
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n = fontMetrics.stringWidth(string) + 20;
            int n2 = fontMetrics.getHeight();
            BufferedImage bufferedImage3 = new BufferedImage(n, n2, 2);
            graphics2 = bufferedImage3.createGraphics();
            ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            TextLayout textLayout = new TextLayout(string, font, ((Graphics2D)graphics2).getFontRenderContext());
            ((Graphics2D)graphics2).setPaint(Color.BLACK);
            textLayout.draw((Graphics2D)graphics2, 11.0f, 14.0f);
            graphics2.dispose();
            float f = 0.11111111f;
            float[] fArray = new float[]{f, f, f, f, f, f, f, f, f};
            ConvolveOp convolveOp = new ConvolveOp(new Kernel(3, 3, fArray), 1, null);
            BufferedImage bufferedImage4 = convolveOp.filter(bufferedImage3, null);
            graphics3 = bufferedImage4.createGraphics();
            ((Graphics2D)graphics3).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)graphics3).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            ((Graphics2D)graphics3).setPaint(Color.WHITE);
            textLayout.draw((Graphics2D)graphics3, 10.0f, 13.0f);
            bufferedImage = bufferedImage4;
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
            if (graphics != null) {
                graphics2.dispose();
            }
            if (graphics != null) {
                graphics3.dispose();
            }
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage joinImages(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage2.getWidth();
        int n4 = bufferedImage2.getHeight();
        int n5 = n >= n3 ? n : n3;
        int n6 = n2 + n4;
        BufferedImage bufferedImage3 = new BufferedImage(n5, n6, 2);
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        try {
            graphics2D.drawImage(bufferedImage, (n5 - n) / 2, 0, n, n2, null);
            graphics2D.drawImage(bufferedImage2, (n5 - n3) / 2, n2, n3, n4, null);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        return bufferedImage3;
    }
}

