/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui;

import com.frostwire.HttpFetcher;
import com.frostwire.ImageCache;
import com.frostwire.gnutella.gui.FadeSlideTransition;
import com.frostwire.gnutella.gui.Slide;
import com.frostwire.gnutella.gui.SlideList;
import com.frostwire.json.JsonEngine;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlideshowPanel
extends JPanel {
    private static final long serialVersionUID = -1964953870003850981L;
    private List<Slide> _slides;
    private boolean _randomStart;
    private int _currentSlideIndex;
    private BufferedImage _currentImage;
    private BufferedImage _lastImage;
    private boolean _loadingNextImage;
    private FadeSlideTransition _transition;
    private long _transitionTime;
    private boolean _started;
    private long _lastTimeSlideLoaded;
    private Timer _timer;

    public SlideshowPanel(List<Slide> list, boolean bl) {
        this.setup(list, false);
    }

    public SlideshowPanel(String string) {
        try {
            HttpFetcher httpFetcher = new HttpFetcher(new URI(string));
            byte[] byArray = httpFetcher.fetch();
            if (byArray != null) {
                SlideList slideList = new JsonEngine().toObject(new String(byArray), SlideList.class);
                this.setup(slideList.slides, slideList.randomStart);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (!this._started) {
            this.startAnimation();
        }
        if (this._transition != null) {
            this._transition.paint(graphics);
            if (!this._transition.isRunning()) {
                this._transition = null;
            }
        }
        if (this._transition == null && this._currentImage != null) {
            graphics.drawImage(this._currentImage, 0, 0, null);
        }
    }

    private void setup(List<Slide> list, boolean bl) {
        this._slides = list;
        this._randomStart = bl;
        this._currentSlideIndex = -1;
        this.setCursor(new Cursor(12));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    Slide slide = (Slide)SlideshowPanel.this._slides.get(SlideshowPanel.this._currentSlideIndex);
                    if (slide.url != null) {
                        GUIMediator.openURL(slide.url);
                    }
                    if (slide.torrent != null) {
                        if (slide.torrent.toLowerCase().startsWith("http")) {
                            GUIMediator.instance().openTorrentURI(new URI(slide.torrent));
                        } else if (slide.torrent.toLowerCase().startsWith("magnet:?")) {
                            GUIMediator.instance().openTorrentMagnet(slide.torrent);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void startAnimation() {
        if (this._slides == null || this._slides.size() == 0) {
            return;
        }
        this._started = true;
        this._lastTimeSlideLoaded = 0L;
        if (this._slides.size() == 1) {
            try {
                ImageCache.getInstance().getImage(new URL(this._slides.get((int)0).imageSrc), new ImageCache.OnLoadedListener(){

                    public void onLoaded(URL uRL, BufferedImage bufferedImage, boolean bl) {
                        SlideshowPanel.this._currentImage = bufferedImage;
                        SlideshowPanel.this.repaint();
                    }
                });
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            this._timer = new Timer();
            this._timer.schedule(new TimerTask(){

                public void run() {
                    SlideshowPanel.this.tryMoveNext();
                }
            }, 0L, 200L);
        }
    }

    private void tryMoveNext() {
        if (this._loadingNextImage) {
            return;
        }
        Slide slide = null;
        if (this._currentSlideIndex == -1) {
            this._currentSlideIndex = this._randomStart ? new Random(System.currentTimeMillis()).nextInt(this._slides.size()) : 0;
            try {
                ImageCache.getInstance().getImage(new URL(this._slides.get((int)this._currentSlideIndex).imageSrc), new ImageCache.OnLoadedListener(){

                    public void onLoaded(URL uRL, BufferedImage bufferedImage, boolean bl) {
                        SlideshowPanel.this._currentImage = bufferedImage;
                        SlideshowPanel.this._lastImage = SlideshowPanel.this._currentImage;
                        SlideshowPanel.this._loadingNextImage = false;
                        SlideshowPanel.this.repaint();
                        SlideshowPanel.this._lastTimeSlideLoaded = System.currentTimeMillis();
                    }
                });
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            slide = this._slides.get(this._currentSlideIndex);
            if (slide.duration + this._lastTimeSlideLoaded + this._transitionTime < System.currentTimeMillis()) {
                this._currentSlideIndex = (this._currentSlideIndex + 1) % this._slides.size();
                slide = this._slides.get(this._currentSlideIndex);
            } else {
                slide = null;
            }
        }
        if (slide != null) {
            this._loadingNextImage = true;
            try {
                ImageCache.getInstance().getImage(new URL(slide.imageSrc), new ImageCache.OnLoadedListener(){

                    public void onLoaded(URL uRL, BufferedImage bufferedImage, boolean bl) {
                        SlideshowPanel.this._currentImage = SlideshowPanel.this.prepareImage(bufferedImage);
                        if (SlideshowPanel.this._lastImage != null && SlideshowPanel.this._currentImage != null) {
                            SlideshowPanel.this._transition = new FadeSlideTransition(SlideshowPanel.this, SlideshowPanel.this._lastImage, SlideshowPanel.this._currentImage);
                            SlideshowPanel.this._transitionTime = SlideshowPanel.this._transition.getEstimatedDuration();
                            SlideshowPanel.this._transition.start();
                        }
                        SlideshowPanel.this._lastImage = SlideshowPanel.this._currentImage;
                        SlideshowPanel.this._loadingNextImage = false;
                        SlideshowPanel.this._lastTimeSlideLoaded = System.currentTimeMillis();
                        SlideshowPanel.this.repaint();
                    }
                });
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage prepareImage(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D graphics2D = null;
        try {
            graphics2D = bufferedImage2.createGraphics();
            int n = 0;
            int n2 = 0;
            if (bufferedImage.getHeight() < this.getHeight()) {
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                n2 = (this.getHeight() - bufferedImage.getHeight()) / 2;
            }
            if (bufferedImage.getWidth() < this.getWidth()) {
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                n = (this.getWidth() - bufferedImage.getWidth()) / 2;
            }
            graphics2D.drawImage((Image)bufferedImage, n, n2, null);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        return bufferedImage2;
    }
}

