/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire;

import com.frostwire.CoreFrostWireUtils;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.GraphicsEnvironment;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Comparator;
import java.util.HashMap;
import org.jdesktop.jdic.desktop.Desktop;
import org.limewire.collection.SortedList;
import org.limewire.io.IOUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public final class GuiFrostWireUtils
extends CoreFrostWireUtils {
    private static final boolean canShareTorrentMetaFiles() {
        if (!SharingSettings.DEFAULT_SHARED_TORRENTS_DIR.exists()) {
            SharingSettings.DEFAULT_SHARED_TORRENTS_DIR.mkdir();
        }
        return SharingSettings.SHARE_TORRENT_META_FILES.getValue() && SharingSettings.DEFAULT_SHARED_TORRENTS_DIR.exists() && SharingSettings.DEFAULT_SHARED_TORRENTS_DIR.isDirectory() && SharingSettings.DEFAULT_SHARED_TORRENTS_DIR.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static final void shareTorrent(BTMetaInfo bTMetaInfo, byte[] byArray) {
        if (!GuiFrostWireUtils.canShareTorrentMetaFiles()) {
            return;
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            File file = new File(SharingSettings.DEFAULT_SHARED_TORRENTS_DIR, bTMetaInfo.getName().concat(".torrent"));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            GuiFrostWireUtils.verifySharedTorrentFolderCorrecteness();
        }
        catch (Exception exception) {
            IOUtils.close(bufferedOutputStream);
            catch (Throwable throwable) {
                IOUtils.close(bufferedOutputStream);
                throw throwable;
            }
        }
        IOUtils.close(bufferedOutputStream);
    }

    public static final void shareTorrent(File file) {
        if (!GuiFrostWireUtils.canShareTorrentMetaFiles()) {
            return;
        }
        File file2 = new File(SharingSettings.DEFAULT_SHARED_TORRENTS_DIR, file.getName());
        FileUtils.copy(file, file2);
        GuiFrostWireUtils.verifySharedTorrentFolderCorrecteness();
    }

    public static final void verifySharedTorrentFolderCorrecteness() {
        File[] fileArray;
        GuiFrostWireUtils.canShareTorrentMetaFiles();
        if (SharingSettings.SHARE_TORRENT_META_FILES.getValue()) {
            GuiCoreMediator.getFileManager().addSharedFolder(SharingSettings.DEFAULT_SHARED_TORRENTS_DIR);
        }
        if ((fileArray = SharingSettings.DEFAULT_SHARED_TORRENTS_DIR.listFiles()) != null && fileArray.length > 0) {
            for (File file : fileArray) {
                if (SharingSettings.SHARE_TORRENT_META_FILES.getValue()) {
                    GuiCoreMediator.getFileManager().addFileAlways(file);
                    continue;
                }
                GuiCoreMediator.getFileManager().stopSharingFile(file);
            }
        }
    }

    public static final String getFontFamily(String string, String ... stringArray) {
        String[] stringArray2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        final HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i].toLowerCase(), i);
        }
        SortedList<String> sortedList = new SortedList<String>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string.equals(string2)) {
                    return 0;
                }
                return new Integer((Integer)hashMap.get(string.toLowerCase())).compareTo((Integer)hashMap.get(string2.toLowerCase()));
            }
        });
        for (String string2 : stringArray2) {
            if (!hashMap.containsKey(string2.toLowerCase())) continue;
            sortedList.add(string2);
        }
        if (sortedList.size() > 0) {
            return (String)sortedList.get(0);
        }
        return string;
    }

    public static void launchFile(File file) {
        try {
            boolean bl = CoreFrostWireUtils.isJavaMinorVersionEqualOrGreaterThan("1.6");
            if (bl) {
                java.awt.Desktop.getDesktop().open(file);
            } else if (!OSUtils.isMacOSX()) {
                Desktop.open(file);
            } else {
                GUIMediator.launchFile(file);
            }
        }
        catch (Exception exception) {
            GUIMediator.launchFile(file);
        }
    }
}

