//  $Id: ice_block.hpp 2986 2007-08-17 16:20:09Z grumbel $
//
//  Pingus - A free Lemmings clone
//  Copyright (C) 2000 Ingo Ruhnke <grumbel@gmx.de>
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef HEADER_PINGUS_WORLDOBJS_ICE_BLOCK_HXX
#define HEADER_PINGUS_WORLDOBJS_ICE_BLOCK_HXX

#include "../worldobj.hpp"

namespace WorldObjsData {
class IceBlockData;
}

namespace WorldObjs {

class IceBlock : public WorldObj
{
private:
  /// The upper/left position  of the iceblock's
  Vector3f pos;

  /** The number of iceblocks, only complete blocks are supported */
  int width;

  float thickness;
  bool  is_finished;
  int   last_contact;
  Sprite block_sur;
  CollisionMask block_sur_cmap;

public:
  IceBlock(const FileReader& reader);

  float get_z_pos () const { return pos.z; }
  void on_startup ();
  void draw (SceneContext& gc);
  void update ();

private:
  IceBlock (const IceBlock&);
  IceBlock& operator= (const IceBlock&);
};

} // namespace WorldObjs

#endif

/* EOF */
