/*
 *      Header-template utility for different PortalPlayer-based players.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: hdr_template.c 328 2007-02-10 17:50:11Z nyaochi $ */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/
#ifdef	HAVE_STRING_H
#include <string.h>
#endif/*HAVE_STRING_H*/

#include <os.h>
#include <stdio.h>
#include <stdlib.h>
#include <pmplib/ucs2char.h>

#include "pp1db.h"
#include "hdr_template.h"

int apply_template(hdr_t* hdr, const hdr_template_t* tmpl)
{
	uint32_t i;

	memset(hdr, 0, sizeof(*hdr));

	hdr->unknown1 = tmpl->unknown1;
	hdr->unknown2 = tmpl->unknown2;
	mbstoucs2(hdr->pathname_dat, PP1DB_PATHLENGTH, tmpl->pathname_dat, strlen(tmpl->pathname_dat));
	hdr->unknown3 = tmpl->unknown3;
	mbstoucs2(hdr->pathname_hdr, PP1DB_PATHLENGTH, tmpl->pathname_hdr, strlen(tmpl->pathname_hdr));
	hdr->unknown4 = tmpl->unknown4;
	hdr->num_dat_entries = tmpl->num_dat_entries;
	hdr->num_dat_inactive_entries = tmpl->num_dat_inactive_entries;
	hdr->num_dat_fields = tmpl->num_dat_fields;
	hdr->fd = calloc(tmpl->param.max_fields, sizeof(field_descriptor_t));
	if (!hdr->fd) {
		goto error_exit;
	}
	for (i = 0;i < tmpl->param.max_fields;++i) {
		hdr->fd[i].id = tmpl->fd[i].id;
		hdr->fd[i].field_type = tmpl->fd[i].field_type;
		hdr->fd[i].max_length = tmpl->fd[i].max_length;
		hdr->fd[i].unknown4 = tmpl->fd[i].unknown4;
		hdr->fd[i].unknown5 = tmpl->fd[i].unknown5;
		hdr->fd[i].has_index = tmpl->fd[i].has_index;
		hdr->fd[i].unknown6 = tmpl->fd[i].unknown6;
		hdr->fd[i].unknown7 = tmpl->fd[i].unknown7;
		mbstoucs2(hdr->fd[i].index_pathname, PP1DB_PATHLENGTH, tmpl->fd[i].index_pathname, strlen(tmpl->fd[i].index_pathname));
	}
	hdr->max_dat_field_size = calloc(tmpl->param.max_fields, sizeof(uint32_t));
	if (!hdr->max_dat_field_size) {
		goto error_exit;
	}
	for (i = 0;i < tmpl->param.max_fields;++i) {
		hdr->max_dat_field_size[i] = tmpl->max_dat_field_size[i];
	}
	hdr->dat_field_offset = calloc(tmpl->param.max_entries, sizeof(uint16_t) * (tmpl->param.max_fields+1));
	if (!hdr->dat_field_offset) {
		goto error_exit;
	}
	hdr->dat_record_offset = calloc(tmpl->param.max_entries+1, sizeof(uint32_t));
	if (!hdr->dat_record_offset) {
		goto error_exit;
	}
	hdr->param = tmpl->param;
	return 0;

error_exit:
	free(hdr->max_dat_field_size);
	free(hdr->fd);
	memset(hdr, 0, sizeof(*hdr));
	return -1;
}
