/*
 *      Reader/writer for iRivNavi.iDB.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: irivnavi.h 328 2007-02-10 17:50:11Z nyaochi $ */

#ifndef	__IRIVNAVI_H__
#define	__IRIVNAVI_H__

/*
 * If symbol IRIVNAVI_USES_TIMESTAMP is defined, the library reserves
 * uint32_t (4 bytes) field at the end of each record (just after the
 * genre field). This field is our arbitrary extension to iRivNavi.iDB
 * structure to store timestamp values for faster database update. This
 * extension does not seem to affect the behavior of H100/300 players
 * as long as other informaton such as record offset and record size is
 * consistent (i.e., the size of each record is to be increased by 4
 * bytes).
 */
#define	IRIVNAVI_USES_TIMESTAMP		1

typedef struct {
	char *filename;
	char *title;
	char *artist;
	char *album;
	char *genre;
#ifdef	IRIVNAVI_USES_TIMESTAMP
	uint32_t timestamp;
#endif
} record_t;

typedef struct {
	uint8_t header0[0x20];
	uint8_t header1[0x20];
	uint8_t footer[0x20];
	uint32_t num_records;
	record_t* records;
	uint32_t* offsets;

	uint32_t size;	// The total size of the database stored in a file.
} irivnavi_t;

void record_init(record_t* record);
void record_finish(record_t* record);

void irivnavi_init(irivnavi_t* db);
void irivnavi_finish(irivnavi_t* db);
int irivnavi_init_records(irivnavi_t* db, uint32_t num_records);
void irivnavi_update(irivnavi_t* db);
size_t irivnavi_serialize(irivnavi_t* db, uint8_t* buffer, int is_storing);
void irivnavi_repr(irivnavi_t* db, FILE *fp, int level);

int playlist_write(
	const ucs2char_t *filename,
	ucs2char_t* const mediafiles[],
	int num_mediafiles,
	const ucs2char_t *path_to_root
	);

#endif/*__IRIVNAVI_H__*/
