/*
 *      Common routines for tag and audio information retrieval.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
 * http://www.gnu.org/copyleft/gpl.html .
 *
 */

/* $Id: pmp_posix.c 331 2007-02-10 18:39:35Z nyaochi $ */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/
#ifdef	HAVE_STDLIB_H
#include <stdlib.h>
#endif/*HAVE_STDLIB_H*/

#include <ltdl.h>

#include <os.h>
#include <pmplib/ucs2char.h>
#include <pmplib/filepath.h>
#include <pmplib/pmp.h>

struct tag_pmplib_t {
	uint32_t num_plugins;
	lt_dlhandle *plugins;
};

uint32_t pmplib_interlocked_increment(uint32_t* count)
{
	return ++(*count);
}

uint32_t pmplib_interlocked_decrement(uint32_t* count)
{
	return --(*count);
}

result_t pmplib_init(pmplib_t** ptr_pmplib)
{
	lt_dlhandle inst = 0;
	pmplib_t* pmplib = NULL;

	pmplib = (pmplib_t*)calloc(1, sizeof(pmplib_t));
	pmplib->num_plugins = 0;
	pmplib->plugins = NULL;

	lt_dlinit();
	lt_dlsetsearchpath(PMP_MODULES_DIR);

	inst = lt_dlopenext("portalplayer1");
	if (inst) {
		pmplib->num_plugins++;
		pmplib->plugins = (lt_dlhandle*)realloc(pmplib->plugins, sizeof(lt_dlhandle) * pmplib->num_plugins);
		pmplib->plugins[pmplib->num_plugins-1] = inst;
	} else {
		fprintf(stderr, "FAILED: portalplayer1 in %s\n", PMP_MODULES_DIR);
	}

	inst = lt_dlopenext("iriverplus2");
	if (inst) {
		pmplib->num_plugins++;
		pmplib->plugins = (lt_dlhandle*)realloc(pmplib->plugins, sizeof(lt_dlhandle) * pmplib->num_plugins);
		pmplib->plugins[pmplib->num_plugins-1] = inst;
	} else {
		fprintf(stderr, "FAILED: iriverplus2\n");
	}

	inst = lt_dlopenext("iriverplus3");
	if (inst) {
		pmplib->num_plugins++;
		pmplib->plugins = (lt_dlhandle*)realloc(pmplib->plugins, sizeof(lt_dlhandle) * pmplib->num_plugins);
		pmplib->plugins[pmplib->num_plugins-1] = inst;
	} else {
		fprintf(stderr, "FAILED: iriverplus3\n");
	}

	inst = lt_dlopenext("irivnavi");
	if (inst) {
		pmplib->num_plugins++;
		pmplib->plugins = (lt_dlhandle*)realloc(pmplib->plugins, sizeof(lt_dlhandle) * pmplib->num_plugins);
		pmplib->plugins[pmplib->num_plugins-1] = inst;
	} else {
		fprintf(stderr, "FAILED: irivnavi\n");
	}

	*ptr_pmplib = pmplib;
	return 0;
}

result_t pmplib_finish(pmplib_t* pmplib)
{
	uint32_t i;

	for (i = 0;i < pmplib->num_plugins;++i) {
		lt_dlclose(pmplib->plugins[i]);
	}
	free(pmplib->plugins);
	free(pmplib);
	return 0;
}

result_t pmplib_enumerate_devid(pmplib_t* pmplib, pmplib_enumerate_devid_callback_t callback, void *instance)
{
	uint32_t i;
	for (i = 0;i < pmplib->num_plugins;++i) {
		pmplib_enumerate_devid_t func = (pmplib_enumerate_devid_t)lt_dlsym(pmplib->plugins[i], "pmp_enumerate_devid");
		if (func) {
			func(callback, instance);
		}
	}
	return 0;
}

result_t pmplib_create(pmplib_t* pmplib, pmp_t** pmp, const ucs2char_t* path_to_device, const char *id)
{
	result_t ret = PMPERR_DEVICENOTFOUND;
	uint32_t i;

	for (i = 0;i < pmplib->num_plugins;++i) {
		pmplib_create_t func = (pmplib_create_t)lt_dlsym(pmplib->plugins[i], "pmp_create");
		if (func) {
			ret = func(pmp, path_to_device, id);
			if (ret != PMPERR_DEVICENOTFOUND) {
				return ret;
			}
		}
	}

	return ret;
}
