/*
 *      Playlist library.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Publi	c License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: playlist.h 328 2007-02-10 17:50:11Z nyaochi $ */

#ifndef	__PLAYLIST_H__
#define	__PLAYLIST_H__

#ifdef	PLAYLIST_EXPORTS
#define	PLAYLISTAPI	__declspec(dllexport)
#else
#define	PLAYLISTAPI
#endif

#include <pmplib/pmp.h>

#ifdef	__cplusplus
extern "C" {
#endif/*__cplusplus*/

enum {
	PLAYLIST_NONE = 0,
	PLAYLIST_JSPL = 1,
};

enum {
	PLCALLBACK_NONE,
	PLCALLBACK_JSPL_MESSAGE,
	PLCALLBACK_JSPL_ERROR,
	PLCALLBACK_JSPL_ERROR_POS,
	PLCALLBACK_JSPL_ERROR_LINE,
};

enum {
	PLAYLIST_SUCCESS = 0,
	PLAYLIST_E_FAIL = 0x80000000,
	PLAYLIST_E_OUTOFMEMORY,
	PLAYLIST_E_JSINITENGINE,
	PLAYLIST_E_JSINITMEDIA,
	PLAYLIST_E_JSEVALSCRIPT,
	PLAYLIST_E_JSMAINNOTFOUND,
	PLAYLIST_E_JSCALLMAIN,
	PLAYLIST_E_JSINVALIDARRAY,
	PLAYLIST_E_JSINVALIDCAST,
	PLAYLIST_E_JSINVALIDOBJECT,
	PLAYLIST_E_JSINVALIDTRACK,
};


typedef void (*playlist_callback_t)(void *instance, int level, ucs2char_t* message);

struct tag_playlist_entry {
	ucs2char_t filename[MAX_PATH];
	int valid;
	int order;
};
typedef struct tag_playlist_entry playlist_entry_t;

struct tag_playlist {
	ucs2char_t name[MAX_PATH];
	int num_entries;
	playlist_entry_t* entries;
};
typedef struct tag_playlist playlist_t;

struct tag_playlists {
	int num_playlists;
	playlist_t* playlists;
};
typedef struct tag_playlists playlists_t;

typedef struct {
	ucs2char_t path[MAX_PATH];
	ucs2char_t file[MAX_PATH];
} playlist_mediafile_t;

PLAYLISTAPI
void
playlist_init(
	playlists_t* pls
	);

PLAYLISTAPI
void
playlist_finish(
	playlists_t *pls
	);

PLAYLISTAPI
int
playlist_read(
	playlists_t* pls,
	const ucs2char_t* filename,
	const ucs2char_t* path_to_include,
	pmp_music_record_t* records,
	int num_records,
	playlist_callback_t callback,
	void *instance
	);

PLAYLISTAPI
int
playlist_add_playlist(
	playlists_t* pls,
	const ucs2char_t* name
	);

PLAYLISTAPI
int
playlist_find_playlist(
	playlists_t* pls,
	const ucs2char_t* name
	);

PLAYLISTAPI
int
playlist_append(
	playlist_t* pl,
	const ucs2char_t* filename,
	int userdata
	);

PLAYLISTAPI
int
playlist_is_supported(
	const ucs2char_t* filename,
	int flag
	);

PLAYLISTAPI
void
playlist_normalize_prepare(
	playlist_mediafile_t* mediafiles,
	int num_mediafiles
	);

PLAYLISTAPI
int
playlist_normalize(
	playlist_t* pl,
	const ucs2char_t* path_to_playlist,
	const ucs2char_t* path_to_root,
	playlist_mediafile_t* mediafiles,
	int num_mediafiles
	);

PLAYLISTAPI
void
playlist_shuffle(
	playlist_t* pl
	);

#ifdef	__cplusplus
}
#endif/*__cplusplus*/

#endif/*__PLAYLIST_H__*/
