.TH "depfinder" 1 "02/13/2011" "George Vlahavas"

.SH NAME
.P
depfinder \- a tool that finds dependencies of slackware packages

.SH SYNOPSIS
.P
\fBdepfinder\fR [\fIOPTIONS\fR] \fIPACKAGE\fR or \fIPACKAGING\-DIRECTORY\fR

.SH DESCRIPTION
.P
\fBdepfinder\fR is a tool that finds the dependencies of Slackware packages.
It examines binary files in the packages and the libraries they link to and
reports the packages these libraries belong to in a dependency list.
The dependencies are by default being output to a comma separated
list without version information, but there are options to output
dependencies with version information and to a file: a .dep file
with a comma separated list without version information, or a
\fIslack\-required\fR file that includes version information.

.P
\fBdepfinder\fR can check \fI.tgz\fR, \fI.tbz\fR, \fI.tlz\fR and \fI.txz\fR
packages for dependencies
but you can also point it to a packaging directory where you have the
package contents extracted.

.P
\fBdepfinder\fR uses \fBldd\fR for discovering dependencies, and finds
dependencies of binary files with it. Detecting python dependencies is
also  supported by use of the \fB\-p\fR switch.

.P
If a certain library is included in more than one packages, then all
packages that include it will be listed in one entry using an "or"
statement (which is expressed with the pipe symbol: "|"). For example a
dependency for a library that is included in both \fIopenssl\fR and
\fIopenssl\-solibs\fR packages will be output as:
\fIopenssl|openssl\-solibs\fR.

.P
You need to have all required dependencies for any package you run
\fBdepfinder\fR on installed in your system. That will of course always be
the case when you are building your own packages. In case there is a
library that is required by a package you run \fBdepfinder\fR on that is
missing from your system, \fBdepfinder\fR will report the missing library
and will not generate a dependency list.

.P
If a python module that is needed by a package is not present in the
system, a warning will be displayed instead of an error and the
dependency list will be generated. Consider these warnings as hints for
missing dependencies, optional or not. If your python application doesn't
work, it's probably because of one or more of those reported missing
modules. If your application seems to work fine, but you still get some
warnings, it might mean that your application might acquire some extra
functionality by installing some of the reported modules. And as the
python code parsing cannot be perfectly accurate, there might be some
false positives in these warnings. A line that only reads "import foo"
for example, that is inside a block quote in a python file. is going to be
parsed anyway and "foo" will be reported as a missing module, even
though it's inside a block quote and will never be executed by python.

.P
\fBdepfinder\fR also has support for running multiple jobs which makes it
a \fBlot\fR faster on PCs with multiple CPUs/cores.

.SH OPTIONS
.TP
\fB\-f\fR
Outputs dependencies to a file instead of stdout. By default it creates a
\&.dep file with a comma separated list of dependencies without version
information. See also \fB\-s\fR.

.TP
\fB\-s\fR
Outputs dependencies including version information. Dependencies will be
listed in the format following this example: "zlib >= 1.2.3\-i486\-2". If
combined with \fB\-f\fR, it creates a slack\-required file which can be
placed inside the package under the \fIinstall\fR directory.

.TP
\fB\-a\fR
Checks all files in the directory tree instead of following the FHS. If
\fB\-a\fR is not used then depfinder looks for binary files only under
\fI/sbin\fR ,\fI/usr/sbin\fR, \fI/usr/bin\fR, \fI/bin\fR, \fI/usr/libexec\fR and
\fI/usr/lib\fR, \fI/lib\fR or \fI/usr/lib64\fR, \fI/lib64\fR for 32\-bit and
64\-bit architectures respectively. If \fB\-a\fR is used, then depfinder
searches for files dynamically linking to libraries anywhere inside the
package. This option could be usefull if the installation scripts put
binaries in a non\-standard location.

.TP
\fB\-p\fR
Attempts to discover python dependencies. Using this switch, depfinder
searches for all files that can be recognized as python scripts.
All python files that are detected are parsed for modules that they
import and depfinder ultimately reports which packages these modules
belong to along with all other detected dependencies. The list of
reported python dependencies might not be final. Some python
packages might be reported as dependencies, while actually being
optional dependencies. This is because an \fIimport\fR command in python
might be executed after a conditional statement, or only after some
certain action is taken by the end user etc. For example, a python
module might only be providing extra functionality to an application and
it may be imported only after it has been established that it is
present in the system. If it isn't, it won't be imported at all, so the
application will work without it anyway, albeit with some missing
functionality perhaps. It's up to the packager to determine which of
the reported python dependencies are actually dependencies and which
ones should merely be suggested packages.

.TP
\fB\-j\fR \fIjobs\fR
Specifies the number of parallel depfinder jobs to run. depfinder will
finish considerably faster if this matches exactly the number of your
CPUs/cores (default number of jobs: 1)

= GENERAL OPTIONS =

.TP
\fB\-v\fR
Shows version information for depfinder and exits.

.TP
\fB\-h\fR
Prints a usage message briefly summarizing all command\-line options
and exits.

= WEBSITE =

http://depfinder.sourceforge.net/

= AUTHORS =

depfinder was written by George Vlahavas <vlahavas~at~gmail~dot~com>

= SEE ALSO =

\fBldd\fR(1)


.\" man code generated by txt2tags 2.5 (http://txt2tags.sf.net)
.\" cmdline: txt2tags depfinder.t2t

