#ifndef H_CDW_CDIO
#define H_CDW_CDIO

#include <stdbool.h>

#include <cdio/cdio.h>
#include <cdio/cd_types.h>
#include <cdio/iso9660.h>
#include "main.h"


/* how many blocks of data to read/write at a time */
#define CDW_CDIO_RW_N_SECTORS 20
#define CDW_CDIO_VOLUME_ID_LEN_MAX ISO_MAX_VOLUME_ID



/* CD, DVD or UNKNOWN - sometimes knowing this is enough */
typedef enum {
	CDW_DISC_SIMPLE_TYPE_UNKNOWN,
	CDW_DISC_SIMPLE_TYPE_CD,
	CDW_DISC_SIMPLE_TYPE_DVD,
} cdw_disc_simple_type_t;

typedef struct {
	iso9660_t *p_iso;
	int fd;
	iso9660_pvd_t pvd;
} cdw_cdio_iso9660_fs_t;


typedef struct {
	cdio_fs_t type;
	const char *type_label;
	char volume_id[CDW_CDIO_VOLUME_ID_LEN_MAX + 1];
	long int n_sectors;

	union {
		cdw_cdio_iso9660_fs_t iso9660;
		/* cdw_cdio_udf_fs_t udf; */
	} fs;
} cdw_optical_fs_t;


/* functions initializing and cleaning up cdio module */
void cdw_cdio_init(void);
void cdw_cdio_clean(void);


/* cdw_cdio_open_disc() needs to be used before accessing any
   information collected by cdio module or before accessing disc
   using cdw cdio functions */
cdw_rv_t cdw_cdio_open_disc(void);
/* use this function to close cdio disc after you have completed
   all operations on a disc */
void cdw_cdio_close_disc(void);


/* getters */
cdw_disc_simple_type_t cdw_cdio_get_simple_type(void);
discmode_t cdw_cdio_get_disc_mode(void);
track_t cdw_cdio_get_first_track_number(void);
bool cdw_cdio_is_blank(void);
track_t cdw_cdio_get_first_track(void);
track_t cdw_cdio_get_last_track(void);
track_t cdw_cdio_get_number_of_tracks(void);
bool cdw_cdio_is_audio_track(track_t t);
bool cdw_cdio_is_data_track(track_t t);
bool cdw_cdio_disc_supported_for_cdw_ripping(void);
const char *cdw_cdio_get_fs_type_label(void);
cdio_fs_t   cdw_cdio_get_fs_type(void);
bool cdw_cdio_is_fs_iso(cdio_fs_t fs);
const char *cdw_cdio_get_volume_id(void);


/* functions reading content of disc */
cdw_rv_t cdw_cdio_copy_tracks_to_file(int fd);
int      cdw_cdio_copy_sectors_to_file(track_t track, int fd);
void     cdw_cdio_copy_print_debug_on_error(int error);


/* debug printing */
void cdw_cdio_print_current_disc(void);


#endif /* H_CDW_CDIO */

