#    Copyright 2003,2008 Regis Damongeot

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 
proc refresh_cmd_line {} {
	global total_file_size_f option_udf_ext option_joliet_ext option_rr_ext burn_speed file_list volume_id option_pad burn_type command_line t_session burning_device iso_file space_left_f burn_command option_dvd_compat option_overburn excluded_file_list dvd_size v_create_iso option_eject_cd option_tao_dao_cd cd_session_type temp_burning_device iso_creation_command cd_burning_command i18n_need_overburn
	set_visible_options

	if { "$burn_type" == "burn_iso" } {
		#burning of an ISO image
		if { $temp_burning_device != "" } {
			#in this case, we just changed burning type to burning ISO, so we restore burning device
			set burning_device "$temp_burning_device"
			set temp_burning_device ""
		}
		if { $dvd_size <= 716800 } {
			set burn_command $cd_burning_command
		} else {
			set burn_command "growisofs"
		}
		set v_create_iso "no"
		set volume_id ""
	} elseif {$burn_type == "burn_dvd" && $v_create_iso == "no"} {
		#DVD burning without ISO creation
		if { $temp_burning_device != "" } {
			#in this case, we just changed burning type to burning CD/DVD, so we restore burning device
			set burning_device "$temp_burning_device"
			set temp_burning_device ""
		}
		if { $dvd_size <= 716800 } {
			set burn_command $iso_creation_command
		} else {
			set burn_command "growisofs"
		}
		set iso_file ""
	} else {
		#ISO creation
		set burn_command $iso_creation_command
		if { $temp_burning_device == "" } {
			#in this case, we just change burning type to ISO creation so we need to save the previous real burning device
			set temp_burning_device "$burning_device"
			set burning_device ""
		}
	}

	if { [catch { exec ps -A | grep -v "grep -E" | grep -E "growisofs|cdrecord" }] != 0} {
		if { ($burn_type == "burn_dvd") || ($v_create_iso == "yes") } {
			check_volume_id
			if { [lindex $space_left_f 0] <0 && $option_overburn == "" && $burn_type == "burn_dvd" && $v_create_iso == "no" } {
				#exact maximum size: 4.37721610069. Although it should be oversized because "du" return > real file size due to indirect blocks its undersized to prevent disallowing burning when beleving overburn is needed while its no the case (anyway growisofs check it)
				set command_line "$i18n_need_overburn"
				.f_burn.go_button configure -state disabled
			} else {
				#create list containing excluded files and directories prefixed with -m option
				set excluded_file_list_t ""
				foreach i $excluded_file_list {
					append excluded_file_list_t "-m {$i} "
					
				}

				#create local variable that are copy of global ones, used to remove unused option
				#for exemple, when creating ISO, no need of overburn option
				#we create local variables to prevent using a lot of "if/else" that only remove theses options when needed because there is already a lot of if else only for CD/DVDs :-(
				set local_option_overburn "$option_overburn"
				set local_t_session "$t_session"
				set local_burn_speed "$burn_speed"
				set local_option_dvd_compat "$option_dvd_compat"
				if { $v_create_iso == "yes" } {
					set local_option_overburn ""
					set local_t_session ""
					set local_burn_speed ""
					set local_option_dvd_compat ""
				} else {
					if { $burn_speed != "" } {
						#for growisofs there is a "-" before speed option while cdrecord doesn't take one
						if { $dvd_size > 716800 } {
							set local_burn_speed "-speed=$burn_speed"
						} else {
							set local_burn_speed "speed=$burn_speed"
						}
					} else {
						set local_burn_speed ""
					}
				}

				#if we burn a DVD-Video UDF complient we don't need to use graft points
				if {$option_udf_ext != "-dvd-video" } {
					#if burning a CD, command line is different (pipe between mkisofs and cdrecord)
					#if burning DVD or creating iso, command syntax are the same
					if { $dvd_size <= 716800 &&  $v_create_iso == "no" } {
						set command_line "[concat $burn_command $volume_id $option_udf_ext $option_joliet_ext $option_rr_ext $option_pad -graft-points $excluded_file_list_t [file_list_w_modif_dir $file_list]] | cdrecord dev=$burning_device $local_burn_speed $option_overburn $option_eject_cd $cd_session_type -"
					} else {
						set command_line "[concat $burn_command $local_t_session $burning_device $volume_id $option_udf_ext $option_joliet_ext $option_rr_ext $local_burn_speed $local_option_dvd_compat $local_option_overburn $option_pad -graft-points $excluded_file_list_t [file_list_w_modif_dir $file_list]]"
					}
				} else {
					if { $dvd_size <= 716800  && $v_create_iso == "no" } {
						set command_line "[concat $burn_command $volume_id $option_udf_ext $excluded_file_list_t $file_list] | cdrecord dev=$burning_device $local_burn_speed $option_overburn $option_eject_cd $cd_session_type -"
					} else {
						set command_line "[concat $burn_command $local_t_session $burning_device $volume_id $option_udf_ext $local_burn_speed $local_option_dvd_compat $local_option_overburn $excluded_file_list_t $file_list]"
					}
				}
				#enable burn button if all OK
				if { [.f_burn.go_button cget -state] == "disabled" } { .f_burn.go_button configure -state normal }
			}
		} elseif { $burn_type == "burn_iso" } {
			if { $burn_speed != "" } {
				#for growisofs there is a "-" before speed option while cdrecord doesn't take one
				if { $dvd_size > 716800 } {
					set local_burn_speed "-speed=$burn_speed"
				} else {
					set local_burn_speed "speed=$burn_speed"
				}
			} else {
				set local_burn_speed ""
			}
			if { $dvd_size <= 716800 } {
				set command_line "$burn_command $option_overburn $local_burn_speed $option_eject_cd  $option_tao_dao_cd dev=$burning_device [exec echo $iso_file | sed s/\ /\\\\\ /g -]"
			} else {
				set command_line "$burn_command $option_dvd_compat $local_burn_speed $option_overburn $t_session $burning_device=[exec echo $iso_file | sed s/\ /\\\\\ /g -]"
			}
			if { [.f_burn.go_button cget -state] == "disabled" } { .f_burn.go_button configure -state normal }
		}
	} else { set command_line "growisofs/cdrecord is currently working" }
	if {($t_session == "-M" && $space_left_f != "N/A") || ($t_session == "-use-the-force-luke=tty -Z" && $space_left_f == "N/A") } { refresh_total_file_size }
	return 1
}