/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include <locale.h>
#include "interface.h"
#include "support.h"
#include "ac.h"
#include "gconfig.h"

#include "dvdtools.h"
#include "dvdformat.h"
#include "dvdcopy.h"
#include "dvdbackup.h"
#include "dvd2vob.h"
#include "uitools.h"
#include "message.h"
#include "avancement.h"
#include "systools.h"
#include "profile.h"
#include "const.h"

#define __NEED_GLOBALS__
#include "globals.h"


/*------------------------------------------------------------------------------
	CHECKDVD-
Linux!jef 2007/01/09 22:45:11
------------------------------------------------------------------------------*/

gboolean CheckDvd( gpointer data )
{
	GtkWidget * forme = (GtkWidget *)data;
	int ret;

	ret = IsDvdLoaded( Device );
	if( ret == 1 ) {
		gtk_dialog_response( GTK_DIALOG(forme), GTK_RESPONSE_OK );

		return( FALSE );
	}
	return( TRUE );
}
/*------------------------------------------------------------------------------
	ENABLEANDSCAN-
Linux!jef 2008/01/10 23:26:31
------------------------------------------------------------------------------*/

static void EnableAndScan( GtkWidget * dvd95 )
{
	GtkWidget * item;
	Profile_t * p = GetProfile( GetFormat() );

	g_assert( p );

	item = lookup_widget(GTK_WIDGET(dvd95), "Encoder" );
	g_assert(item);
	gtk_widget_set_sensitive( GTK_WIDGET(item), TRUE );
	item = lookup_widget(GTK_WIDGET(dvd95), "ViewPiste" );
	g_assert(item);
	gtk_widget_set_sensitive( GTK_WIDGET(item), TRUE );

	item = lookup_widget(GTK_WIDGET(dvd95), "Evaluer" );
	g_assert(item);
	if( p->profileFlags & PROFILE_AVI_F )
		gtk_widget_set_sensitive( GTK_WIDGET(item), FALSE );
	else
		gtk_widget_set_sensitive( GTK_WIDGET(item), TRUE );

	item = lookup_widget(GTK_WIDGET(dvd95), "Qualite" );
	g_assert(item);
	if( p->profileFlags & PROFILE_AVI_F )
		gtk_widget_set_sensitive( GTK_WIDGET(item), FALSE );
	else
		gtk_widget_set_sensitive( GTK_WIDGET(item), TRUE );

	item = lookup_widget(GTK_WIDGET(dvd95), "PistesVideo" );
	g_assert(item);
	gtk_widget_set_sensitive( GTK_WIDGET(item), TRUE );

	item = lookup_widget(GTK_WIDGET(dvd95), "PistesAudio" );
	g_assert(item);
	gtk_widget_set_sensitive( GTK_WIDGET(item), TRUE );

	item = lookup_widget(GTK_WIDGET(dvd95), "SousTitres" );
	g_assert(item);
	if( p->profileFlags & PROFILE_HANDLE_SUBS_F )
		gtk_widget_set_sensitive( GTK_WIDGET(item), TRUE );
	else
		gtk_widget_set_sensitive( GTK_WIDGET(item), FALSE );

	ScanDvd( dvd95 );
}

#ifdef __APPLE__
static int FindDvd()
{
	/* on mac, a dvd device does not have a /dev/.. entry,
	  if no medium is mounted
	   instead of checking, if there is a dvd at a specific /dev/dvdX mounted
	     we better just try to find a DVD */
	GSList * devices = getDevices();
	if( devices ) {
		strcpy( Device, devices->data);
		freeDevices(devices);
		return( 1 );
	}
	return( 0 );
}
#endif
/*------------------------------------------------------------------------------
	DEVICECHECKING-
Linux!jef 2007/01/23 22:31:37
------------------------------------------------------------------------------*/

void DeviceChecking( GtkWidget * Dvd95 )
{
	int ret;
	GtkWidget * forme;

#ifdef __APPLE__
	ret = FindDvd();
#else
	ret = IsDvdLoaded( Device );
#endif
	if( ret == 1 ) {
		EnableAndScan( Dvd95 );
		return;
	}
	forme = create_alerte_medium();
	g_timeout_add( 500, CheckDvd, forme );
	while( 1 ) {
		ret = gtk_dialog_run( GTK_DIALOG( forme ) );

		if( ret == GTK_RESPONSE_OK ) {
#ifdef __APPLE__
			ret = FindDvd();
#else
			ret = IsDvdLoaded( Device );
#endif
			if( ret == 1 ) {
				break;
			}
		}
		if( ret == GTK_RESPONSE_CLOSE ) {
			gtk_widget_destroy( forme );
			exit(0);
		}
	}
	gtk_widget_destroy( forme );
	EnableAndScan( Dvd95 );
}
/***************************************************************************//**
 *	USAGE-
 * @date	2009/01/27 23:00:24
 * @author	jef-Linux
 * @brief
 *	Pas d'explication
 * @details
 *	Pas de details
 * @param[in]	Pas de detail
 * @param[out]	Pas de detail
*******************************************************************************/

static int usage( char * progname )
{
	printf("%s [options]\n", progname );
	printf("   --isofile IsoFileName.\n");
	printf("   --isodir IsoDirName.\n");
	printf("   --iso : Choose iso file.\n");
	exit(0);
}

int
main (int argc, char *argv[])
{
	GtkWidget *Dvd95;
	GtkWidget * item;
	char * lang;
	int i;

// fprintf(stderr,"DVD5_WANTED_BYTES_LL: %lld\n", DVD5_WANTED_BYTES_LL );

/* Multi threading */
	g_thread_init(NULL);
	gdk_threads_init();

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	ac_mmtest();
	tc_memcpy_init( 0, ac_mmflag());

	gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
			argc, argv,
			GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
			NULL);

	gnome_sound_init( "localhost" );


/* Languague if any */
#if 1
	lang = ConfigGetString( KEY_LANG, "" );
	if( lang && *lang ) {
		if( !strcmp( lang,"Fran\303\247ais"))	setlocale( LC_MESSAGES, "fr_FR.UTF-8" );
		if( !strcasecmp( lang,"English"))	setlocale( LC_MESSAGES, "en_US.UTF-8" );
		if( !strcasecmp( lang,"Deutsch"))	setlocale( LC_MESSAGES, "de_DE.UTF-8" );
		if( !strcasecmp( lang,"Greek"))		setlocale( LC_MESSAGES, "el_GR.UTF-8" );
		if( !strcasecmp( lang,"Estonian"))	setlocale( LC_MESSAGES, "et_EE.UTF-8" );
		if( !strcasecmp( lang,"Hungarian"))	setlocale( LC_MESSAGES, "hu_HU.UTF-8" );
		if( !strcasecmp( lang,"Dutch"))		setlocale( LC_MESSAGES, "nl_NL.UTF-8" );
		if( !strcasecmp( lang,"Portuguese"))	setlocale( LC_MESSAGES, "pt_BR.UTF-8" );
		if( !strcasecmp( lang,"Czech"))		setlocale( LC_MESSAGES, "cs_CZ.UTF-8" );
		if( !strcasecmp( lang,"Spanish"))	setlocale( LC_MESSAGES, "es_ES.UTF-8" );
		if( !strcasecmp( lang,"Italian"))	setlocale( LC_MESSAGES, "it_IT.UTF-8" );
	}
#endif

/* Pour que les doubles soit sous la forme xxx.yyy */
	setlocale( LC_NUMERIC, "C" );
/*
	{
		double d = 1.125;
		fprintf(stderr,"d=%f\n", d );
	}
*/


  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
	/* Use first device if none is set in preferences */
	char *config_device = ConfigGetString( KEY_DEVICE, NULL);
	if( !config_device ) {
		GSList * devices = getDevices();
		if( devices ) {
			strcpy( Device, devices->data);
			freeDevices(devices);
		}
	}
	else {
		strcpy( Device, config_device);
	}

	Dvd95 = create_main();
	MainDlg = Dvd95;
	ConfigSetSizePosMain( Dvd95 );

/* Gestion dvd95 --iso */
	for( i = 0; i < argc; i++ ) {
		if( !strcmp( argv[i], "--iso")) {
			if( ChoixFichierIso( Device ) == 0 )
				DeviceSpecifiedF = 1;
		}
		if( !strcmp( argv[i], "--isofile")) {
			strcpy( Device, argv[i+1] );
			DeviceSpecifiedF = 1;
		}
		if( !strcmp( argv[i], "--dvddir")) {
			strcpy( Device, argv[i+1] );
			DeviceSpecifiedF = 1;
		}
		if( !strcmp( argv[i], "--help")) {
			usage( argv[0] );
		}
		if( !strcmp( argv[i], "-h")) {
			usage( argv[0] );
		}
	}

	InitTrace();
	InitProfiles();
	{
		int dvdFormat = ConfigGetInt( KEY_MEDIA, DVD5 );
		Profile_t * p = GetProfile( dvdFormat );
		char title[512];

		if( !p ) {
			dvdFormat = DVD5;
			p = GetProfile( dvdFormat );
			g_assert( p );
		}
		if( p->profileFlags & PROFILE_AVAIL_F ) {
			SetFormat( dvdFormat );
		}
		else {
			dvdFormat = DVD5;
			SetFormat( dvdFormat );
			p = GetProfile( dvdFormat );
			g_assert( p );
		}
		sprintf( title, "%s : %s",  _("DVD 9 to 5"), p->libel );
		gtk_window_set_title( GTK_WINDOW(Dvd95), title );
	}

/* Manage Button sensitivity */
	item = lookup_widget(GTK_WIDGET(Dvd95), "Encoder" );
	g_assert(item);
	gtk_widget_set_sensitive( GTK_WIDGET(item), FALSE );

	item = lookup_widget(GTK_WIDGET(Dvd95), "ViewPiste" );
	g_assert(item);
	gtk_widget_set_sensitive( GTK_WIDGET(item), FALSE );

	item = lookup_widget(GTK_WIDGET(Dvd95), "Evaluer" );
	g_assert(item);
	gtk_widget_set_sensitive( GTK_WIDGET(item), FALSE );

	item = lookup_widget(GTK_WIDGET(Dvd95), "PistesVideo" );
	g_assert(item);
	gtk_widget_set_sensitive( GTK_WIDGET(item), FALSE );

	item = lookup_widget(GTK_WIDGET(Dvd95), "PistesAudio" );
	g_assert(item);
	gtk_widget_set_sensitive( GTK_WIDGET(item), FALSE );

	item = lookup_widget(GTK_WIDGET(Dvd95), "SousTitres" );
	g_assert(item);
	gtk_widget_set_sensitive( GTK_WIDGET(item), FALSE );

	gtk_widget_show (Dvd95);

	GtkFlush();

	DeviceChecking( Dvd95 );

	gtk_main ();

//	gdk_threads_leave();
	return( 0 );
}

