;hq3x filter
;16bpp output
;----------------------------------------------------------
;Copyright (C) 2003 MaxSt ( maxst@hiend3d.com )
;MDP port Copyright (c) 2008-2009 by David Korth
;
;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either
;version 2 of the License, or (at your option) any later
;version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

; MDP NASM (x86) macros.
%include "mdp/mdp_nasm_x86.inc"

section .bss align=64
	
	linesleft:	resd 1
	xcounter:	resd 1
	cross:		resd 1
	nextline:	resd 1
	prevline:	resd 1
	w1:		resd 1
	w2:		resd 1
	w3:		resd 1
	w4:		resd 1
	w5:		resd 1
	w6:		resd 1
	w7:		resd 1
	w8:		resd 1
	w9:		resd 1
	
	; Color depth variables.
	zerolowbits:	resd 1
	
section .data align=64
	
	extern SYM(mdp_render_hq3x_RGB16to32)
	extern SYM(mdp_render_hq3x_RGB16toYUV)
	
; Constants
zerolowbits_15	equ	0x7BDE7BDE
zerolowbits_16	equ	0xF7DEF7DE

section .rodata align=64
	
	reg_blank:	dd  0, 0
	const7:		dd  0x00070007, 0x00000007
	threshold:	dd  0x00300706, 0x00000000
	
	FuncTable:
		dd ..@flag0, ..@flag1, ..@flag2, ..@flag3, ..@flag4, ..@flag5, ..@flag6, ..@flag7
		dd ..@flag8, ..@flag9, ..@flag10, ..@flag11, ..@flag12, ..@flag13, ..@flag14, ..@flag15
		dd ..@flag16, ..@flag17, ..@flag18, ..@flag19, ..@flag20, ..@flag21, ..@flag22, ..@flag23
		dd ..@flag24, ..@flag25, ..@flag26, ..@flag27, ..@flag28, ..@flag29, ..@flag30, ..@flag31
		dd ..@flag32, ..@flag33, ..@flag34, ..@flag35, ..@flag36, ..@flag37, ..@flag38, ..@flag39
		dd ..@flag40, ..@flag41, ..@flag42, ..@flag43, ..@flag44, ..@flag45, ..@flag46, ..@flag47
		dd ..@flag48, ..@flag49, ..@flag50, ..@flag51, ..@flag52, ..@flag53, ..@flag54, ..@flag55
		dd ..@flag56, ..@flag57, ..@flag58, ..@flag59, ..@flag60, ..@flag61, ..@flag62, ..@flag63
		dd ..@flag64, ..@flag65, ..@flag66, ..@flag67, ..@flag68, ..@flag69, ..@flag70, ..@flag71
		dd ..@flag72, ..@flag73, ..@flag74, ..@flag75, ..@flag76, ..@flag77, ..@flag78, ..@flag79
		dd ..@flag80, ..@flag81, ..@flag82, ..@flag83, ..@flag84, ..@flag85, ..@flag86, ..@flag87
		dd ..@flag88, ..@flag89, ..@flag90, ..@flag91, ..@flag92, ..@flag93, ..@flag94, ..@flag95
		dd ..@flag96, ..@flag97, ..@flag98, ..@flag99, ..@flag100, ..@flag101, ..@flag102, ..@flag103
		dd ..@flag104, ..@flag105, ..@flag106, ..@flag107, ..@flag108, ..@flag109, ..@flag110, ..@flag111
		dd ..@flag112, ..@flag113, ..@flag114, ..@flag115, ..@flag116, ..@flag117, ..@flag118, ..@flag119
		dd ..@flag120, ..@flag121, ..@flag122, ..@flag123, ..@flag124, ..@flag125, ..@flag126, ..@flag127
		dd ..@flag128, ..@flag129, ..@flag130, ..@flag131, ..@flag132, ..@flag133, ..@flag134, ..@flag135
		dd ..@flag136, ..@flag137, ..@flag138, ..@flag139, ..@flag140, ..@flag141, ..@flag142, ..@flag143
		dd ..@flag144, ..@flag145, ..@flag146, ..@flag147, ..@flag148, ..@flag149, ..@flag150, ..@flag151
		dd ..@flag152, ..@flag153, ..@flag154, ..@flag155, ..@flag156, ..@flag157, ..@flag158, ..@flag159
		dd ..@flag160, ..@flag161, ..@flag162, ..@flag163, ..@flag164, ..@flag165, ..@flag166, ..@flag167
		dd ..@flag168, ..@flag169, ..@flag170, ..@flag171, ..@flag172, ..@flag173, ..@flag174, ..@flag175
		dd ..@flag176, ..@flag177, ..@flag178, ..@flag179, ..@flag180, ..@flag181, ..@flag182, ..@flag183
		dd ..@flag184, ..@flag185, ..@flag186, ..@flag187, ..@flag188, ..@flag189, ..@flag190, ..@flag191
		dd ..@flag192, ..@flag193, ..@flag194, ..@flag195, ..@flag196, ..@flag197, ..@flag198, ..@flag199
		dd ..@flag200, ..@flag201, ..@flag202, ..@flag203, ..@flag204, ..@flag205, ..@flag206, ..@flag207
		dd ..@flag208, ..@flag209, ..@flag210, ..@flag211, ..@flag212, ..@flag213, ..@flag214, ..@flag215
		dd ..@flag216, ..@flag217, ..@flag218, ..@flag219, ..@flag220, ..@flag221, ..@flag222, ..@flag223
		dd ..@flag224, ..@flag225, ..@flag226, ..@flag227, ..@flag228, ..@flag229, ..@flag230, ..@flag231
		dd ..@flag232, ..@flag233, ..@flag234, ..@flag235, ..@flag236, ..@flag237, ..@flag238, ..@flag239
		dd ..@flag240, ..@flag241, ..@flag242, ..@flag243, ..@flag244, ..@flag245, ..@flag246, ..@flag247
		dd ..@flag248, ..@flag249, ..@flag250, ..@flag251, ..@flag252, ..@flag253, ..@flag254, ..@flag255
	
	FuncTable2:
		dd ..@cross0, ..@cross1, ..@cross2, ..@flag0,
		dd ..@cross4, ..@flag0,  ..@flag0,  ..@flag0,
		dd ..@cross8, ..@flag0,  ..@flag0,  ..@flag0,
		dd ..@flag0,  ..@flag0,  ..@flag0,  ..@flag0

section .text align=64

%macro TestDiff 2
	xor	ecx, ecx
	mov	edx, [%1]
	cmp	edx, [%2]
	je	%%fin
	mov	ecx, [SYM(mdp_render_hq3x_RGB16toYUV)]
	movd	mm1, [ecx + edx * 4]
	movq	mm5, mm1
	mov	edx, [%2]
	movd	mm2, [ecx + edx * 4]
	psubusb	mm1, mm2
	psubusb	mm2, mm5
	por	mm1, mm2
	psubusb	mm1, [threshold]
	movd	ecx, mm1
%%fin:
%endmacro

%macro DiffOrNot 4
	TestDiff %1, %2
	test	ecx, ecx
	jz	%%same
	%3
	jmp	%%fin
%%same:
	%4
%%fin
%endmacro

%macro DiffOrNot 6
	TestDiff %1, %2
	test	ecx, ecx
	jz	%%same
	%3
	%4
	jmp	%%fin
%%same:
	%5
	%6
%%fin
%endmacro

%macro DiffOrNot 8
	TestDiff %1, %2
	test	ecx, ecx
	jz	%%same
	%3
	%4
	%5
	jmp	%%fin
%%same:
	%6
	%7
	%8
%%fin
%endmacro

%macro DiffOrNot 10
	TestDiff %1, %2
	test	ecx, ecx
	jz	%%same
	%3
	%4
	%5
	%6
	jmp	%%fin
%%same:
	%7
	%8
	%9
	%10
%%fin
%endmacro

%macro Interp1 3
	mov	edx, %2
	mov	ecx, %3
	cmp	edx, ecx
	je	%%fin
	and	edx, [zerolowbits]
	and	ecx, [zerolowbits]
	add	ecx, edx
	shr	ecx, 1
	add	ecx,0x0821
	and	ecx, [zerolowbits]
	add	edx, ecx
	shr	edx, 1
%%fin
	mov	%1, dx
%endmacro

%macro Interp2 4
	mov	edx, %3
	mov	ecx, %4
	cmp	edx, ecx
	je	%%fin1
	and	edx, [zerolowbits]
	and	ecx, [zerolowbits]
	add	ecx, edx
	shr	ecx, 1
	add	ecx,0x0821
%%fin1
	mov	edx, %2
	cmp	edx, ecx
	je	%%fin2
	and	ecx, [zerolowbits]
	and	edx, [zerolowbits]
	add	edx, ecx
	shr	edx, 1
%%fin2
	mov	%1, dx
%endmacro

%macro Interp3 2
	mov		ecx, [SYM(mdp_render_hq3x_RGB16to32)]
	movd		mm1, [ecx + eax * 4]
	mov		edx, %2
	movd		mm2, [ecx + edx * 4]
	punpcklbw	mm1, [reg_blank]
	punpcklbw	mm2, [reg_blank]
	pmullw		mm1, [const7]
	paddw		mm1, mm2
	psrlw		mm1, 5
	packuswb	mm1, [reg_blank]
	movd		edx, mm1
	shl		dl,  2
	shr		edx, 1
	shl		dx,  3
	shr		edx, 5
	mov		%1,  dx
%endmacro

%macro Interp4 3
	mov		ecx, [SYM(mdp_render_hq3x_RGB16to32)]
	movd		mm1, [ecx + eax * 4]
	mov		edx, %2
	movd		mm2, [ecx + edx * 4]
	mov		edx, %3
	movd		mm3, [ecx + edx * 4]
	punpcklbw	mm1, [reg_blank]
	punpcklbw	mm2, [reg_blank]
	punpcklbw	mm3, [reg_blank]
	psllw		mm1, 1
	paddw		mm2, mm3
	pmullw		mm2, [const7]
	paddw		mm1, mm2
	psrlw		mm1, 6
	packuswb	mm1, [reg_blank]
	movd		edx, mm1
	shl		dl,  2
	shr		edx, 1
	shl		dx,  3
	shr		edx, 5
	mov		%1,  dx
%endmacro

%macro Interp5 3
	mov	edx, %2
	mov	ecx, %3
	cmp	edx, ecx
	je	%%fin
	and	edx, [zerolowbits]
	and	ecx, [zerolowbits]
	add	edx, ecx
	shr	edx, 1
%%fin
	mov	%1, dx
%endmacro

%macro PIXEL00_1M 0
	Interp1 [edi], eax, [w1]
%endmacro

%macro PIXEL00_1U 0
	Interp1 [edi], eax, [w2]
%endmacro

%macro PIXEL00_1L 0
	Interp1 [edi], eax, [w4]
%endmacro

%macro PIXEL00_2 0
	Interp2 [edi], eax, [w4], [w2]
%endmacro

%macro PIXEL00_4 0
	Interp4 [edi], [w4], [w2]
%endmacro

%macro PIXEL00_5 0
	Interp5 [edi], [w4], [w2]
%endmacro

%macro PIXEL00_C 0
	mov	[edi], ax
%endmacro

%macro PIXEL01_1 0
	Interp1 [edi + 2], eax, [w2]
%endmacro

%macro PIXEL01_3 0
	Interp3 [edi + 2], [w2]
%endmacro

%macro PIXEL01_6 0
	Interp1 [edi + 2], [w2], eax
%endmacro

%macro PIXEL01_C 0
	mov	[edi + 2],	ax
%endmacro

%macro PIXEL02_1M 0
	Interp1 [edi + 4], eax, [w3]
%endmacro

%macro PIXEL02_1U 0
	Interp1 [edi + 4], eax, [w2]
%endmacro

%macro PIXEL02_1R 0
	Interp1 [edi + 4], eax, [w6]
%endmacro

%macro PIXEL02_2 0
	Interp2 [edi + 4], eax, [w2], [w6]
%endmacro

%macro PIXEL02_4 0
	Interp4 [edi + 4], [w2], [w6]
%endmacro

%macro PIXEL02_5 0
	Interp5 [edi + 4], [w2], [w6]
%endmacro

%macro PIXEL02_C 0
	mov	[edi + 4], ax
%endmacro

%macro PIXEL10_1 0
	Interp1 [edi + ebx], eax, [w4]
%endmacro

%macro PIXEL10_3 0
	Interp3 [edi + ebx], [w4]
%endmacro

%macro PIXEL10_6 0
	Interp1 [edi + ebx], [w4], eax
%endmacro

%macro PIXEL10_C 0
	mov	[edi + ebx], ax
%endmacro

%macro PIXEL11 0
	mov	[edi + ebx + 2], ax
%endmacro

%macro PIXEL12_1 0
	Interp1 [edi + ebx + 4], eax, [w6]
%endmacro

%macro PIXEL12_3 0
	Interp3 [edi + ebx + 4], [w6]
%endmacro             

%macro PIXEL12_6 0
	Interp1 [edi + ebx + 4], [w6], eax
%endmacro

%macro PIXEL12_C 0
	mov	[edi + ebx + 4], ax
%endmacro

%macro PIXEL20_1M 0
	Interp1 [edi + ebx * 2], eax, [w7]
%endmacro

%macro PIXEL20_1D 0
	Interp1 [edi + ebx * 2], eax, [w8]
%endmacro

%macro PIXEL20_1L 0
	Interp1 [edi + ebx * 2], eax, [w4]
%endmacro

%macro PIXEL20_2 0
	Interp2 [edi + ebx * 2], eax, [w8], [w4]
%endmacro

%macro PIXEL20_4 0
	Interp4 [edi + ebx * 2], [w8], [w4]
%endmacro

%macro PIXEL20_5 0
	Interp5 [edi + ebx * 2], [w8], [w4]
%endmacro

%macro PIXEL20_C 0
	mov	[edi + ebx * 2], ax
%endmacro

%macro PIXEL21_1 0
	Interp1 [edi + ebx * 2 + 2], eax, [w8]
%endmacro

%macro PIXEL21_3 0
	Interp3 [edi + ebx * 2 + 2], [w8]
%endmacro

%macro PIXEL21_6 0
	Interp1 [edi + ebx * 2 + 2], [w8], eax
%endmacro

%macro PIXEL21_C 0
	mov	[edi + ebx * 2 + 2], ax
%endmacro

%macro PIXEL22_1M 0
	Interp1 [edi + ebx * 2 + 4], eax, [w9]
%endmacro

%macro PIXEL22_1D 0
	Interp1 [edi + ebx * 2 + 4], eax, [w8]
%endmacro

%macro PIXEL22_1R 0
	Interp1 [edi + ebx * 2 + 4], eax, [w6]
%endmacro

%macro PIXEL22_2 0
	Interp2 [edi + ebx * 2 + 4], eax, [w6], [w8]
%endmacro

%macro PIXEL22_4 0
	Interp4 [edi + ebx * 2 + 4], [w6], [w8]
%endmacro

%macro PIXEL22_5 0
	Interp5 [edi + ebx * 2 + 4], [w6], [w8]
%endmacro

%macro PIXEL22_C 0
	mov	[edi + ebx * 2 + 4], ax
%endmacro

arg_destScreen	equ 8
arg_mdScreen	equ 12
arg_destPitch	equ 16
arg_srcPitch	equ 20
arg_width	equ 24
arg_height	equ 28
arg_mode565	equ 32

loc_calcPitchDiff	equ -4

;************************************************************************
; void mdp_render_hq3x_16_x86_mmx(uint16_t *destScreen, uint16_t *mdScreen,
;				  int destPitch, int srcPitch,
;				  int width, int height, int mode565);
global SYM(mdp_render_hq3x_16_x86_mmx)
SYM(mdp_render_hq3x_16_x86_mmx):
	
	; Set up the frame pointer.
	push	ebp
	mov	ebp, esp
	sub	esp, 4
	pushad
	
	mov	esi, [ebp + arg_mdScreen]
	mov	edi, [ebp + arg_destScreen]
	mov	ebx, [ebp + arg_width]
	add	ebx, ebx
	sub	[ebp + arg_srcPitch], ebx	; arg_srcPitch = offset
	mov	dword [prevline], 0
	mov	dword [nextline], ebx
	
	; MDP: Calculate the difference between the pitch and the source width.
	; Subtract width*6 from the destination pitch to get the difference.
	mov	eax, [ebp + arg_width]
	mov	edx, [ebp + arg_destPitch]
	add	eax, eax		; %eax == width*2
	add	eax, [ebp + arg_width]	; %eax == width*3
	add	eax, eax		; %eax == width*6
	sub	edx, eax		; %edx == destPitch - (width*6)
	mov	[ebp + loc_calcPitchDiff], edx
	
	; Get the height.
	mov	edx, [ebp + arg_height]
	mov	[linesleft], edx
	
	; Check for 15-bit color.
	test	byte [ebp + arg_mode565], 1
	mov	dword [zerolowbits], zerolowbits_16
	jnz	.LoopY
	
	; 15-bit color.
	mov	dword [zerolowbits], zerolowbits_15
	
.LoopY:
	mov	ecx, [ebp + arg_width]
	sub	ecx, 2			; x={Xres-2, Xres-1} are special cases.
	mov	dword [xcounter], ecx
    ; x=0 - special case
	mov	ebx, [prevline]
	movq	mm5, [esi + ebx]
	movq	mm6, [esi]
	mov	ebx, [nextline]
	movq	mm7, [esi + ebx]
	movd	eax, mm5
	movzx	edx, ax  
	mov	[w1], edx
	mov	[w2], edx
	shr	eax, 16
	mov	[w3], eax
	movd	eax, mm6
	movzx	edx, ax  
	mov	[w4], edx
	mov	[w5], edx
	shr	eax, 16
	mov	[w6], eax
	movd	eax, mm7
	movzx	edx, ax  
	mov	[w7], edx
	mov	[w8], edx
	shr	eax, 16
	mov	[w9], eax
	jmp	.flags
	
.LoopX:
	mov	ebx, [prevline]
	movq	mm5, [esi + ebx - 2]
	movq	mm6, [esi - 2]
	mov	ebx, [nextline]
	movq	mm7, [esi + ebx - 2]
	movd	eax, mm5
	movzx	edx, ax  
	mov	[w1], edx
	shr	eax, 16
	mov	[w2], eax
	psrlq	mm5, 32
	movd	eax, mm5
	movzx	edx, ax  
	mov	[w3], edx
	movd	eax, mm6
	movzx	edx, ax  
	mov	[w4], edx
	shr	eax, 16
	mov	[w5], eax
	psrlq	mm6, 32
	movd	eax, mm6
	movzx	edx, ax  
	mov	[w6], edx
	movd	eax, mm7
	movzx	edx, ax  
	mov	[w7], edx
	shr	eax, 16
	mov	[w8], eax
	psrlq	mm7, 32
	movd	eax, mm7
	movzx	edx, ax  
	mov	[w9], edx
	
.flags:
	mov	ebx, [SYM(mdp_render_hq3x_RGB16toYUV)]
	mov	eax, [w5]
	xor	ecx, ecx
	movd	mm5, [ebx + eax * 4]
	mov	dword [cross],0
	
	mov	edx, [w2]
	cmp	eax, edx
	je	.noflag2
	or	dword [cross], 1
	movq	mm1,mm5
	movd	mm2, [ebx + edx * 4]
	psubusb	mm1, mm2
	psubusb	mm2, mm5
	por	mm1, mm2
	psubusb	mm1, [threshold]
	movd	edx, mm1
	test	edx, edx
	jz	.noflag2
	or	ecx, 2
	
.noflag2:
	mov	edx, [w4]
	cmp	eax, edx
	je	.noflag4
	or	dword [cross],2
	movq	mm1,mm5
	movd	mm2, [ebx + edx * 4]
	psubusb	mm1, mm2
	psubusb	mm2, mm5
	por	mm1, mm2
	psubusb	mm1, [threshold]
	movd	edx, mm1
	test	edx, edx
	jz	.noflag4
	or	ecx, 8
	
.noflag4:
	mov	edx, [w6]
	cmp	eax, edx
	je	.noflag6
	or	dword [cross], 4
	movq	mm1,mm5
	movd	mm2, [ebx + edx * 4]
	psubusb	mm1, mm2
	psubusb	mm2, mm5
	por	mm1, mm2
	psubusb	mm1, [threshold]
	movd	edx, mm1
	test	edx, edx
	jz	.noflag6
	or	ecx, 16
	
.noflag6:
	mov	edx, [w8]
	cmp	eax, edx
	je	.noflag8
	or	dword [cross], 8
	movq	mm1,mm5
	movd	mm2, [ebx + edx * 4]
	psubusb	mm1, mm2
	psubusb	mm2, mm5
	por	mm1, mm2
	psubusb	mm1, [threshold]
	movd	edx, mm1
	test	edx, edx
	jz	.noflag8
	or	ecx, 64
	
.noflag8:
	test	ecx, ecx
	jnz	.testflag1
	mov	ecx, [cross]
	mov	ebx, [ebp + arg_destPitch]
	jmp	[FuncTable2 + ecx * 4]
	
.testflag1:
	mov	edx, [w1]
	cmp	eax, edx
	je	.noflag1
	movq	mm1,mm5
	movd	mm2, [ebx + edx * 4]
	psubusb	mm1, mm2
	psubusb	mm2, mm5
	por	mm1, mm2
	psubusb	mm1, [threshold]
	movd	edx, mm1
	test	edx, edx
	jz	.noflag1
	or	ecx, 1
	
.noflag1:
	mov	edx, [w3]
	cmp	eax, edx
	je	.noflag3
	movq	mm1,mm5
	movd	mm2, [ebx + edx * 4]
	psubusb	mm1, mm2
	psubusb	mm2, mm5
	por	mm1, mm2
	psubusb	mm1, [threshold]
	movd	edx, mm1
	test	edx, edx
	jz	.noflag3
	or	ecx, 4
	
.noflag3:
	mov	edx, [w7]
	cmp	eax, edx
	je	.noflag7
	movq	mm1,mm5
	movd	mm2, [ebx + edx * 4]
	psubusb	mm1, mm2
	psubusb	mm2, mm5
	por	mm1, mm2
	psubusb	mm1, [threshold]
	movd	edx, mm1
	test	edx, edx
	jz	.noflag7
	or	ecx, 32
	
.noflag7:
	mov	edx, [w9]
	cmp	eax, edx
	je	.noflag9
	movq	mm1,mm5
	movd	mm2, [ebx + edx * 4]
	psubusb	mm1, mm2
	psubusb	mm2, mm5
	por	mm1, mm2
	psubusb	mm1, [threshold]
	movd	edx, mm1
	test	edx, edx
	jz	.noflag9
	or	ecx, 128
	
.noflag9:
	mov	ebx, [ebp + arg_destPitch]
	jmp	[FuncTable + ecx * 4]


..@flag0:
..@flag1:
..@flag4:
..@flag32:
..@flag128:
..@flag5:
..@flag132:
..@flag160:
..@flag33:
..@flag129:
..@flag36:
..@flag133:
..@flag164:
..@flag161:
..@flag37:
..@flag165:
	PIXEL00_2
	PIXEL01_1
	PIXEL02_2
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_2
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag2:
..@flag34:
..@flag130:
..@flag162:
	PIXEL00_1M
	PIXEL01_C
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_2
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag16:
..@flag17:
..@flag48:
..@flag49:
	PIXEL00_2
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_2
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag64:
..@flag65:
..@flag68:
..@flag69:
	PIXEL00_2
	PIXEL01_1
	PIXEL02_2
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag8:
..@flag12:
..@flag136:
..@flag140:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_2
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag3:
..@flag35:
..@flag131:
..@flag163:
	PIXEL00_1L
	PIXEL01_C
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_2
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag6:
..@flag38:
..@flag134:
..@flag166:
	PIXEL00_1M
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_2
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag20:
..@flag21:
..@flag52:
..@flag53:
	PIXEL00_2
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_2
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag144:
..@flag145:
..@flag176:
..@flag177:
	PIXEL00_2
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_2
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag192:
..@flag193:
..@flag196:
..@flag197:
	PIXEL00_2
	PIXEL01_1
	PIXEL02_2
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag96:
..@flag97:
..@flag100:
..@flag101:
	PIXEL00_2
	PIXEL01_1
	PIXEL02_2
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1L
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag40:
..@flag44:
..@flag168:
..@flag172:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_2
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag9:
..@flag13:
..@flag137:
..@flag141:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_2
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag18:
..@flag50:
	PIXEL00_1M
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_1M, PIXEL12_C, PIXEL01_3, PIXEL02_4, PIXEL12_3
	PIXEL10_1
	PIXEL11
	PIXEL20_2
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag80:
..@flag81:
	PIXEL00_2
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL20_1M
	DiffOrNot w6, w8, PIXEL12_C, PIXEL21_C, PIXEL22_1M, PIXEL12_3, PIXEL21_3, PIXEL22_4
	jmp .LoopX_end

..@flag72:
..@flag76:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_2
	PIXEL11
	PIXEL12_1
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_1M, PIXEL21_C, PIXEL10_3, PIXEL20_4, PIXEL21_3
	PIXEL22_1M
	jmp .LoopX_end

..@flag10:
..@flag138:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL01_C, PIXEL10_C, PIXEL00_4, PIXEL01_3, PIXEL10_3
	PIXEL02_1M
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag66:
	PIXEL00_1M
	PIXEL01_C
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag24:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag7:
..@flag39:
..@flag135:
	PIXEL00_1L
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_2
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag148:
..@flag149:
..@flag180:
	PIXEL00_2
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_2
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag224:
..@flag228:
..@flag225:
	PIXEL00_2
	PIXEL01_1
	PIXEL02_2
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1L
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag41:
..@flag169:
..@flag45:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_2
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag22:
..@flag54:
	PIXEL00_1M
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL12_C, PIXEL01_3, PIXEL02_4, PIXEL12_3
	PIXEL10_1
	PIXEL11
	PIXEL20_2
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag208:
..@flag209:
	PIXEL00_2
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL20_1M
	DiffOrNot w6, w8, PIXEL12_C, PIXEL21_C, PIXEL22_C, PIXEL12_3, PIXEL21_3, PIXEL22_4
	jmp .LoopX_end

..@flag104:
..@flag108:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_2
	PIXEL11
	PIXEL12_1
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL21_C, PIXEL10_3, PIXEL20_4, PIXEL21_3
	PIXEL22_1M
	jmp .LoopX_end

..@flag11:
..@flag139:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL10_C, PIXEL00_4, PIXEL01_3, PIXEL10_3
	PIXEL02_1M
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag19:
..@flag51:
	DiffOrNot w2, w6, PIXEL00_1L, PIXEL01_C, PIXEL02_1M, PIXEL12_C, PIXEL00_2, PIXEL01_6, PIXEL02_5, PIXEL12_1
	PIXEL10_1
	PIXEL11
	PIXEL20_2
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag146:
..@flag178:
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_1M, PIXEL12_C, PIXEL22_1D, PIXEL01_1, PIXEL02_5, PIXEL12_6, PIXEL22_2
	PIXEL00_1M
	PIXEL10_1
	PIXEL11
	PIXEL20_2
	PIXEL21_1
	jmp .LoopX_end

..@flag84:
..@flag85:
	DiffOrNot w6, w8, PIXEL02_1U, PIXEL12_C, PIXEL21_C, PIXEL22_1M, PIXEL02_2, PIXEL12_6, PIXEL21_1, PIXEL22_5
	PIXEL00_2
	PIXEL01_1
	PIXEL10_1
	PIXEL11
	PIXEL20_1M
	jmp .LoopX_end

..@flag112:
..@flag113:
	DiffOrNot w6, w8, PIXEL12_C, PIXEL20_1L, PIXEL21_C, PIXEL22_1M, PIXEL12_1, PIXEL20_2, PIXEL21_6, PIXEL22_5
	PIXEL00_2
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	jmp .LoopX_end

..@flag200:
..@flag204:
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_1M, PIXEL21_C, PIXEL22_1R, PIXEL10_1, PIXEL20_5, PIXEL21_6, PIXEL22_2
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_2
	PIXEL11
	PIXEL12_1
	jmp .LoopX_end

..@flag73:
..@flag77:
	DiffOrNot w8, w4, PIXEL00_1U, PIXEL10_C, PIXEL20_1M, PIXEL21_C, PIXEL00_2, PIXEL10_6, PIXEL20_5, PIXEL21_1
	PIXEL01_1
	PIXEL02_2
	PIXEL11
	PIXEL12_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag42:
..@flag170:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL01_C, PIXEL10_C, PIXEL20_1D, PIXEL00_5, PIXEL01_1, PIXEL10_6, PIXEL20_2
	PIXEL02_1M
	PIXEL11
	PIXEL12_1
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag14:
..@flag142:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL01_C, PIXEL02_1R, PIXEL10_C, PIXEL00_5, PIXEL01_6, PIXEL02_2, PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag67:
	PIXEL00_1L
	PIXEL01_C
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag70:
	PIXEL00_1M
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag28:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag152:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag194:
	PIXEL00_1M
	PIXEL01_C
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag98:
	PIXEL00_1M
	PIXEL01_C
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1L
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag56:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag25:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag26:
..@flag31:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL10_C, PIXEL00_4, PIXEL10_3
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_C, PIXEL12_C, PIXEL02_4, PIXEL12_3
	PIXEL11
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag82:
..@flag214:
	PIXEL00_1M
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL01_3, PIXEL02_4
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	DiffOrNot w6, w8, PIXEL21_C, PIXEL22_C, PIXEL21_3, PIXEL22_4
	jmp .LoopX_end

..@flag88:
..@flag248:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_1M
	PIXEL11
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL10_3, PIXEL20_4
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL12_C, PIXEL22_C, PIXEL12_3, PIXEL22_4
	jmp .LoopX_end

..@flag74:
..@flag107:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL00_4, PIXEL01_3
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	DiffOrNot w8, w4, PIXEL20_C, PIXEL21_C, PIXEL20_4, PIXEL21_3
	PIXEL22_1M
	jmp .LoopX_end

..@flag27:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL10_C, PIXEL00_4, PIXEL01_3, PIXEL10_3
	PIXEL02_1M
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag86:
	PIXEL00_1M
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL12_C, PIXEL01_3, PIXEL02_4, PIXEL12_3
	PIXEL10_1
	PIXEL11
	PIXEL20_1M
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag216:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	PIXEL20_1M
	DiffOrNot w6, w8, PIXEL12_C, PIXEL21_C, PIXEL22_C, PIXEL12_3, PIXEL21_3, PIXEL22_4
	jmp .LoopX_end

..@flag106:
	PIXEL00_1M
	PIXEL01_C
	PIXEL02_1M
	PIXEL11
	PIXEL12_1
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL21_C, PIXEL10_3, PIXEL20_4, PIXEL21_3
	PIXEL22_1M
	jmp .LoopX_end

..@flag30:
	PIXEL00_1M
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL12_C, PIXEL01_3, PIXEL02_4, PIXEL12_3
	PIXEL10_C
	PIXEL11
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag210:
	PIXEL00_1M
	PIXEL01_C
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL20_1M
	DiffOrNot w6, w8, PIXEL12_C, PIXEL21_C, PIXEL22_C, PIXEL12_3, PIXEL21_3, PIXEL22_4
	jmp .LoopX_end

..@flag120:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_1M
	PIXEL11
	PIXEL12_C
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL21_C, PIXEL10_3, PIXEL20_4, PIXEL21_3
	PIXEL22_1M
	jmp .LoopX_end

..@flag75:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL10_C, PIXEL00_4, PIXEL01_3, PIXEL10_3
	PIXEL02_1M
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag29:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag198:
	PIXEL00_1M
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag184:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag99:
	PIXEL00_1L
	PIXEL01_C
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1L
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag57:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag71:
	PIXEL00_1L
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag156:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag226:
	PIXEL00_1M
	PIXEL01_C
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1L
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag60:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag195:
	PIXEL00_1L
	PIXEL01_C
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag102:
	PIXEL00_1M
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1L
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag153:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag58:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL00_2
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_1M, PIXEL02_2
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag83:
	PIXEL00_1L
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_1M, PIXEL02_2
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_1M, PIXEL22_2
	jmp .LoopX_end

..@flag92:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	DiffOrNot w8, w4, PIXEL20_1M, PIXEL20_2
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_1M, PIXEL22_2
	jmp .LoopX_end

..@flag202:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL00_2
	PIXEL01_C
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	DiffOrNot w8, w4, PIXEL20_1M, PIXEL20_2
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag78:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL00_2
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	DiffOrNot w8, w4, PIXEL20_1M, PIXEL20_2
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag154:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL00_2
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_1M, PIXEL02_2
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag114:
	PIXEL00_1M
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_1M, PIXEL02_2
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_1L
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_1M, PIXEL22_2
	jmp .LoopX_end

..@flag89:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	DiffOrNot w8, w4, PIXEL20_1M, PIXEL20_2
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_1M, PIXEL22_2
	jmp .LoopX_end

..@flag90:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL00_2
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_1M, PIXEL02_2
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	DiffOrNot w8, w4, PIXEL20_1M, PIXEL20_2
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_1M, PIXEL22_2
	jmp .LoopX_end

..@flag55:
..@flag23:
	DiffOrNot w2, w6, PIXEL00_1L, PIXEL01_C, PIXEL02_C, PIXEL12_C, PIXEL00_2, PIXEL01_6, PIXEL02_5, PIXEL12_1
	PIXEL10_1
	PIXEL11
	PIXEL20_2
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag182:
..@flag150:
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL12_C, PIXEL22_1D, PIXEL01_1, PIXEL02_5, PIXEL12_6, PIXEL22_2
	PIXEL00_1M
	PIXEL10_1
	PIXEL11
	PIXEL20_2
	PIXEL21_1
	jmp .LoopX_end

..@flag213:
..@flag212:
	DiffOrNot w6, w8, PIXEL02_1U, PIXEL12_C, PIXEL21_C, PIXEL22_C, PIXEL02_2, PIXEL12_6, PIXEL21_1, PIXEL22_5
	PIXEL00_2
	PIXEL01_1
	PIXEL10_1
	PIXEL11
	PIXEL20_1M
	jmp .LoopX_end

..@flag241:
..@flag240:
	DiffOrNot w6, w8, PIXEL12_C, PIXEL20_1L, PIXEL21_C, PIXEL22_C, PIXEL12_1, PIXEL20_2, PIXEL21_6, PIXEL22_5
	PIXEL00_2
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	jmp .LoopX_end

..@flag236:
..@flag232:
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL21_C, PIXEL22_1R, PIXEL10_1, PIXEL20_5, PIXEL21_6, PIXEL22_2
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_2
	PIXEL11
	PIXEL12_1
	jmp .LoopX_end

..@flag109:
..@flag105:
	DiffOrNot w8, w4, PIXEL00_1U, PIXEL10_C, PIXEL20_C, PIXEL21_C, PIXEL00_2, PIXEL10_6, PIXEL20_5, PIXEL21_1
	PIXEL01_1
	PIXEL02_2
	PIXEL11
	PIXEL12_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag171:
..@flag43:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL10_C, PIXEL20_1D, PIXEL00_5, PIXEL01_1, PIXEL10_6, PIXEL20_2
	PIXEL02_1M
	PIXEL11
	PIXEL12_1
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag143:
..@flag15:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL02_1R, PIXEL10_C, PIXEL00_5, PIXEL01_6, PIXEL02_2, PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag124:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_1U
	PIXEL11
	PIXEL12_C
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL21_C, PIXEL10_3, PIXEL20_4, PIXEL21_3
	PIXEL22_1M
	jmp .LoopX_end

..@flag203:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL10_C, PIXEL00_4, PIXEL01_3, PIXEL10_3
	PIXEL02_1M
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag62:
	PIXEL00_1M
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL12_C, PIXEL01_3, PIXEL02_4, PIXEL12_3
	PIXEL10_C
	PIXEL11
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag211:
	PIXEL00_1L
	PIXEL01_C
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL20_1M
	DiffOrNot w6, w8, PIXEL12_C, PIXEL21_C, PIXEL22_C, PIXEL12_3, PIXEL21_3, PIXEL22_4
	jmp .LoopX_end

..@flag118:
	PIXEL00_1M
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL12_C, PIXEL01_3, PIXEL02_4, PIXEL12_3
	PIXEL10_1
	PIXEL11
	PIXEL20_1L
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag217:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	PIXEL20_1M
	DiffOrNot w6, w8, PIXEL12_C, PIXEL21_C, PIXEL22_C, PIXEL12_3, PIXEL21_3, PIXEL22_4
	jmp .LoopX_end

..@flag110:
	PIXEL00_1M
	PIXEL01_C
	PIXEL02_1R
	PIXEL11
	PIXEL12_1
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL21_C, PIXEL10_3, PIXEL20_4, PIXEL21_3
	PIXEL22_1M
	jmp .LoopX_end

..@flag155:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL10_C, PIXEL00_4, PIXEL01_3, PIXEL10_3
	PIXEL02_1M
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag188:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag185:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag61:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag157:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag103:
	PIXEL00_1L
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1L
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag227:
	PIXEL00_1L
	PIXEL01_C
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1L
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag230:
	PIXEL00_1M
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1L
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag199:
	PIXEL00_1L
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag220:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_C
	PIXEL11
	DiffOrNot w8, w4, PIXEL20_1M, PIXEL20_2
	DiffOrNot w6, w8, PIXEL12_C, PIXEL21_C, PIXEL22_C, PIXEL12_3, PIXEL21_3, PIXEL22_4
	jmp .LoopX_end

..@flag158:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL00_2
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL12_C, PIXEL01_3, PIXEL02_4, PIXEL12_3
	PIXEL10_C
	PIXEL11
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag234:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL00_2
	PIXEL01_C
	PIXEL02_1M
	PIXEL11
	PIXEL12_1
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL21_C, PIXEL10_3, PIXEL20_4, PIXEL21_3
	PIXEL22_1R
	jmp .LoopX_end

..@flag242:
	PIXEL00_1M
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_1M, PIXEL02_2
	PIXEL10_1
	PIXEL11
	PIXEL20_1L
	DiffOrNot w6, w8, PIXEL12_C, PIXEL21_C, PIXEL22_C, PIXEL12_3, PIXEL21_3, PIXEL22_4
	jmp .LoopX_end

..@flag59:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL10_C, PIXEL00_4, PIXEL01_3, PIXEL10_3
	DiffOrNot w2, w6, PIXEL02_1M, PIXEL02_2
	PIXEL11
	PIXEL12_C
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag121:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_1M
	PIXEL11
	PIXEL12_C
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL21_C, PIXEL10_3, PIXEL20_4, PIXEL21_3
	DiffOrNot w6, w8, PIXEL22_1M, PIXEL22_2
	jmp .LoopX_end

..@flag87:
	PIXEL00_1L
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL12_C, PIXEL01_3, PIXEL02_4, PIXEL12_3
	PIXEL10_1
	PIXEL11
	PIXEL20_1M
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_1M, PIXEL22_2
	jmp .LoopX_end

..@flag79:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL10_C, PIXEL00_4, PIXEL01_3, PIXEL10_3
	PIXEL02_1R
	PIXEL11
	PIXEL12_1
	DiffOrNot w8, w4, PIXEL20_1M, PIXEL20_2
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag122:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL00_2
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_1M, PIXEL02_2
	PIXEL11
	PIXEL12_C
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL21_C, PIXEL10_3, PIXEL20_4, PIXEL21_3
	DiffOrNot w6, w8, PIXEL22_1M, PIXEL22_2
	jmp .LoopX_end

..@flag94:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL00_2
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL12_C, PIXEL01_3, PIXEL02_4, PIXEL12_3
	PIXEL10_C
	PIXEL11
	DiffOrNot w8, w4, PIXEL20_1M, PIXEL20_2
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_1M, PIXEL22_2
	jmp .LoopX_end

..@flag218:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL00_2
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_1M, PIXEL02_2
	PIXEL10_C
	PIXEL11
	DiffOrNot w8, w4, PIXEL20_1M, PIXEL20_2
	DiffOrNot w6, w8, PIXEL12_C, PIXEL21_C, PIXEL22_C, PIXEL12_3, PIXEL21_3, PIXEL22_4
	jmp .LoopX_end

..@flag91:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL10_C, PIXEL00_4, PIXEL01_3, PIXEL10_3
	DiffOrNot w2, w6, PIXEL02_1M, PIXEL02_2
	PIXEL11
	PIXEL12_C
	DiffOrNot w8, w4, PIXEL20_1M, PIXEL20_2
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_1M, PIXEL22_2
	jmp .LoopX_end

..@flag229:
	PIXEL00_2
	PIXEL01_1
	PIXEL02_2
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1L
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag167:
	PIXEL00_1L
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_2
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag173:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_2
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag181:
	PIXEL00_2
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_2
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag186:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL00_2
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_1M, PIXEL02_2
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag115:
	PIXEL00_1L
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_1M, PIXEL02_2
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_1L
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_1M, PIXEL22_2
	jmp .LoopX_end

..@flag93:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	DiffOrNot w8, w4, PIXEL20_1M, PIXEL20_2
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_1M, PIXEL22_2
	jmp .LoopX_end

..@flag206:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL00_2
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	DiffOrNot w8, w4, PIXEL20_1M, PIXEL20_2
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag205:
..@flag201:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_2
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	DiffOrNot w8, w4, PIXEL20_1M, PIXEL20_2
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag174:
..@flag46:
	DiffOrNot w4, w2, PIXEL00_1M, PIXEL00_2
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag179:
..@flag147:
	PIXEL00_1L
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_1M, PIXEL02_2
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_2
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag117:
..@flag116:
	PIXEL00_2
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_1L
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_1M, PIXEL22_2
	jmp .LoopX_end

..@flag189:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag231:
	PIXEL00_1L
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1L
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag126:
	PIXEL00_1M
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL12_C, PIXEL01_3, PIXEL02_4, PIXEL12_3
	PIXEL11
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL21_C, PIXEL10_3, PIXEL20_4, PIXEL21_3
	PIXEL22_1M
	jmp .LoopX_end

..@flag219:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL10_C, PIXEL00_4, PIXEL01_3, PIXEL10_3
	PIXEL02_1M
	PIXEL11
	PIXEL20_1M
	DiffOrNot w6, w8, PIXEL12_C, PIXEL21_C, PIXEL22_C, PIXEL12_3, PIXEL21_3, PIXEL22_4
	jmp .LoopX_end

..@flag125:
	DiffOrNot w8, w4, PIXEL00_1U, PIXEL10_C, PIXEL20_C, PIXEL21_C, PIXEL00_2, PIXEL10_6, PIXEL20_5, PIXEL21_1
	PIXEL01_1
	PIXEL02_1U
	PIXEL11
	PIXEL12_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag221:
	DiffOrNot w6, w8, PIXEL02_1U, PIXEL12_C, PIXEL21_C, PIXEL22_C, PIXEL02_2, PIXEL12_6, PIXEL21_1, PIXEL22_5
	PIXEL00_1U
	PIXEL01_1
	PIXEL10_C
	PIXEL11
	PIXEL20_1M
	jmp .LoopX_end

..@flag207:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL02_1R, PIXEL10_C, PIXEL00_5, PIXEL01_6, PIXEL02_2, PIXEL10_1
	PIXEL11
	PIXEL12_1
	PIXEL20_1M
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag238:
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL21_C, PIXEL22_1R, PIXEL10_1, PIXEL20_5, PIXEL21_6, PIXEL22_2
	PIXEL00_1M
	PIXEL01_C
	PIXEL02_1R
	PIXEL11
	PIXEL12_1
	jmp .LoopX_end

..@flag190:
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL12_C, PIXEL22_1D, PIXEL01_1, PIXEL02_5, PIXEL12_6, PIXEL22_2
	PIXEL00_1M
	PIXEL10_C
	PIXEL11
	PIXEL20_1D
	PIXEL21_1
	jmp .LoopX_end

..@flag187:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL10_C, PIXEL20_1D, PIXEL00_5, PIXEL01_1, PIXEL10_6, PIXEL20_2
	PIXEL02_1M
	PIXEL11
	PIXEL12_C
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag243:
	DiffOrNot w6, w8, PIXEL12_C, PIXEL20_1L, PIXEL21_C, PIXEL22_C, PIXEL12_1, PIXEL20_2, PIXEL21_6, PIXEL22_5
	PIXEL00_1L
	PIXEL01_C
	PIXEL02_1M
	PIXEL10_1
	PIXEL11
	jmp .LoopX_end

..@flag119:
	DiffOrNot w2, w6, PIXEL00_1L, PIXEL01_C, PIXEL02_C, PIXEL12_C, PIXEL00_2, PIXEL01_6, PIXEL02_5, PIXEL12_1
	PIXEL10_1
	PIXEL11
	PIXEL20_1L
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag237:
..@flag233:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_2
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	DiffOrNot w8, w4, PIXEL20_C, PIXEL20_2
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag175:
..@flag47:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL00_2
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_2
	jmp .LoopX_end

..@flag183:
..@flag151:
	PIXEL00_1L
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_C, PIXEL02_2
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_2
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag245:
..@flag244:
	PIXEL00_2
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_1L
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_C, PIXEL22_2
	jmp .LoopX_end

..@flag250:
	PIXEL00_1M
	PIXEL01_C
	PIXEL02_1M
	PIXEL11
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL10_3, PIXEL20_4
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL12_C, PIXEL22_C, PIXEL12_3, PIXEL22_4
	jmp .LoopX_end

..@flag123:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL00_4, PIXEL01_3
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	DiffOrNot w8, w4, PIXEL20_C, PIXEL21_C, PIXEL20_4, PIXEL21_3
	PIXEL22_1M
	jmp .LoopX_end

..@flag95:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL10_C, PIXEL00_4, PIXEL10_3
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_C, PIXEL12_C, PIXEL02_4, PIXEL12_3
	PIXEL11
	PIXEL20_1M
	PIXEL21_C
	PIXEL22_1M
	jmp .LoopX_end

..@flag222:
	PIXEL00_1M
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL01_3, PIXEL02_4
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	DiffOrNot w6, w8, PIXEL21_C, PIXEL22_C, PIXEL21_3, PIXEL22_4
	jmp .LoopX_end

..@flag252:
	PIXEL00_1M
	PIXEL01_1
	PIXEL02_1U
	PIXEL11
	PIXEL12_C
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL10_3, PIXEL20_4
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_C, PIXEL22_2
	jmp .LoopX_end

..@flag249:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	DiffOrNot w8, w4, PIXEL20_C, PIXEL20_2
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL12_C, PIXEL22_C, PIXEL12_3, PIXEL22_4
	jmp .LoopX_end

..@flag235:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL00_4, PIXEL01_3
	PIXEL02_1M
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	DiffOrNot w8, w4, PIXEL20_C, PIXEL20_2
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag111:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL00_2
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	DiffOrNot w8, w4, PIXEL20_C, PIXEL21_C, PIXEL20_4, PIXEL21_3
	PIXEL22_1M
	jmp .LoopX_end

..@flag63:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL00_2
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_C, PIXEL12_C, PIXEL02_4, PIXEL12_3
	PIXEL10_C
	PIXEL11
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_1M
	jmp .LoopX_end

..@flag159:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL10_C, PIXEL00_4, PIXEL10_3
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_C, PIXEL02_2
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag215:
	PIXEL00_1L
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_C, PIXEL02_2
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_1M
	DiffOrNot w6, w8, PIXEL21_C, PIXEL22_C, PIXEL21_3, PIXEL22_4
	jmp .LoopX_end

..@flag246:
	PIXEL00_1M
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL01_3, PIXEL02_4
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_1L
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_C, PIXEL22_2
	jmp .LoopX_end

..@flag254:
	PIXEL00_1M
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL01_3, PIXEL02_4
	PIXEL11
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL10_3, PIXEL20_4
	DiffOrNot w6, w8, PIXEL12_C, PIXEL21_C, PIXEL22_C, PIXEL12_3, PIXEL21_3, PIXEL22_2
	jmp .LoopX_end

..@flag253:
	PIXEL00_1U
	PIXEL01_1
	PIXEL02_1U
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	DiffOrNot w8, w4, PIXEL20_C, PIXEL20_2
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_C, PIXEL22_2
	jmp .LoopX_end

..@flag251:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL00_4, PIXEL01_3
	PIXEL02_1M
	PIXEL11
	DiffOrNot w8, w4, PIXEL10_C, PIXEL20_C, PIXEL21_C, PIXEL10_3, PIXEL20_2, PIXEL21_3
	DiffOrNot w6, w8, PIXEL12_C, PIXEL22_C, PIXEL12_3, PIXEL22_4
	jmp .LoopX_end

..@flag239:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL00_2
	PIXEL01_C
	PIXEL02_1R
	PIXEL10_C
	PIXEL11
	PIXEL12_1
	DiffOrNot w8, w4, PIXEL20_C, PIXEL20_2
	PIXEL21_C
	PIXEL22_1R
	jmp .LoopX_end

..@flag127:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL01_C, PIXEL10_C, PIXEL00_2, PIXEL01_3, PIXEL10_3
	DiffOrNot w2, w6, PIXEL02_C, PIXEL12_C, PIXEL02_4, PIXEL12_3
	PIXEL11
	DiffOrNot w8, w4, PIXEL20_C, PIXEL21_C, PIXEL20_4, PIXEL21_3
	PIXEL22_1M
	jmp .LoopX_end

..@flag191:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL00_2
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_C, PIXEL02_2
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	PIXEL20_1D
	PIXEL21_1
	PIXEL22_1D
	jmp .LoopX_end

..@flag223:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL10_C, PIXEL00_4, PIXEL10_3
	DiffOrNot w2, w6, PIXEL01_C, PIXEL02_C, PIXEL12_C, PIXEL01_3, PIXEL02_2, PIXEL12_3
	PIXEL11
	PIXEL20_1M
	DiffOrNot w6, w8, PIXEL21_C, PIXEL22_C, PIXEL21_3, PIXEL22_4
	jmp .LoopX_end

..@flag247:
	PIXEL00_1L
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_C, PIXEL02_2
	PIXEL10_1
	PIXEL11
	PIXEL12_C
	PIXEL20_1L
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_C, PIXEL22_2
	jmp .LoopX_end

..@flag255:
	DiffOrNot w4, w2, PIXEL00_C, PIXEL00_2
	PIXEL01_C
	DiffOrNot w2, w6, PIXEL02_C, PIXEL02_2
	PIXEL10_C
	PIXEL11
	PIXEL12_C
	DiffOrNot w8, w4, PIXEL20_C, PIXEL20_2
	PIXEL21_C
	DiffOrNot w6, w8, PIXEL22_C, PIXEL22_2
	jmp .LoopX_end


..@cross0:
	mov	edx, eax
	shl	eax, 16
	or	eax, edx
	mov	[edi], eax
	mov	[edi + 4], ax
	mov	[edi + ebx], eax
	mov	[edi + ebx + 4], ax
	mov	[edi + ebx * 2], eax
	mov	[edi + ebx * 2 + 4], ax
	jmp	.LoopX_end

..@cross1:
	mov	edx, eax
	shl	eax, 16
	or	eax, edx
	mov	ecx, [w2]
	and	edx, [zerolowbits]
	and	ecx, [zerolowbits]
	add	ecx, edx
	shr	ecx, 1
	add	ecx,0x0821
	and	ecx, [zerolowbits]
	add	edx, ecx
	shr	edx, 1
	mov	[edi], dx
	mov	[edi + 2], dx
	mov	[edi + 4], dx
	mov	[edi + ebx], eax
	mov	[edi + ebx + 4], ax
	mov	[edi + ebx * 2], eax
	mov	[edi + ebx * 2 + 4], ax
	jmp	.LoopX_end

..@cross2:
	mov	edx, eax
	shl	eax, 16
	or	eax, edx
	mov	ecx, [w4]
	and	edx, [zerolowbits]
	and	ecx, [zerolowbits]
	add	ecx, edx
	shr	ecx, 1
	add	ecx,0x0821
	and	ecx, [zerolowbits]
	add	edx, ecx
	shr	edx, 1
	mov	[edi], dx
	mov	[edi + 2], eax
	mov	[edi + ebx], dx
	mov	[edi + ebx + 2], eax
	mov	[edi + ebx * 2], dx
	mov	[edi + ebx * 2 + 2], eax
	jmp	.LoopX_end

..@cross4:
	mov	edx, eax
	shl	eax, 16
	or	eax, edx
	mov	ecx, [w6]
	and	edx, [zerolowbits]
	and	ecx, [zerolowbits]
	add	ecx, edx
	shr	ecx, 1
	add	ecx,0x0821
	and	ecx, [zerolowbits]
	add	edx, ecx
	shr	edx, 1
	mov	[edi], eax
	mov	[edi + 4], dx
	mov	[edi + ebx], eax
	mov	[edi + ebx + 4], dx
	mov	[edi + ebx * 2], eax
	mov	[edi + ebx * 2 + 4], dx
	jmp	.LoopX_end

..@cross8:
	mov	edx, eax
	shl	eax, 16
	or	eax, edx
	mov	ecx, [w8]
	and	edx, [zerolowbits]
	and	ecx, [zerolowbits]
	add	ecx, edx
	shr	ecx, 1
	add	ecx,0x0821
	and	ecx, [zerolowbits]
	add	edx, ecx
	shr	edx, 1
	mov	[edi], eax
	mov	[edi + 4], ax
	mov	[edi + ebx], eax
	mov	[edi + ebx + 4], ax
	mov	[edi + ebx * 2], dx
	mov	[edi + ebx * 2 + 2], dx
	mov	[edi + ebx * 2 + 4], dx
	jmp	.LoopX_end


.LoopX_end:
	add	esi, 2
	add	edi, 6
	dec	dword [xcounter]
	jle	.xres_2
	jmp	.LoopX
	
.xres_2:
	; x=Xres-2 - special case
	jl	.xres_1
	mov	ebx, [prevline]
	movq	mm5, [esi + ebx-4]
	movq	mm6, [esi-4]
	mov	ebx, [nextline]
	movq	mm7, [esi + ebx-4]
	psrlq	mm5, 16
	psrlq	mm6, 16
	psrlq	mm7, 16
	movd	eax, mm5
	movzx	edx, ax
	mov	[w1], edx
	shr	eax, 16
	mov	[w2], eax
	psrlq	mm5, 32
	movd	eax, mm5
	mov	[w3], eax
	movd	eax, mm6
	movzx	edx, ax
	mov	[w4], edx
	shr	eax, 16
	mov	[w5], eax
	psrlq	mm6, 32
	movd	eax, mm6
	mov	[w6], eax
	movd	eax, mm7
	movzx	edx, ax
	mov	[w7], edx
	shr	eax, 16
	mov	[w8], eax
	psrlq	mm7, 32
	movd	eax, mm7
	mov	[w9], eax
	jmp	.flags
	
.xres_1:
	cmp	dword [xcounter], -1
	jl	.NextY
	; x=Xres-1 - special case
	mov	ebx, [prevline]
	movq	mm5, [esi + ebx-6]
	movq	mm6, [esi-6]
	mov	ebx, [nextline]
	movq	mm7, [esi + ebx-6]
	psrlq	mm5, 32
	psrlq	mm6, 32
	psrlq	mm7, 32
	movd	eax, mm5
	movzx	edx, ax  
	mov	[w1], edx
	shr	eax, 16
	mov	[w2], eax
	mov	[w3], eax
	movd	eax, mm6
	movzx	edx, ax  
	mov	[w4], edx
	shr	eax, 16
	mov	[w5], eax
	mov	[w6], eax
	movd	eax, mm7
	movzx	edx, ax  
	mov	[w7], edx
	shr	eax, 16
	mov	[w8], eax
	mov	[w9], eax
	jmp	.flags
	
.NextY:
	add	esi, [ebp + arg_srcPitch] ; MDP: Add the source pitch difference.
	add	edi, ebx
	add	edi, ebx
	
	; MDP: Add the difference between the pitch and the source width.
	add	edi, [ebp + loc_calcPitchDiff]
	
	dec	dword [linesleft]
	jz	.fin
	mov	ebx, [ebp + arg_width]
	shl	ebx, 1
	
	; MDP: Add the source pitch difference to the destination buffer.
	add	ebx, [ebp + arg_srcPitch]
	
	cmp     dword [linesleft], 1
	je      .lastline
	mov     dword [nextline], ebx
	neg     ebx
	mov     dword [prevline], ebx
	jmp     .LoopY
	
.lastline:
	mov	dword [nextline], 0
	neg	ebx
	mov	dword [prevline], ebx
	jmp	.LoopY
	
.fin:
	; Reset the frame pointer.
	popad
	mov	esp, ebp
	pop	ebp
	emms
	ret
