#!/bin/bash
#
# packager                          : Frederic Boulet <bipbip> bipbiponlinux~AT~gmail.com
#
# dernières révisions       : 21/02/2009
#
# package			: adesklets
# homepage			: http://adesklets.sourceforge.net/
# source location	: http://freefr.dl.sourceforge.net/sourceforge/adesklets/adesklets-0.6.1.tar.bz2
# dependency        : 

softname='adesklets'
softversion='0.6.1'
packageversion='1rl'

#
# ZenWalk standard: type CPUet architecture
#
# arch='i486' -> le compileur utilise seulement les instructions 80486
# cpu='i686'  -> optimisation faîte pour PII et >
#
arch='i486'
cpu='i686'

#
# destination du package
#
prefix=/usr

#
# log
#
(

#
# building-computer dependent: the number of parallel 'jobs' of 'make'
#
# "gros" PC: 6 compilations à la fois
#
# numjobs='-j6'
#
# "léger" PC: 2 compilations à la fois
#
numjobs='-j2'

#
# paramètres pour compiler
#
buildir=$(pwd)
src="$buildir/$softname-$softversion"
srcpkg="$buildir/$softname-$softversion.tar.bz2"
package="$softname-$softversion-$arch-$packageversion"
dest="$buildir/$package"
source=http://freefr.dl.sourceforge.net/sourceforge/adesklets/$softname/$softname-$softversion.tar.bz2

#
# preparer le répertoire qui accueillera la compilation
#
rm -rf $dest
mkdir -p $dest
mkdir -p $dest/install
mkdir -p $dest/$prefix/bin
mkdir -p $dest/usr/doc
mkdir -p $dest/usr/src/$softname-$softversion

#
# mettre le slack-desc en place. 
#
cat <<EOF > $dest/install/slack-desc 
         |-----handy-ruler------------------------------------------------------|
adesklets: aDesklets - An interactive Imlib2 console for the X Window System
adesklets:
adesklets: It provides to scripted languages a clean and simple way to write 
adesklets: great looking, mildly interactive desktop integrated graphic 
adesklets: applets (aka "desklets"). 
adesklets:
adesklets:
adesklets:
adesklets:
adesklets: 
adesklets:
EOF

#
# Verifie si package est present
#
if [ -f $softname-$softversion.tar.bz2 ]; then
	echo "Source file already here, no need to download";
else
 	echo "Downloading source"
	wget -c --no-check-certificate $source
fi

#
# extraire les sources
#
# tar.gz : tar zxvf $srcpkg
# tar.bz2: tar xjvf $srcpkg
# tgz    : tar xzvf $srcpkg
#
cd $buildir
tar xjvf $srcpkg
cd $src	

#
# "faire" le package package
#
patch -p1 < ../fontconfig-2.4.patch
autoreconf

export CFLAGS="-O2 -march=$arch -mtune=$cpu"
export CXXFLAGS="-O2 -march=$arch -mtune=$cpu"
   
./configure \
	--program-prefix="" \
	--program-suffix="" \
	--prefix="/usr" \
	--sysconfdir="/etc" \
	--localstatedir="/var" \
	--mandir="/usr/man" \
	--infodir="/usr/info" \
	--localedir="/usr/share/locale" \
	--enable-static="no" \
	--enable-shared="yes" \
	--build=$arch-slackware-linux || exit

#
# "faire" le package package
#
make $numjobs DESTDIR=$dest

#
# installer le package dans son répertoire de destination
#
make install DESTDIR=$dest

#
# ajout des fichiers de docs, infos, ...
#
	cd $src
    mkdir -p $dest/usr/doc/$softname-$softversion
    cp -a \
      AUTHORS COPYING ChangeLog INSTALL NEWS README TODO\
      $dest/usr/doc/$softname-$softversion
	
#
# Stripper les éxécutables
# (Commenter ces lignes si besoin d'infos de débuggage)
#
( cd $dest
  find . | xargs file | grep "executable" | grep ELF | cut -f 1 -d : | xargs strip --strip-unneeded 2> /dev/null
  find . | xargs file | grep "shared object" | grep ELF | cut -f 1 -d : | xargs strip --strip-unneeded 2> /dev/null
)

#
# Compresser les pages Man
#
( mv $dest/usr/share/man $dest/usr
  cd $dest/$prefix/man
  find . -name "*.?" | xargs gzip -9
)

#
# Mettre le zenbuild à sa place
#
cd $buildir
cp build-$softname.sh $dest/$prefix/src/$softname-$softversion
cp fontconfig-2.4.patch $dest/$prefix/src/$softname-$softversion

#
# fixer les permissions
#
chown -R root.root $dest

cd $dest
find . -perm 664 -exec chmod 644 {} \;
find . -perm 600 -exec chmod 644 {} \;
find . -perm 444 -exec chmod 644 {} \;
find . -perm 400 -exec chmod 644 {} \;
find . -perm 440 -exec chmod 644 {} \;
find . -perm 777 -exec chmod 755 {} \;
find . -perm 775 -exec chmod 755 {} \;
find . -perm 511 -exec chmod 755 {} \;
find . -perm 711 -exec chmod 755 {} \;
find . -perm 555 -exec chmod 755 {} \;

#
# fabriquer le zenpackage
#
cd $dest
makepkg -l y -c n $dest.tgz

#
# produire la signature md5 du package
#
cd $buildir
md5sum $package.tgz > $package.md5

#
# produire le fichier .dep
#
cd $buildir
echo -e "expat,fontconfig,freetype,imlib2,ncurses,perl,python,readline,xorg,zlib" > $package.dep

#
# produire le fichier src
#
echo http://people.salixos.org/laprjns/adesklets/0.6.1/build-adeskslets.sh > $package.src
echo http://people.salixos.org/laprjns/adesklets/0.6.1/fontconfig-2.4.patch >> $package.src
echo $source >> $package.src

#
# supprimer source
#
rm -rf $src
rm -rf $dest

#
# log
#
) 2>&1 | tee "$softname-$softversion-build.log"
