/***************************************************************************
                          resource.h  -  description                              
                             -------------------                                         
    begin                : ven jun 11 17:07:02 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux                         
    email                : fdupoux@lemel.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef RESSOURCE_H
#define RESSOURCE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

///////////////////////////////////////////////////////////////////
// resource.h  -- contains macros used for commands


///////////////////////////////////////////////////////////////////
// COMMAND VALUES FOR MENUBAR AND TOOLBAR ENTRIES


///////////////////////////////////////////////////////////////////
// File-menu entries
#define ID_FILE_NEW_WINDOW          10010
#define ID_FILE_REPLACE             10020
#define ID_FILE_CLOSE               10030
#define ID_FILE_CLOSE_WINDOW        10040
#define ID_FILE_QUIT                10050
#define ID_FILE_INFO                10060
#define ID_FILE_OPEN                10070
#define ID_FILE_DELETE              10080
#define ID_FILE_DIROPEN             10090
#define ID_FILE_STOP                10100
#define ID_FILE_SAVE                10110

///////////////////////////////////////////////////////////////////
// View-menu entries                    
#define ID_VIEW_TOOLBAR             12010
#define ID_VIEW_STATUSBAR           12020
#define ID_VIEW_OPTIONS             12030

///////////////////////////////////////////////////////////////////
// Help-menu entries
#define ID_HELP                     13000
#define ID_HELP_WEBSITE             13010
#define ID_HELP_ABOUT               13020

///////////////////////////////////////////////////////////////////
// General application values
#define ID_STATUS_MSG               1001

#define IDS_DEFAULT                 "Ready."

#define TAB_FILES                   0
#define TAB_TEXT                    1
#define TAB_DATESIZE                2
#define TAB_OPTIONS                 3


#define MAX_MESSAGE                 128
#define MAX_TEXTLEN                 256
#define MAX_STRINGSINCOMBO          10
#define MAX_STRINGSTOSEARCHREP      256

///////////////////////////////////////////////////////////////////
// MACROS FOR THE CONNECT OF YOUR SIGNALS TO CORRESPONDENT SLOTS 
// IN YOUR MAIN IMPLEMENTATION OF MENUBAR AND TOOLBAR


///////////////////////////////////////////////////////////////////
// MENU CONNECTS
#define CONNECT_CMD(submenu)           connect(submenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));connect(submenu,SIGNAL(highlighted(int)), SLOT(statusCallback(int)))


///////////////////////////////////////////////////////////////////
// TOOLBAR CONNECT  
#define CONNECT_TOOLBAR(ToolBar)        connect(ToolBar, SIGNAL(clicked(int)), SLOT(commandCallback(int)));connect(ToolBar, SIGNAL(highlighted(int,bool)), SLOT(statusCallback(int)))

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them with their functions
#define ON_CMD(id, cmd_class_function)   case id:cmd_class_function ;break;

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them to change statusBar entry
#define ON_STATUS_MSG(id, message)     case id:  slotStatusHelpMsg(message);break;

#endif // RESOURCE_H












