/***************************************************************************
                          kfilereplacedoc.cpp  -  description
                             -------------------
    begin                : ven jun 11 17:07:02 CEST 1999

    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@lemel.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <kfilereplacedoc.h>
#include <kfilereplaceview.h>
#include "kfilereplace.h"
#include "repdirargu.h"

#include <qdir.h>
#include <qfileinfo.h>
#include <qstring.h>
#include <qdatetime.h>
#include <qregexp.h>

#include <kmsgbox.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/vfs.h>
#include <sys/stat.h>
#include <errno.h>
#include <ctype.h>


// ===========================================================================================================================
KFileReplaceDoc::KFileReplaceDoc(QObject *parent, const char *filename):QObject(parent)
{	m_parent = parent;

}

// ===========================================================================================================================
KFileReplaceDoc::~KFileReplaceDoc()
{
}

// ===========================================================================================================================
void *ReplaceThread(void *param)
{	int nRes;
	RepDirArg *argu;
	argu = (RepDirArg *) param;

	g_bThreadRunning = true;

	// Call another function to make easier to verify Thread Variables
	nRes = ReplaceDirectory(argu -> szDir, argu);

	// The thread always finished here: success or error
	g_nFilesRep = nRes; // Number of replaced files
	g_bThreadRunning = false;

  if (nRes == -1) // Error
	{	pthread_exit(0);
		return 0;
	}
	else // Success
	{	pthread_exit(nRes);
		return 0;
	}
}

// ===========================================================================================================================
int ReplaceDirectory(char *szDir, RepDirArg* argu)
{ 	char szFileReadpath[MAXPATHLEN];
	char szFileWritepath[MAXPATHLEN];
	char szDirpath[MAXPATHLEN];
	char szBakup[MAXPATHLEN];
	char szTemp[MAXPATHLEN];
	char szMess[MAX_MESSAGE];
	uint nNewFileSize;
	QDir dir;
	QFileInfo fi;
	int nRes;
	int i;
	int nNbRepFiles = 0;
	bool bNeedReplace; // Total Nb Rep made in the current function
	int nNbReplacements; // Nb Rep made in a call to ReplaceFile
	uint nDiskFreeSpace;

	KFileReplaceApp *app;
	app = (KFileReplaceApp *) (argu -> app);

	// 0. -*-*-*-*-*-*-*-*-*- Check it's a valid directory -*-*-*-*-*-*-*-*-*-
	if (!dir.isReadable() || !dir.exists())
	{	sprintf (szMess, i18n("Can't access to directory %s"), szDir);
		app -> slotStatusMsg(szMess);
		//KMsgBox::message(view, "KFileReplace", szMess, KMsgBox::EXCLAMATION, i18n("Cancel"));	
		return -1;
	}
	
	// 1. -*-*-*-*-*-*-*-*-*- First, list all files -*-*-*-*-*-*-*-*-*-

	// What type of files we must lis
	dir.setFilter(QDir::Files | QDir::Readable | QDir::Writable);
	dir.setPath(szDir);
	dir.setNameFilter(argu -> szFilter);

	// If directory doesn't exists
	if (!dir.exists())
		return -1;

	for (i=0; i < dir.count(); i++)
	{
    		// Check the Thread needn't to stop
		if (g_bThreadMustStop == true)
		{ return -1;
		}

		sprintf (szFileWritepath, "%s/%s.new", szDir, dir[i]);
		sprintf (szFileReadpath, "%s/%s", szDir, dir[i]);

		// Check the file is not a .OLD (Bakup) file
	 	strcpy(szTemp, dir[i]+strlen(dir[i])-4);

    		// if the file dates & size are correct for options
		if (strcmp(szTemp, ".old") != 0 && IsFileGoodSizeProperties(szFileReadpath, argu -> bMinSize, argu -> bMaxSize, argu -> nMinSize, argu -> nMaxSize)
    		&& ((argu -> bDateOptionChecked == false) || (IsFileGoodDateProperties(szFileReadpath, argu -> nTypeOfAccess, argu -> bMinDate, argu -> bMaxDate, argu -> qdMinDate, argu -> qdMaxDate))))
		{
			// Get Number of occurrences in Old File
			nRes = DoesFileNeedReplace(szFileReadpath, &bNeedReplace, argu);
			//nRes = PrepareReplace(szFileReadpath, &nNewFileSize, &bNeedReplace, argu);
  			if (nRes == -1)
				return -1;

			if (bNeedReplace) // Replace only if there are occurrences
			{	
				// Check there is enought free disk space
				nRes = GetDiskFreeSpaceForFile(&nDiskFreeSpace, szFileWritepath);
				if (nRes != -1 && nDiskFreeSpace < nNewFileSize)
				{	sprintf (szMess, i18n("There is not enought disk free space to replace in the file %s."), szFileWritepath);
					app -> slotStatusMsg(szMess);
					//if (KMsgBox::yesNo(view, "KFileReplace", szMess, KMsgBox::QUESTION) == 2) // No clicked
  			 		return -1;
				}
      			
				// Run the replace operation									
				nRes = ReplaceFile(szFileReadpath, szFileWritepath, &nNewFileSize, argu -> bCaseSensitive, &nNbReplacements, argu);
				if (nRes == 0)
				{	nNbRepFiles++;

					// Update Result ListView		
					fi.setFile(szFileReadpath);
					ListView_AddItem(argu -> lvResult, dir[i], szDir, fi.size(), nNewFileSize, nNbReplacements);
				}
  		
				if (argu -> bBakup) // Create a backup of the file if option is true
				{	sprintf (szBakup, "%s/%s.old", szDir, dir[i]);
					nRes = unlink(szBakup); // Delete OLD file if exists
					nRes = rename(szFileReadpath, szBakup);
				}
				else // Delete the old file
				{	nRes = unlink(szFileReadpath);
				}
			}

			// Rename the new file into OldFileName
 			nRes = rename(szFileWritepath, szFileReadpath);
		}
	}

	// 2. -*-*-*-*-*-*-*-*-*- Second, list all dir -*-*-*-*-*-*-*-*-*-

	if (argu -> bRecursive) // If we must explore sub directories
	{	// What type of files we must lis
		dir.setFilter(QDir::Dirs | QDir::Readable | QDir::Writable | QDir::Executable);
		dir.setPath(szDir);
		dir.setNameFilter("*");

		for (i=0; i < dir.count(); i++)
		{ if (strcmp(dir[i], ".") != 0 && strcmp(dir[i], "..") != 0)
			{	sprintf (szDirpath, "%s/%s", szDir, dir[i]); 	  	
				nRes = ReplaceDirectory(szDirpath, argu); // Use recursivity
				if (nRes == -1) // If error
					return -1; // Stop the operation
				nNbRepFiles += nRes;
			}
		}
	}

	return nNbRepFiles;
}

// ==================================================================================
bool IsFileGoodSizeProperties(char *szFileName, bool bMinSize, bool bMaxSize, uint nMinSize, uint nMaxSize)
{	// If Minimal Size Option is Checked
	QFileInfo fi;
	fi.setFile(szFileName);

	bool bCond = (bMinSize && fi.size() < nMinSize || bMaxSize && fi.size() > nMaxSize);

	return (!bCond);
}

// ==================================================================================
bool IsFileGoodDateProperties(char *szFileName, int nTypeOfAccess, bool bMinDate, bool bMaxDate, QDate qdMinDate, QDate qdMaxDate)
{	// If Minimal Size Option is Checked
	QFileInfo fi;
	fi.setFile(szFileName);
	QDate dateFiledate; // Date of the file we must to compare with dateLimit
	
  // Get the File Date
	if (nTypeOfAccess == 0) // Last WRITE date
		dateFiledate = fi.lastModified().date();
	if (nTypeOfAccess == 1) // Last READ date
		dateFiledate = fi.lastRead().date();

  if (bMinDate && dateFiledate < qdMinDate) // Check the Minimal Date (After ...)
			return false;

  if (bMaxDate && dateFiledate > qdMaxDate) // Check the Maximal Date (Before ...)
			return false;

	return true; // File is valid
}

// ==================================================================================
int DoesFileNeedReplace(char *szOldFile, bool *bNeedReplace, RepDirArg* argu)
{	
	int nFdOldFile; // File descriptors
	uint nOldFileSize;
	char *cBeginOldFile; // Pointer to the begin of the file
	char *cOldPt; // Pointer to the current data
	char szMess[MAX_MESSAGE];
	char *s1, *s2;
	QListViewItem *lviCurItem;
	QListViewItem *lviFirst;
	int nItemPos;
	
	KFileReplaceApp *app;
	app = (KFileReplaceApp *) (argu -> app);

	// 0. Init
	*bNeedReplace = false;
	QFileInfo fiOld(szOldFile);
	nOldFileSize = fiOld.size();

	// 1. Open files
	nFdOldFile = open(szOldFile, O_RDONLY);
	if (nFdOldFile == -1)
	{	sprintf (szMess, i18n("Can't open file %s for reading"), szOldFile);
		app -> slotStatusMsg(szMess);
		//KMsgBox::message(view, "KFileReplace", szMess, KMsgBox::EXCLAMATION, i18n("Cancel"));	
		return -1;
	}

	// Map files
	cBeginOldFile = mmap((caddr_t)0, nOldFileSize, PROT_READ, MAP_SHARED, nFdOldFile, 0);
  	if ((caddr_t) cBeginOldFile == MAP_FAILED)
	{	sprintf (szMess, i18n("Can't open file %s for reading"), szOldFile);
		app -> slotStatusMsg(szMess);
		//KMsgBox::message(view, "KFileReplace", szMess, KMsgBox::EXCLAMATION, i18n("Cancel"));	
		close(nFdOldFile);
		return -1;
	}

	cOldPt = cBeginOldFile;

	nItemPos = 0;
	lviCurItem = lviFirst = argu -> lvText -> firstChild();
	 if (lviCurItem == NULL)
              	 return -1;

	// Copy strings to search/remplace into strings in memory
	char *szOldText[MAX_STRINGSTOSEARCHREP];
	 do
	 {	szOldText[nItemPos] = new char[strlen(lviCurItem -> text(0))];
		if (szOldText[nItemPos] == NULL) // If error
		{	app -> slotStatusMsg(i18n("Out of memory"));
			return -1;
		}	
		
              	strcpy(szOldText[nItemPos], lviCurItem -> text(0));
              	nItemPos++;

              	lviCurItem = lviCurItem -> nextSibling();
	} while(lviCurItem && lviCurItem != lviFirst);

	// --------------------------------------------

	while ( ((cOldPt - (char *) cBeginOldFile) < nOldFileSize)) // While not end of file
	{
		begin_search:

		for (int i=0; i < argu -> lvText -> childCount(); i++) // For all strings to replace
		{
			s1 = cOldPt;
			s2 = (char *) szOldText[i];

			if (argu -> bCaseSensitive == TRUE) // si il faut respecter la casse
				while ( *s1 && *s2 && *s1 == *s2 )
				{	s1++;
					s2++;
				}
			else // si il ne faut pas respecter la casse
				while ( *s1 && *s2 && tolower(*s1) == tolower(*s2) )
				{	s1++;
					s2++;
				}

			if (*s2 == 0) // Si le mot entier est trouv
			{ *bNeedReplace = true;
				// Unamp files and close files
				munmap(cBeginOldFile, nOldFileSize);
				close(nFdOldFile);
      			
				// Free allocated memory
				 for (int j=0; j < argu -> lvText -> childCount(); j++)
					delete szOldText[j];
	
				return 0; // Success
			}
		}

		// Searched Text not present: copy char
		cOldPt++;

	}
	
	// --------------------------------------------

	// Unamp files and close files
	munmap(cBeginOldFile, nOldFileSize);
	close(nFdOldFile);

	// Free allocated memory
	 for (int j=0; j < argu -> lvText -> childCount(); j++)
		delete szOldText[j];

	return 0; // Success
}

// ==================================================================================
int ReplaceFile(char *szOldFile, char *szNewFile, uint *nNewFileSize, bool bCaseSensitive, int *nNbReplacements, RepDirArg* argu)
{	int nFdOldFile, nFdNewFile; // File descriptors
	void *vBeginOldFile;
	char *cBeginOldFile; // Pointer to the begin of the file
	char *cOldPt; // Pointer to the current data
	char szMess[MAX_MESSAGE];
	char *s1, *s2;
	int nRes;
	QListViewItem *lviCurItem;
	QListViewItem *lviFirst;
	uint nOldFileSize;
	int nItemPos;

	KFileReplaceApp *app;
	app = (KFileReplaceApp *) (argu -> app);

	// 0. Init
  	*nNbReplacements = 0;
	QFileInfo fiOld(szOldFile);
	nOldFileSize = fiOld.size();

	// 1. Open files
	nFdOldFile = open(szOldFile, O_RDONLY);
	if (nFdOldFile == -1)
	{	sprintf (szMess, i18n("Can't open file %s for reading"), szOldFile);
		app -> slotStatusMsg(szMess);
		//KMsgBox::message(view, "KFileReplace", szMess, KMsgBox::EXCLAMATION, i18n("Cancel"));	
		return -1;
	}

 	nFdNewFile = open(szNewFile, O_CREAT | O_TRUNC | O_RDWR, S_IRWXU);
	if (nFdNewFile == -1)
	{	sprintf (szMess, i18n("Can't open file %s for writing"), szNewFile);
		app -> slotStatusMsg(szMess);
		//KMsgBox::message(view, "KFileReplace", szMess, KMsgBox::EXCLAMATION, i18n("Cancel"));	
		return -1;
	}

	// Map files
	vBeginOldFile = mmap((caddr_t)0, nOldFileSize, PROT_READ, MAP_SHARED, nFdOldFile, 0);
 	 if ((caddr_t) vBeginOldFile == MAP_FAILED)
	{	sprintf (szMess, i18n("Can't map file %s for reading"), szOldFile);
		close(nFdOldFile);
		app -> slotStatusMsg(szMess);
		//KMsgBox::message(view, "KFileReplace", szMess, KMsgBox::EXCLAMATION, i18n("Cancel"));	
		return -1;
	}
 	
	cBeginOldFile = (char *) vBeginOldFile;
	cOldPt = cBeginOldFile;

        	 // Copy strings to search/remplace into strings in memory
       	char *szOldText[MAX_STRINGSTOSEARCHREP];
       	char *szNewText[MAX_STRINGSTOSEARCHREP];

	nItemPos = 0;
      	 lviCurItem = lviFirst = argu -> lvText -> firstChild();
       	 if (lviCurItem == NULL)
               	return -1;

       	do
       	{	szOldText[nItemPos] = new char[strlen(lviCurItem -> text(0))];
		if (szOldText[nItemPos] == NULL) // If error
		{	app -> slotStatusMsg(i18n("Out of memory"));
			 return -1;
		}	
		
       		szNewText[nItemPos] = new char[strlen(lviCurItem -> text(1))];
		if (szNewText[nItemPos] == NULL) // If error
		{	app -> slotStatusMsg(i18n("Out of memory"));
			 return -1;
		}	
		
		strcpy(szOldText[nItemPos], lviCurItem -> text(0));
		strcpy(szNewText[nItemPos], lviCurItem -> text(1));
		 nItemPos++;

		lviCurItem = lviCurItem -> nextSibling();
	 } while(lviCurItem && lviCurItem != lviFirst);

	// --------------------------------------------
	while ( ((cOldPt - (char *) cBeginOldFile) < nOldFileSize)) // While not end of file
	{	begin_replace:

		for (int i=0; i < nItemPos; i++) // For all strings to replace
		{	
			s1 = cOldPt;
			s2 = (char *) szOldText[i];

			if (bCaseSensitive == TRUE) // si il faut respecter la casse
				while ( *s1 && *s2 && *s1 == *s2 )
				{	s1++;
					s2++;
				}
			else // si il ne faut pas respecter la casse
				while ( *s1 && *s2 && tolower(*s1) == tolower(*s2) )
				{	s1++;
					s2++;
				}

			if (*s2 == 0) // Si le mot entier est trouv
			{	// Remplacer
				(*nNbReplacements)++;
				
				// Write new text in new file
				nRes = write(nFdNewFile, szNewText[i], strlen(szNewText[i]));
				if (nRes != strlen(szNewText[i]))
				{	// Free allocated memory
				 	for (int j=0;  j < nItemPos ; j++)
					{	delete szOldText[j];
						delete szNewText[j];
					}
					return -1;
				}

				cOldPt += strlen(szOldText[i]); // Dans le fichier en lecture (ancien) on passe le chaine cherche
				goto begin_replace; // Do not make other replace on this byte
			}

		} ;

		// Searched Text not present: copy char
		nRes = write(nFdNewFile, cOldPt, 1);
		if (nRes != 1)
		{	for (int j=0; j < nItemPos; j++)
			{	delete szOldText[j];
				delete szNewText[j];
			}

			return -1;
		}

		cOldPt++;
	}
	
	// --------------------------------------------

	// Unamp files
	munmap(vBeginOldFile, nOldFileSize);

	// Close files
	close(nFdOldFile);
	close(nFdNewFile);

	// Get New file size
	QFileInfo fiNew(szNewFile);
	*nNewFileSize = fiNew.size();

	// Free allocated memory
	for (int j=0; j < nItemPos; j++)
	{	delete szOldText[j];
		delete szNewText[j];
	}

	return 0; // Success
}


// ===========================================================================================================================
int ListView_AddItem(QListView *lv, char *szName, char *szDirectory, uint nOldSize, uint nNewSize, int nNbRepl)
{
	char szOldSize[128];
	char szNewSize[128];
	char szNbRepl[128];

	// Prepare text to add
	sprintf (szOldSize, "%ld Ko", nOldSize / 1024);
	sprintf (szNewSize, "%ld Ko", nNewSize / 1024);
	sprintf (szNbRepl, "%ld", nNbRepl);
	
	// Add item to list
	QListViewItem *lvi;

	lvi = new QListViewItem(lv);
  CHECK_PTR( lvi );

	lvi -> setText(0, szName);
	lvi -> setText(1, szDirectory);
	lvi -> setText(2, szOldSize);
	lvi -> setText(3, szNewSize);
	lvi -> setText(4, szNbRepl);
	//lvi -> SetPixmap(); // To add icons in the ListView: icon of the type of documents

	return 0;
}

// ===========================================================================================================================
int GetDiskFreeSpaceForFile(uint *nAvailDiskSpace, char *szFilename)			
{
	int nRes;
	struct statfs fsInfo;

	*nAvailDiskSpace = 0;

	nRes = statfs(szFilename, &fsInfo);
	if (nRes == -1)	
		return -1;	

  *nAvailDiskSpace = fsInfo.f_bavail * fsInfo.f_bsize;

	return 0;
}

























































