/***************************************************************************
                          kfilecoder.cpp  -  description                              
                             -------------------                                         
    begin                : lun mai  3 20:19:52 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@voila.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kfilecoder.h"
#include "kfilecoderdoc.h"

#include <qpushbt.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qstrlist.h>
#include <qprogressdialog.h>
#include <qwhatsthis.h>
#include <qdragobject.h>
#include <qfileinfo.h>
#include <qcstring.h>

#include <kprogress.h>
#include <kmessagebox.h>
#include <kaccel.h>
#include <kiconloader.h>
#include <kstdaccel.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kpropsdlg.h>
#include <krun.h>
#include <kstddirs.h>
#include <kiconloader.h>
#include <kio/netaccess.h>
#include <kaboutdialog.h>
#include <kpassdlg.h>
#include <kurl.h>
#include <kfiledialog.h>

//#include "PassDialog.h"
#include "PropDlg.h"
#include "ExtractDialog.h"
#include "filegest.h"

#include <unistd.h>


// ===========================================================================================================================
KFileCoderApp::KFileCoderApp()
{
  setCaption("KFileCoder " VERSION);

  ///////////////////////////////////////////////////////////////////
  // read the config file options
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();
  initView();

  ///////////////////////////////////////////////////////////////////
  // enable bars dependend on config file setups
  if (!bViewToolbar)
    enableToolBar(KToolBar::Hide,0);
  if (!bViewStatusbar)
    enableStatusBar(KStatusBar::Hide);
    
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
  updateCommandsAccess();

  // Prepare the Drag & Drop
  setAcceptDrops(true);
	
  setWhatsThis();
}

// ===========================================================================================================================
KFileCoderApp::~KFileCoderApp()
{
  
}

// ===========================================================================================================================
void KFileCoderApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

// ===========================================================================================================================
void KFileCoderApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}

// ===========================================================================================================================
void KFileCoderApp::updateCommandsAccess()
{	
	// If archive opened
	if (doc -> isArchiveOpened() == TRUE)
	{	disableCommand(ID_FILE_NEW);
		disableCommand(ID_FILE_OPEN);
		disableCommand(ID_FILE_OPEN);
		enableCommand(ID_FILE_CLOSE);
		enableCommand(ID_FILE_PROP);
	
		enableCommand(ID_ARCHIVE_ADD);
		enableCommand(ID_ARCHIVE_EXTRACT_ALL);
		enableCommand(ID_ARCHIVE_EXTRACT_SEL);
		enableCommand(ID_ARCHIVE_DELETE);
	}

	// If archive closed
	if (doc -> isArchiveOpened() == FALSE)
	{	enableCommand(ID_FILE_NEW);
		enableCommand(ID_FILE_OPEN);
		disableCommand(ID_FILE_CLOSE);
		disableCommand(ID_FILE_PROP);
	
		disableCommand(ID_ARCHIVE_ADD);
		disableCommand(ID_ARCHIVE_EXTRACT_ALL);
		disableCommand(ID_ARCHIVE_EXTRACT_SEL);
		disableCommand(ID_ARCHIVE_DELETE);
	}
}

// ===========================================================================================================================
void KFileCoderApp::setWhatsThis()
{
	setCommandWhatsThis(ID_ARCHIVE_ADD, i18n("Add one on more files to the current archive. They will be encoded with the current password"));
	setCommandWhatsThis(ID_ARCHIVE_EXTRACT_ALL, i18n("Extract all files of the archive to the directory you will have to select"));
	setCommandWhatsThis(ID_ARCHIVE_EXTRACT_SEL, i18n("Extract only selected files of the archive to the directory you will select"));
	setCommandWhatsThis(ID_ARCHIVE_DELETE, i18n("Delete the selected files of the archive. After, they won't be in archive."));
}

// ===========================================================================================================================
void KFileCoderApp::setCommandWhatsThis(int nCommand, QString strMessage)
{
    // Set text to the toolbar
    QWidget *wToolbarButton;
    wToolbarButton = (QWidget *) toolBar()->getButton(nCommand);
	if (wToolbarButton)
   		QWhatsThis::add(wToolbarButton, strMessage);

    // Add text to all existing menus: in olny one case there won't be an error
    file_menu->setWhatsThis(nCommand, strMessage);
    extract_menu->setWhatsThis(nCommand, strMessage);
    archive_menu->setWhatsThis(nCommand, strMessage);   
}

// ===========================================================================================================================
void KFileCoderApp::initMenuBar()
{
  KStdAccel stdAccel;
   KIconLoader &loader = *KGlobal::iconLoader();
	
  ///////////////////////////////////////////////////////////////////
  // MENUBAR  

  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  file_menu = new QPopupMenu();
  file_menu->insertItem(kapp->miniIcon(), i18n("New &Window"), ID_FILE_NEW_WINDOW );
  file_menu->insertSeparator();
  file_menu->insertItem(loader.loadIcon("filenew", KIconLoader::Small), i18n("&New"), ID_FILE_NEW );
  file_menu->insertItem(loader.loadIcon("fileopen", KIconLoader::Small), i18n("&Open..."), ID_FILE_OPEN );


  // *-*-*-*-*-*-*-*-*-*- Recent File List *-*-*-*-*--*-*-*-*-*-*-*-*-*-
  recentPop = new QPopupMenu;
  recentPop -> clear();
  for (int i = 0; i < (int) recentFileList.count(); i++)
    recentPop -> insertItem(recentFileList.at(i));

  file_menu->insertItem(i18n("Open &Recent"), recentPop);
  connect( recentPop, SIGNAL(activated(int)), SLOT(slotOpenRecent(int)));
  // *-*-*-*-*-*-*-*-*-*- Recent File List *-*-*-*-*--*-*-*-*-*-*-*-*-*-

  file_menu->insertSeparator();
  file_menu->insertItem(i18n("&Close"), ID_FILE_CLOSE );
  file_menu->insertSeparator();
  file_menu->insertItem(loader.loadIcon("fileprop", KIconLoader::Small), i18n("&Properties"), ID_FILE_PROP );
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"), ID_FILE_QUIT );

  // file_menu key accelerators
  file_menu->setAccel(stdAccel.openNew(), ID_FILE_NEW);
  file_menu->setAccel(stdAccel.open(), ID_FILE_OPEN);
  file_menu->setAccel(stdAccel.close(), ID_FILE_CLOSE);
  file_menu->setAccel(stdAccel.quit(), ID_FILE_QUIT);


	extract_menu = new QPopupMenu();
	extract_menu -> insertItem(loader.loadIcon("extract", KIconLoader::Small), i18n("Extract &All"), ID_ARCHIVE_EXTRACT_ALL);
	extract_menu -> insertItem(loader.loadIcon("extract", KIconLoader::Small), i18n("Extract &Selected"), ID_ARCHIVE_EXTRACT_SEL);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry edit_menu
  archive_menu = new QPopupMenu();
  archive_menu->insertItem(loader.loadIcon("add", KIconLoader::Small), i18n("&Add"), ID_ARCHIVE_ADD );
  archive_menu->insertItem(loader.loadIcon("extract", KIconLoader::Small), i18n("&Extract"), extract_menu);
  archive_menu->insertItem(loader.loadIcon("delete", KIconLoader::Small), i18n("&Delete"), ID_ARCHIVE_DELETE );
 
  //archive_menu key accelerators
  archive_menu->setAccel(CTRL+Key_A, ID_ARCHIVE_ADD);
  archive_menu->setAccel(CTRL+Key_X, ID_ARCHIVE_EXTRACT_ALL);
  archive_menu->setAccel(CTRL+Key_S, ID_ARCHIVE_EXTRACT_SEL);
  archive_menu->setAccel(CTRL+Key_D, ID_ARCHIVE_DELETE);


  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem(i18n("Tool&bar"), ID_VIEW_TOOLBAR);
  view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );

  view_menu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  view_menu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);

  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE
  
  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar and the position due to config file
  menuBar()->insertItem(i18n("&File"), file_menu);
  menuBar()->insertItem(i18n("&Edit"), archive_menu);
  menuBar()->insertItem(i18n("&View"), view_menu);
  menuBar()->insertItem(i18n("&Help"), helpMenu());

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  CONNECT_CMD(file_menu);
  CONNECT_CMD(archive_menu);
  CONNECT_CMD(extract_menu);
  CONNECT_CMD(view_menu);
}

// ===========================================================================================================================
void KFileCoderApp::initToolBar()
{
   KIconLoader &loader = *KGlobal::iconLoader();

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  // set toolBar() the current toolBar and the position due to config file
  toolBar()->insertButton(loader.loadIcon("filenew", KIconLoader::Small), ID_FILE_NEW, true, i18n("New File"));

  toolBar()->insertButton(loader.loadIcon("fileopen", KIconLoader::Small), ID_FILE_OPEN, true, i18n("Open File"));
  toolBar()->setDelayedPopup(ID_FILE_OPEN, recentPop);

  toolBar()->insertSeparator();
  toolBar()->insertButton(loader.loadIcon("fileprop", KIconLoader::Small), ID_FILE_PROP, true, i18n("File Properties"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(loader.loadIcon("add", KIconLoader::Small), ID_ARCHIVE_ADD, true, i18n("Add"));
  toolBar()->insertButton(loader.loadIcon("extract", KIconLoader::Small), ID_ARCHIVE_EXTRACT_ALL, true, i18n("Extract all"));
  toolBar()->insertButton(loader.loadIcon("delete", KIconLoader::Small), ID_ARCHIVE_DELETE, true, i18n("Delete"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(BarIcon("context_help"), ID_HELP_WHATSTHIS, true, i18n("What's this ?"));

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE -e.g. tool_bar_1:
  // add functionality for new created toolbars in:
  // enableCommand, disableCommand, in the menuBar() and an additional function slotViewToolbar_1
  // for that also create a bViewToolbar_1 and a KConfig entry (see Constructor).
  // Also update resource values and commands 


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars
  CONNECT_TOOLBAR(toolBar());

}

// ===========================================================================================================================
void KFileCoderApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->insertItem(IDS_DEFAULT, ID_STATUS_MSG );
}

// ===========================================================================================================================
void KFileCoderApp::initView()
{ 
        doc = new KFileCoderDoc(this);

        ////////////////////////////////////////////////////////////////////
        // set the main widget here
  
        view = new QListView(this);
        view->setAcceptDrops(false); // Drag & Drop
        QWhatsThis::add(view, i18n("The list of all the files of the archive"));

	setView(view);
        doc -> setListView(view);
	
	view -> addColumn(i18n("Name"), 250);
	
	view -> addColumn(i18n("Size"), 100);
	view -> setColumnAlignment(1, 2);

	view -> addColumn(i18n("CRC"), 100);
	view -> setColumnAlignment(2, 2);

	view -> addColumn(i18n("Path"), 200);

	view -> setSorting(-1); // Disable sorting for all columns
	view -> setMultiSelection(TRUE);

	view -> setFrameStyle(QFrame::Panel | QFrame::Sunken);
	view -> setLineWidth(2);
}

// ===========================================================================================================================
void KFileCoderApp::closeEvent (QCloseEvent *event)
{	saveOptions();
	KTMainWindow::closeEvent(event);
}

// ===========================================================================================================================
void KFileCoderApp::slotFileProperties()
{	PropDlg dlg(doc -> getArchiveFile(), doc -> getNbFiles(), doc -> getAlgoUsed(), this, NULL);
	dlg.exec();
}

// ===========================================================================================================================
void KFileCoderApp::saveOptions()
{
    KConfig *config = kapp->config();

    config->setGroup("General Options");
    config->writeEntry("Geometry", size());
    config->writeEntry("ShowToolbar",toolBar()->isVisible());
    config->writeEntry("ShowStatusbar", statusBar()->isVisible());
    //config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
    config->writeEntry("ToolBarPos", (int)toolBar()->barPos());

    // Save Recent Open File List
    config->setGroup("Recently Opened Files");
    QString recent_number;
    for(int i = 0; i < (int) recentFileList.count(); i++)
    {	recent_number.setNum(i+1);
	config->writeEntry(recent_number.data(),recentFileList.at(i));
    }
}

// ===========================================================================================================================
void KFileCoderApp::readOptions()
{
    KConfig *config = kapp->config();
    QSize size;

    config->setGroup("General Options");
    size = config -> readSizeEntry("Geometry");
    if (size.isEmpty()) // If no size ==> Default size
    {  size = QSize(320,240);
	move(0,0);
    }

    resize(size);

    bViewToolbar = config->readBoolEntry("ShowToolbar", true);
    bViewStatusbar = config->readBoolEntry("ShowStatusbar", true);
    //KMenuBar::menuPosition menu_bar_pos = (KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top);
    KToolBar::BarPosition tool_bar_pos = (KToolBar::BarPosition)config->readNumEntry("ToolBarPos", KToolBar::Top);

    if (!bViewToolbar)
	enableToolBar(KToolBar::Hide);

    if (!bViewStatusbar)
	enableStatusBar(KStatusBar::Hide);

    //menuBar() -> setMenuBarPos(menu_bar_pos);
    toolBar() -> setBarPos(tool_bar_pos);

    // Load Recent Open File List
    QString str;
    recentFileList.clear();
    config->setGroup("Recently Opened Files");

    QString strNum;

    for (int i=0; i < 5; i++)
    {	strNum.setNum(i+1);
	str = config -> readEntry(strNum, "");
	if (!str.isEmpty())
        {       KURL urlFile(str.data());
                if (!(urlFile.isLocalFile()) || QFile::exists(urlFile.path().data()))
                        recentFileList.append(str);
        }
    }

}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

// ===========================================================================================================================
void KFileCoderApp::slotFileOpen()
{
	KURL urlFile;

	urlFile = KFileDialog::getOpenURL(QString::null, i18n("*.kfc|KFileReplace archives (*.kfr)\n*|All files (*.*)"), this, i18n("Open KFileCoder archive"));
	if (urlFile.isEmpty())
	    return;

        openURL(urlFile);
}

// ===========================================================================================================================
void KFileCoderApp::openURL(KURL urlFile)
{
        QString strFilename;
	int nRes;
        QFileInfo fi;

        // Download file if need (if url is "http://...")
	if (!(KIO::NetAccess::download(urlFile, strFilename))) // Open the Archive
                return;

	// Check it's not a directory
	fi.setFile(strFilename);
	if (fi.isDir())
	{	KMessageBox::error(this, i18n("Can't open directories."));
		return;
	}

	nRes = doc -> openArchive(strFilename.data());
	if (nRes == -1)
		return;

	addRecentFileToList(urlFile);

	// Update menu & toolbar commands
	updateCommandsAccess();
}

// ===========================================================================================================================
void KFileCoderApp::dragEnterEvent(QDragEnterEvent *event)
{
	event -> accept(QUriDrag::canDecode(event));
}

// ===========================================================================================================================
void KFileCoderApp::dropEvent(QDropEvent *event)
{
	QStrList urls;

	if (QUriDrag::decode(event, urls))
	{
		if (urls.first())
		{	openURL(urls.first());
		}
	}
}

// ===========================================================================================================================
void KFileCoderApp::slotFileNew()
{       int nAlgorithm;
	QString strFilename;
	int nRes;
        KURL urlFile;

        // Select the new file
        strFilename = KFileDialog::getSaveFileName(QString::null, i18n("*.kfc|KFileReplace archives (*.kfr)\n*|All files (*.*)"), this,i18n("New KFileCoder archive"));
        if (strFilename.isEmpty())
                return;

        // Force the extension to be "kfc"
	if(strFilename.length() > 3)
	{	QString strExt = strFilename.right(4);
		if (strExt != ".kfc" && strExt.right(1) != ".")
			strFilename += ".kfc";
	}
        else
	        strFilename += ".kfc";

	// Dialog to ask password ==> szPassword
	QCString strPass;
	nRes = KPasswordDialog::getNewPassword(strPass, i18n("Please, enter the password which will be used to encode files."));
	if (nRes != KPasswordDialog::Accepted)
	    return;

	// TODO = Dialog to ask Algorithm to use
	nAlgorithm = ALGO_ALG1XOR; // TEMPORARY

        //urlFile.setFileName(strFilename);
	addRecentFileToList(strFilename.data());

	nRes = doc -> createArchive(strFilename.data(), strPass.data(), nAlgorithm);
	if (nRes == -1)
		return;
	
	// Propose to add files to archive
	slotArchiveAdd();

	// Update menu & toolbar commands
	updateCommandsAccess();
}

// ===========================================================================================================================
void KFileCoderApp::slotFileClose()
{
 	doc -> closeArchive();
}

// ===========================================================================================================================
void KFileCoderApp::slotArchiveAdd()
{	QStringList strlFileList;
	QString strCurrentFile;
	int nRes;
	int nPos = 0; // Nb of files added
        KURL::List urlFilesList;

	// The user select files to add to archive
	urlFilesList = KFileDialog::getOpenURLs(QString::null, QString::null,this,i18n("Add files to archive"));
        if (urlFilesList.count() == 0)
                return;

	// Draw the progress dialog
	QProgressDialog dlgProgress(i18n("Adding files to archive..."),0, strlFileList.count(), this,"",true);
        dlgProgress.setCaption("KFileCoder");
	dlgProgress.show();
	dlgProgress.setProgress(nPos);

	for (int i=0; i < urlFilesList.count(); i++) // While not end of list
	{	// Add a file to archive
		nRes = doc -> addFile(urlFilesList[i]);
		dlgProgress.setProgress(++nPos);
		if (dlgProgress.wasCancelled())
		    break;

	}

	// Redraw the List View
	doc -> listView_Fill();
}

// ===========================================================================================================================
void KFileCoderApp::slotArchiveExtractAll()
{
	char szDestPath[MAXPATHLEN];
	int nRes;	

	// Dialog to select the destination directory
	ExtractDialog extractDlg(this, (const char*) 0);
	nRes = extractDlg.exec();
	if (nRes == -1)
		return;

	sprintf (szDestPath, "%s", extractDlg.getDestinationDirectory());

	doc -> extractFiles(szDestPath, false);
}

// ===========================================================================================================================
void KFileCoderApp::slotArchiveExtractSel()
{
	char szDestPath[MAXPATHLEN];
	int nRes;	

	// Dialog to select the destination directory
	ExtractDialog extractDlg(this, (const char*) 0);
	nRes = extractDlg.exec();
	if (nRes == -1)
		return;

	sprintf (szDestPath, "%s", extractDlg.getDestinationDirectory());

	doc -> extractFiles(szDestPath, true);
}

// ===========================================================================================================================
void KFileCoderApp::slotArchiveDelete()
{
  doc -> deleteSelectedFilesInArchive();
}

// ===========================================================================================================================
void KFileCoderApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new Application window..."));
  (new KFileCoderApp)->show();
  slotStatusMsg(IDS_DEFAULT);
}

// ===========================================================================================================================
void KFileCoderApp::slotFileQuit()
{
  slotFileClose();

  ///////////////////////////////////////////////////////////////////
  // exits the Application

    saveOptions();
    KTMainWindow *w;
    if (memberList)
    {	for (w=memberList->first(); w; w = memberList->first())
	{
             if (!w->close())
	         break;
	}
    }
    
    kapp->quit();
}

// ===========================================================================================================================
void KFileCoderApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  bViewToolbar=!bViewToolbar;
  menuBar()->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  enableToolBar(KToolBar::Toggle,0);
  slotStatusMsg(IDS_DEFAULT);

}

// ===========================================================================================================================
void KFileCoderApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  bViewStatusbar=!bViewStatusbar;
  menuBar()->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  enableStatusBar();
  slotStatusMsg(IDS_DEFAULT);
}


// ===========================================================================================================================
void KFileCoderApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}

// ===========================================================================================================================
void KFileCoderApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}

// ===========================================================================================================================
void KFileCoderApp::slotOpenRecent(int i)
{
        QString strUrl;
        int nRes;

	strUrl = recentPop->text(i);
        //recentFileList.at(i);

        fprintf(stderr,"%s",strUrl.data());

	if (strUrl.isEmpty())
		return ;

	// Open the Archive
        KURL urlFile(strUrl);
        openURL(urlFile);

	// Dialog to ask password ==> szPassword
	/*QCString strPass;
	nRes = KPasswordDialog::getNewPassword(strPass,i18n("Please, enter the password used to encode files."));
	if (nRes != KPasswordDialog::Accepted)
	    return;

	sprintf(szPassword,"%s",strPass.data());
	sprintf (szFilename, "%s", strFilename.data());
	nRes = doc -> openArchive(szFilename, szPassword);
	if (nRes == -1)
		return;
	
	// Update menu & toolbar commands
	updateCommandsAccess();*/
}					

// ===========================================================================================================================
void KFileCoderApp::showAboutApplication(void)
{   // 1. Create the base of the dialog
    KAboutDialog dlg(KAboutDialog::AbtAppStandard | KAboutDialog::AbtImageLeft, "kfilecoder", KAboutDialog::Close, KAboutDialog::Close, topLevelWidget(), "kfilecoder", true);
    dlg.setTitle("KFileCoder for KDE 2");
    dlg.setImage(locate("data", "kfilecoder/pics/about.png"));
    dlg.setImageFrame(false);
    dlg.setProduct(QString(PACKAGE), QString(VERSION), QString("Franois Dupoux"), QString("2000"));
    
    // 2. Add text to the dialog
    QString strUseful = i18n("KFileCoder is an application which allows you to encoder files\n"
    	"in an archive with a password. Then you can easily send all files of a directory with\n"
    	"an only file, and with a protection. Only people who have the password can read or\n"
    	"modify the archive\n");
	
    QString strContribute = i18n("Everyone is welcome to contribute to the KFileCoder project.\n"
    "You don't have to be a developer to do it. You can do many things:\n"
    "- Write the SGML documentation in english\n"
    "- Translate the SGML documentation, or the program strings (in PO files)\n"
    "- Draw new icons\n"
    "- Write some C++ code to add new features\n"
    "- Send ideas about new features which wan be useful\n"
    "\n"
    "Please, contact the author if you want to works to help this project, then we will\n"
    "check the work is not already done, or being done. You also need to download\n"
    "the last version before writing anything: don't translate an old documentation version!\n\n"
	"For more details about what to do, please read the TODO file.");
    
    // About page
    KAboutContainer *cAbout=dlg.addContainerPage(i18n("&About"), KAboutDialog::AlignCenter, KAboutDialog::AlignLeft);
    if (cAbout != 0)
    {	QString strText1 = i18n("KFileCoder is distributed under the GNU GPL (General Public License) license.\n"
	"Then everybody can use this application, copy it, and distribute it.\n\n"
	"Please, report all bugs you find to the author.\n\n"
	"For more details about what to do, read the TODO file.");
	
	cAbout -> addWidget( new QLabel(strText1, topLevelWidget() ) ); 
	cAbout -> addPerson(QString::null, QString("fdupoux@voila.fr"), QString("http://perso.club-internet.fr/dupoux/sysexp/linux/kfilecod/"), QString::null, true);   
    }
    
    // Text pages
    dlg.addTextPage(i18n("&What KFileCoder does"), strUseful);
    dlg.addTextPage(i18n("&Contribute"), strContribute);

    // Authors page
    KAboutContainer *cAuthors=dlg.addContainerPage(i18n("Aut&hors"), KAboutDialog::AlignCenter, KAboutDialog::AlignLeft);
    if (cAuthors != 0)
    {	cAuthors -> addPerson(QString("Franois Dupoux"), QString("fdupoux@voila.fr"), QString::null, QString("Main author and French translator"), true);   
	   
    }
        
    dlg.show();
    return;
}

// ===========================================================================================================================
void KFileCoderApp::addRecentFileToList(KURL urlFile)
{
        int i;

        fprintf(stderr,"ADDING (%s)\n", urlFile.decodedURL().data());

	// Check file in not already in the list
	for (i=0; i < (int) recentFileList.count(); i++)
	{       if (urlFile.decodedURL() == recentFileList.at(i)) // if file is already in the list
	                return ;
        }

        if( recentFileList.count() >= 5)
                recentFileList.remove(4);

	recentFileList.insert(0, urlFile.decodedURL());

	// Redraw menu
        recentPop -> clear();
        for (i = 0; i < (int) recentFileList.count(); i++)
                recentPop -> insertItem(recentFileList.at(i));
}

// ===========================================================================================================================
void KFileCoderApp::slotHelpWhatsThis()
{
    QWhatsThis::enterWhatsThisMode();
}

// ===========================================================================================================================
void KFileCoderApp::commandCallback(int id_)
{
  switch (id_)
	{
    ON_CMD(ID_FILE_NEW_WINDOW,          slotFileNewWindow())
    ON_CMD(ID_FILE_NEW,                 slotFileNew())
    ON_CMD(ID_FILE_OPEN,                slotFileOpen())
    ON_CMD(ID_FILE_CLOSE,               slotFileClose())
    ON_CMD(ID_FILE_PROP,                slotFileProperties())
    ON_CMD(ID_FILE_QUIT,                slotFileQuit())

    ON_CMD(ID_ARCHIVE_ADD,              slotArchiveAdd())
    ON_CMD(ID_ARCHIVE_EXTRACT_ALL,      slotArchiveExtractAll())
    ON_CMD(ID_ARCHIVE_EXTRACT_SEL,      slotArchiveExtractSel())
    ON_CMD(ID_ARCHIVE_DELETE,           slotArchiveDelete())
  
    ON_CMD(ID_VIEW_TOOLBAR,             slotViewToolBar())
    ON_CMD(ID_VIEW_STATUSBAR,           slotViewStatusBar())

    ON_CMD(ID_HELP_WHATSTHIS,            slotHelpWhatsThis())
  }
}

// ===========================================================================================================================
void KFileCoderApp::statusCallback(int id_)
{
  switch (id_)
	{
    ON_STATUS_MSG(ID_FILE_NEW_WINDOW,      i18n("Opens a new application window"))
    ON_STATUS_MSG(ID_FILE_NEW,             i18n("Creates a new archive"))
    ON_STATUS_MSG(ID_FILE_OPEN,            i18n("Opens an existing archive"))
    ON_STATUS_MSG(ID_FILE_CLOSE,           i18n("Closes the actual archive"))
    ON_STATUS_MSG(ID_FILE_PROP,            i18n("Draw informations and properties of the file"))
    ON_STATUS_MSG(ID_FILE_QUIT,            i18n("Exits the program"))

    ON_STATUS_MSG(ID_ARCHIVE_ADD,          i18n("Add files to the archive"))
    ON_STATUS_MSG(ID_ARCHIVE_EXTRACT_ALL,  i18n("Extract all files of the archive"))
    ON_STATUS_MSG(ID_ARCHIVE_EXTRACT_SEL,  i18n("Extract selected files"))
    ON_STATUS_MSG(ID_ARCHIVE_DELETE,       i18n("Delete selected files in the archive"))

    ON_STATUS_MSG(ID_VIEW_TOOLBAR,         i18n("Enables / disables the actual Toolbar"))
    ON_STATUS_MSG(ID_VIEW_STATUSBAR,       i18n("Enables / disables the Statusbar"))
  }
}

// ===========================================================================================================================
/** Create the text with a size in KB, MB, or Bytes*/
QString formatSize(uint nSize)
{	QString strSize;
	double dSize;
	
	if (nSize < 1024) // In Bytes
	{	strSize.sprintf(i18n("%ld bytes"), nSize);
	}
        else if (nSize < 1024 * 1024) // In KiloBytes
	{	dSize = ((double) nSize) / ((double) 1024.0);
		strSize.sprintf(i18n("%.2f KB"), (float) dSize);
	}
        else if (nSize < 1024 * 1024 * 1024) // In MegaBytes
	{	dSize = ((double) nSize) / ((double) (1024.0 * 1024.0));
		strSize.sprintf(i18n("%.2f MB"), (float) dSize);
	}
        else // In GigaBytes
	{	dSize = ((double) nSize) / ((double) (1024.0 * 1024.0 * 1024.0));
		strSize.sprintf(i18n("%.2f GB"), (float) dSize);
	}

	return strSize;
}


















































































