#include <qbitarray.h>
#include <qdatastream.h>

ASmartWidget::ASmartWidget(const char* name):
  QWidget(name),
  DCOPObject("ASmartWidget")
  {
    QVBoxLayout *lay = new QVBoxLayout (this, 10, 10);
    l_front = new QLabel("Hello, I'm a smart widget", this);
    lay->addWidget (front);
  }

void ASmartWidget::changeFront(DCOPClientTransaction* aTransaction,
             DCOPQString& l) {

  bool succeeded = false;

  // time consuming data processing -
  //    complex filter and cruncher for the contents of l
  // for (...) {
  // ...
  // }

  if (l.find("smart") != -1) { // or other interesting condition
    l_front->setText( l );
    succeeded = true;
  } else
    succeeded = false;

  frontIsChanged(aTransaction, succeeded);
}

bool ASmartWidget::process(const QCString &fun,
                           const QByteArray &data,
                           QCString &reply_type,
                           QByteArray &reply_data) {

  if (fun == "setFront(QString)") {

    DCOPClientTransaction *myTransaction;
    newTransaction = kapp->dcopClient()->beginTransaction();

    QDataStream arg(data, IO_ReadOnly);
    QString& atext;
    arg >> atext;

    Q_INT32 trId = kapp->dcopClient()->transactionId();
    // trId == 0 if no transaction
    if (trId) {
      changeFront(newTransaction, atext);
      kdDebug << "Transaction " << trId << " established!" << endl;
      return true;
    } else {
      kdDebug << "Processing DCOP call failed. No transaction accepted!" << endl;
      return false;

  } else {
      kdDebug << "Processing DCOP call failed. Function unknown!" << endl;
      return false;
}

void ASmartWidget::frontIsChanged(DCOPClientTransaction* aTransaction, bool data) {

  QByteArray reply_data;
  QDataStream answer(reply_data, IO_WriteOnly);
  answer << data;
  QCString reply_type = "bool";
  kapp->dcopClient()->endTransaction(aTransaction, reply_type, reply_data);

}

