#include <qpainter.h>
#include <qpixmap.h>

#include <kapp.h>

#include "kquickdraw.h"


KQuickDraw::KQuickDraw (QWidget *parent, const char *name=0) :
  QWidget (parent, name)
{
  bneedrecreate=true;
  qpixmap=0;

  for (int i=0; i<NEllipses; i++)
    {
      x[i]=(kapp->random()%100)/100.;
      y[i]=(kapp->random()%100)/100.;
    }

  setBackgroundMode (NoBackground);
      
}

void
KQuickDraw::paintEvent (QPaintEvent *)
{

  if (bneedrecreate)
    {
      if (qpixmap!=0)
	delete qpixmap;
      qpixmap = new QPixmap (width(), height());

      QPainter qpainter;
      qpainter.begin (qpixmap, this);
      qpainter.fillRect (qpixmap->rect(), white);
      qpainter.setBrush (blue);
      int w = width()/10;
      int h = height()/10;
      for (int i=0; i<NEllipses; i++)
	qpainter.drawEllipse (x[i]*width(), y[i]*height(), w, h);

      bneedrecreate=false;
    }

  bitBlt (this, 0, 0, qpixmap);

}

void
KQuickDraw::resizeEvent (QResizeEvent *)
{
  bneedrecreate = true;
}
