#include <kapp.h>
#include <kaction.h>
#include <kstdaction.h>

#include "klongjob.moc"

KLongJob::KLongJob (const char *name=0) :
  KTMainWindow (name)
{
  start = 
    new KAction ("&Start", 0,  this, SLOT(slotCompute()), 
		 actionCollection(), "start");
  stop =
    new KAction ("Sto&p", 0,  this, SLOT(slotStopComputation()), 
		 actionCollection(), "stop");

  KStdAction::quit (kapp, SLOT(closeAllWindows()),
		    actionCollection());

  createGUI();

  stop->setEnabled (false);

  qlabel = new QLabel (this);
  qlabel->setAlignment (QLabel::AlignCenter);
  setView (qlabel);
}

void
KLongJob::slotStopComputation()
{
  bcontinuecomputation=false;
}

void
KLongJob::slotCompute()
{
  double deviation;
  int i;
  count=total=0;

  bcontinuecomputation=true;

  start->setEnabled (false);
  stop->setEnabled (true);

  kapp->processEvents();

  for (i=0; i<1000000 && bcontinuecomputation; i++)
    {
      if (kapp->random()%2==1)
	count++;
      total++;

      if (!(total%100))
	kapp->processEvents();


      if (!(total%5000))
	{
	  deviation = (count - total/2.)/(double)total;
	  QString qstring;
	  qstring.
	    sprintf ("Total flips: %10d\nDeviation from 50%% heads: %10.5f",
		     total, deviation);
	  qlabel->setText (qstring);
	}
    }

  start->setEnabled (true);
  stop->setEnabled (false);

}




